// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/WireLook.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:36 $
// $State: Exp $
// **************************************************************

#ifndef WireLook_h
#define WireLook_h

#include <qpoint.h>
#include <qstring.h>

class Wire;
class Wirebox;
class ModuleLook;
class Connector;

class WireLook
{
    /**
     * Refers to the actual wire. The wire does NOT live here!
     */
    Wire *wire;
    
    /**
     * Describes, which two elements are wired. module_look[0]'s signal is wired
     * to a module_look[1]'s slot.
     */
    const ModuleLook *module_look[2];
    
    /**
     * Start and end point of non-rubberband nicely layouted wire. Measured
     * in grid.
     */
    QPoint gridposition[2];

    /**
     * Gives the exact path of the nicely layouted wire from gridposition[0] (signal) to
     * gridposition[1] (slot). This is a string matching [NWSE]*
     */
    QString path; // "NNEENENNEESSWW..."

    /**
     * Indexed color number (or color/pattern code)
     */
    short color;
    
public:
    WireLook(const ModuleLook *ml0, const ModuleLook *ml1, Wire *w);

    /**
     * Returns the number of the color, this wire prefers to have.
     */
    short preferredColor() const;
    
    /**
     * Changes the state from rubberband to !rubberband. Sets the variables 
     * gridposition and path. The Wirebox looks for a neat
     * path. It remembers all wires it contains.
     * @return Area of screen that must be repainted
     */
    QRect nicelyWireIntoWirebox(Wirebox *);
    
    /**
     * Rips the wire out of a Wirebox (where it must be contained). Changes the state
     * from !rubberband to rubberband.
     * @return Area of screen that must be repainted
     */
    QRect ripOutOfWirebox(Wirebox *);

    Wire *getWire() const { return wire; };

    bool isConnectedTo(const ModuleLook *ml) const;

    bool isConnectedTo(const Connector *c) const;
};


#endif // WireLook_h
