// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/Wirecell.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:36 $
// $State: Exp $
// **************************************************************

#ifndef Wirecell_h
#define Wirecell_h

#include <qpainter.h>

/**
 * A value of this type is stored for each possible piece of wire
 * (horizontally and vertically). Its number of bits is equal to the
 * number of different colors a wire can have and to the number of
 * wires that can lie parallel.
 */
typedef unsigned short Colormask;
const unsigned short ALL_COLORS = 0xffff;
const int NUMBER_WIRE_COLORS = 16;

/**
 * @short Helperclass used by @ref Wirebox to store layout of all wires.
 * Wirepieces run from the center of a cell to either the center of the
 * cell in the right or to the center of the cell in the bottom.
 */
class Wirecell
{
    /**
     * Stores, what wires (i.e. what colors) run from this cell
     * to the cell in the right or in the bottom resp.
     */
    Colormask a_colormask[2];
    
public:
    /**
     * Used to index @ref #a_colormask.
     */
    enum Direction { to_the_right=0, to_the_bottom=1 };
    
    /**
     * Creates an empty Wirecell.
     */
    Wirecell();
    
    /**
     * Returns true, if no wire in of a number of colors is running from this
     * cell to the right or to the bottom resp.
     * @param colormask Set of colors to be looked for
     */
    bool isFree(Direction direction, Colormask colormask = ALL_COLORS) const;

    /**
     * Enters a set of wire pieces (i.e. a set of colors) to the cell either
     * to the right or to the bottom.
     */
    void enter(Direction direction, Colormask colormask);

    void remove(Direction direction, Colormask colormask);
    static Colormask getColormask(short color);

    /**
     * Paints wires contained in this cell. If more than one
     * wire is contained, only the wire with the smalles color-number
     * will be painted.
     * @param xoffset, yoffset: Offset of the cell in p
     */
    void paint(QPainter& p, short xoffset, short yoffset);

    /**
     * Actually paints a piece of wire. This is a static method and
     * may be called from anywhere to paint something that looks like
     * a wire. Is used in the wire-menu.
     */
    static void drawWire(QPainter& p, short x1, short y1, short x2, short y2, short color);
};


#endif // Wirecell_h
