// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/rectutils.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:37 $
// $State: Exp $
// **************************************************************

#ifndef rectutils_h
#define rectutils_h

inline QRect toGrid(const QRect& rect, short gridwidth)
{
    const short roundup = gridwidth / 2;
    return QRect((rect.left()   + roundup) / gridwidth,
		 (rect.top()    + roundup) / gridwidth,
		 (rect.width()  + roundup) / gridwidth,
		 (rect.height() + roundup) / gridwidth);
}

inline QRect enlargeRect(const QRect& rect, short enlarge)
{
    return QRect(rect.left()   -     enlarge,
		 rect.top()    -     enlarge,
		 rect.width()  + 2 * enlarge,
		 rect.height() + 2 * enlarge);
}


inline QRect operator*(const QRect& rect, short factor)
{ 
    return QRect(rect.left()   * factor,
		 rect.top()    * factor,
		 rect.width()  * factor,
		 rect.height() * factor);
}


inline QRect resizeLeft(const QRect& rect, short xoffset)
{
    short newleft = rect.left() + xoffset;
    if (newleft >= 0 && newleft <= rect.right()) 
	return QRect(QPoint(newleft, rect.top()), rect.bottomRight());
    else return rect;
}

inline QRect resizeRight(const QRect& rect, short xoffset)
{
    short newright = rect.right() + xoffset;
    if (newright >= 0 && newright >= rect.left())
	return QRect(rect.topLeft(), QPoint(newright, rect.bottom()));
    else return rect;
}

inline QRect resizeTop(const QRect& rect, short yoffset)
{
    short newtop = rect.top() + yoffset;
    if (newtop >= 0 && newtop <= rect.bottom()) 
	return QRect(QPoint(rect.left(), newtop), rect.bottomRight());
    else return rect;
}

inline QRect resizeBottom(const QRect& rect, short yoffset)
{
    short newbottom = rect.bottom() + yoffset;
    if (newbottom >= 0 && newbottom >= rect.top())
	return QRect(rect.topLeft(), QPoint(rect.right(), newbottom));
    else return rect;
}

#endif rectutils_h
