// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/looks/MLConnector.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:08:07 $
// $State: Exp $
// **************************************************************

#include "MConnector.h"
#include "LookMacros.h"
#include "EnterValueDialog.h"

class MLConnector : public ModuleLook
{
public:
    MLConnector(Module *module, ModuleLookGenerator *gen) : ModuleLook(module, gen) {};
    bool isControl() { return true; }; // see ModuleLook
    bool mousePressed(const QPoint&);
};


class MLGConnector : public ModuleLookGenerator
{
    SignalType signal_type;
    bool external_signal;
public:
    MLGConnector(SignalType signal_type, bool external_signal) 
	: signal_type(signal_type), external_signal(external_signal) {};
    ModuleLook *create(Module *module) { return new MLConnector(module, this); };
    string getName() const { return MConnector::getName(signal_type, external_signal); };
    const char *menuPath() const { return "External Connectors"; };
    QSize gridSize() const { return QSize(3,2); };
   
    void paint(QPainter&, Module *);
    void paintBorder(QPainter& p)         const;
    void paintRubberBorder(QPainter& p)   const;
};

MLGConnector mlg_connector_sound_signal(SOUND_TYPE,   true);
MLGConnector mlg_connector_sound_slot(SOUND_TYPE,     false);
MLGConnector mlg_connector_number_signal(NUMBER_TYPE, true);
MLGConnector mlg_connector_number_slot(NUMBER_TYPE,   false);
MLGConnector mlg_connector_text_signal(TEXT_TYPE,     true);
MLGConnector mlg_connector_text_slot(TEXT_TYPE,       false);

bool MLConnector::mousePressed(const QPoint&)
{
    MConnector *mconnector = (MConnector *)getModule();
    mconnector->setConnectorName(EnterValueDialog::getText("Name for external connection", 
							   mconnector->getConnectorName(),
							   "() "));
    return true; // graphical update neccessary.
}


void MLGConnector::paint(QPainter& p, Module *mconnector)
{
    string text;
    if (mconnector) text = ((MConnector *)mconnector)->getConnectorName();
    else text = signal_type_name[signal_type];
    
    // paint backgroundimage
    QRect rect(1, 1, width()-2, height()-2);
    if (!external_signal) p.setBrush(QColor(255, 195, 64));
    else p.setBrush(black);
    p.setPen(QPen(white, 2));
    p.drawEllipse(rect);

    // paint text
    if (!external_signal) p.setPen(black);
    else p.setPen(QColor(255, 195, 64));
    p.drawText(rect, AlignCenter | AlignVCenter, text.c_str());
}


void MLGConnector::paintRubberBorder(QPainter& p)   const
{
    QRect rect(QPoint(0,0), size());
    p.setBrush(NoBrush);
    p.setPen(QPen(white, 2));
    p.drawEllipse(rect);
}

void MLGConnector::paintBorder(QPainter&) const
{
}
