// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MCut.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************

#ifdef HIRN
#include "ModuleMacros.h"

#define MODULE_NAME "cut"

BEGIN_MODULE_DEFINITION(Cut);
  SoundSlot  *ss_input;
  NumberSlot *ns_from;
  NumberSlot *ns_to;
END_MODULE_DEFINITION(Cut);

class SSCutOutput : public SoundSignal
{
public:
  SSCutOutput(MCut *m) : SoundSignal(m) {};
  String getName() const { return "output"; };
  PreparedSoundSignal *prepareSignal(Metainfo&, const Parameterset&);
};

class PSSCutOutput : public PreparedSoundSignal
{
    friend class SSCutOutput;
    PreparedSoundSignal *pss_input;
    long from, to;
public:
    PSSCutOutput(PreparedSoundSignal *pss, long f, long t)
	: pss_input(pss), from(f), to(t) {};
    ~PSSCutOutput() { delete pss_input; };
    virtual SoundPortion getSoundPortion(long, long);
};


// ---------------------------------------------------------------------------
//                             Implementation
// ---------------------------------------------------------------------------

#include "NullSound.h"
#include "SharedSoundStore.h"
#include "language.h"

MCut::MCut(InputModuleFile *)
{
  declareSlot(ss_input = new SoundSlot("input"));
  declareSlot(ns_from  = new NumberSlot("from"));
  declareSlot(ns_to    = new NumberSlot("to"));

  declareSignal(new SSCutOutput(this));
}


PreparedSoundSignal *SSCutOutput::prepareSignal(Metainfo& mi,
						const Parameterset &parset)
{
    Metainfo mi_input = mi;
    PreparedSoundSignal *input =
	((MCut *)module)->ss_input->prepareSignal(mi_input, parset);

    Number sampling_interval = getSamplingInterval(mi_input, parset);
    if (sampling_interval <= 0) {
	delete input;
	return NullSound::getPreparedNullSignal(mi, parset);
    }
    
    Number from_sec  = ((MCut *)module)->ns_from->getNumber();
    Number to_sec    = ((MCut *)module)->ns_to  ->getNumber();
    if (parset.containsDurationFactor()) {
	from_sec *= parset.getDurationFactor();
	to_sec   *= parset.getDurationFactor();
    }
    long   from      = (long)(from_sec / sampling_interval);
    long   to        = (long)(to_sec   / sampling_interval);
    
    if (to < from) {
	module->reportError(l_MCut_1tt, String(l_MCut_1txa) + toString(from_sec)
			    + l_MCut_1txb + toString(to_sec) + l_MCut_1txc);
	delete input;
	return NullSound::getPreparedNullSignal(mi, parset);
    }

    Metainfo asked_for = mi;
    mi = mi_input; // copy all mi except for...

    // Metainfos cut from, cut to and duration. The come already with duration factor

    if (asked_for.containsCutFrom()) {
	if (mi_input.containsCutFrom())
	    mi.setCutFrom(max(from, mi_input.getCutFrom()));
	else mi.setCutFrom(from);
    }

    if (asked_for.containsCutTo()) {
	if (mi_input.containsCutTo())
	    mi.setCutTo(max(to, mi_input.getCutTo()));
	else mi.setCutTo(to);
    }

    if (asked_for.containsDuration()) {
	if (mi_input.containsDuration())
	    mi.setDuration(min(to_sec, mi_input.getDuration()));
	else mi.setDuration(to_sec);
    }
    
    return new PSSCutOutput(input, from, to);
}


SoundPortion PSSCutOutput::getSoundPortion(long start_time, long nsamples)
{
    const long end_time = start_time + nsamples;
    const long cut_from_samples = start_time >= from ? 0 : min(from - start_time, nsamples);
    const long cut_to_samples   = end_time   <= to   ? 0 : min(end_time - to,     nsamples);
    const long copy_samples = nsamples - cut_from_samples - cut_to_samples;

    // if none of the two cutting times falls into [start_time, end_time[,
    // i avoid copying and simply delegate
    
    if (cut_from_samples == nsamples
        || cut_to_samples == nsamples) return NullSound::getNullSound(nsamples);
    if (copy_samples == nsamples) return pss_input->getSoundPortion(start_time, nsamples);

    // cutting time hit -> I must copy.
    
    SoundPortion sp_input = pss_input->getSoundPortion(start_time + cut_from_samples, copy_samples);
    const Number *input   = sp_input.getSamples();
    
    Number *output_buffer = new Number[nsamples];
    Number *output = output_buffer;
    
    fillNullSamples(output, cut_from_samples);
    copySamples(input, output, copy_samples);
    fillNullSamples(output, cut_to_samples);

    return SoundPortion(output_buffer, new SharedSoundStore(output_buffer));
}
#endif // HIRN
