// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MKnob.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************

#include <stdlib.h> // atof()
#include <stdio.h>

#include "MKnob.h"

class MGKnob : public ModuleGenerator
{
    string name;
public:
    MGKnob(string name) : name(name) {};
    Module *create(string par="0.5") const { return new MKnob(name, par); };
    string getName() const { return name; };
};

MGKnob mg_knob[] = { string("knob"), string("big-knob") };

class PNSigKnobOutput : public PreparedNumberSignal
{
    Number *value;
public:
    PNSigKnobOutput(Number *value) : value(value) {};
    Number getNumber() { return *value; };
};


class NSigKnobOutput : public Signal
{
    Number *value;
public:
    NSigKnobOutput(Module *m, Number *v) 
	: Signal(NUMBER_TYPE, "output", "Value ranging from 0.0 to 1.0", m), value(v) {};
    PreparedSignal *prepareSignal(Metainfo *, const Parameterset *) 
	{ return new PNSigKnobOutput(value); };
};


MKnob::MKnob(string name, string constructor_string)	
    : name(name)
    , value(atof(constructor_string.c_str()))
{
    addConnector(new NSigKnobOutput(this, &value));
}

