// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MParallel.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************

#define MODULE_NAME "parallel"

#include "ModuleMacros.h"
#include "minmaxabs.h"

BEGIN_MODULE_DEFINITION(Parallel);
    Slot  *sslot_dominant_input;
    Slot  *sslot_input2;
END_MODULE_DEFINITION(Parallel);

class SSParallelOutput : public Signal
{
public:
    SSParallelOutput(MParallel *m) 
	: Signal(SOUND_TYPE, "output", "At the same time input1 and intpu2", m) {};
    PreparedSignal *prepareSignal(Metainfo *, const Parameterset *);
};


class PSSParallelOutput : public PreparedSoundSignal
{
    friend class SSParallelOutput;
    PreparedSoundSignal *pssig_dominant_input;
    PreparedSoundSignal *pssig_input2;
    long cut_from_dom, cut_to_dom,
	cut_from_in2, cut_to_in2;
public:
    PSSParallelOutput(PreparedSoundSignal *,PreparedSoundSignal *, long, long, long, long);
    ~PSSParallelOutput() { delete pssig_input2; delete pssig_dominant_input; };
    SoundPortion getSoundPortion(long start_time, long number_of_samples);
private:
    void computeSamples(Number *, long start_time, long number_of_samples) const;
};


// ---------------------------------------------------------------------------
//                             Implementation
// ---------------------------------------------------------------------------

#include <values.h>

#include "SharedSoundStore.h"


inline PSSParallelOutput::PSSParallelOutput(
    PreparedSoundSignal *di,
    PreparedSoundSignal *i2,
    long cfd, long ctd, long cf2, long ct2) :
    
	pssig_dominant_input(di),
	pssig_input2(i2),
	cut_from_dom(cfd),
	cut_to_dom(ctd),
	cut_from_in2(cf2),
	cut_to_in2(ct2)
{
}


MParallel::MParallel(string)
{
    addConnector(sslot_dominant_input 
		= new Slot(SOUND_TYPE, "input1", "Dominant input, gives parameters", this, 3));
    addConnector(sslot_input2 
		= new Slot(SOUND_TYPE, "input2", "Second input", this, 4));
    addConnector(new SSParallelOutput(this));
}


PreparedSignal *SSParallelOutput::prepareSignal(Metainfo *mi,
						const Parameterset *parset)
{
    // TODO: pitch change should only be given to dominant input. Other inputs
    // should shift relatively!

    Metainfo mi_dom = *mi;
    Metainfo mi_in2 = *mi;
    
    PreparedSoundSignal	*dominant_input 
	= getPreparedSoundSignal(this, ((MParallel *)getModule())->sslot_dominant_input, &mi_dom, parset);
    PreparedSoundSignal *input2
	= getPreparedSoundSignal(this, ((MParallel *)getModule())->sslot_input2, &mi_in2, parset);
	
    Metainfo asked_for = *mi;
    *mi = mi_dom; // take all meta information from the dominant input

    // except for metainfos cut from, cut to and duration:

    if (asked_for.containsCutFrom()) {
	if (mi_dom.containsCutFrom() && mi_in2.containsCutFrom())
	    mi->setCutFrom(min(mi_dom.getCutFrom(), mi_in2.getCutFrom()));
	else mi->clearCutFrom();
    }
    if (asked_for.containsCutTo()) {
	if (mi_dom.containsCutTo() && mi_in2.containsCutTo())
	    mi->setCutTo(max(mi_dom.getCutTo(), mi_in2.getCutTo()));
	else mi->clearCutTo();
    }
    if (asked_for.containsDuration()) {
	if (mi_dom.containsDuration()) mi->setDuration(mi_dom.getDuration());
	else if (mi_in2.containsDuration()) mi->setDuration(mi_in2.getDuration());
	else mi->clearDuration();
    }

    // I save the cutting ranges of the two inputs for later optimizations

    long cut_from_dom = mi_dom.containsCutFrom() ? mi_dom.getCutFrom() : MINLONG; 
    long cut_to_dom   = mi_dom.containsCutTo()   ? mi_dom.getCutTo()   : MAXLONG;

    long cut_from_in2 = mi_in2.containsCutFrom() ? mi_in2.getCutFrom() : MINLONG;
    long cut_to_in2   = mi_in2.containsCutTo()   ? mi_in2.getCutTo()   : MAXLONG;
    
    return new PSSParallelOutput(dominant_input, input2,
				 cut_from_dom, cut_to_dom,
				 cut_from_in2, cut_to_in2);
}


SoundPortion PSSParallelOutput::getSoundPortion(long start_time, long nsamples)
{
    long end_time = start_time + nsamples;

    if (start_time >= cut_to_dom || end_time <= cut_from_dom)
	return pssig_input2->getSoundPortion(start_time, nsamples);

    if (start_time >= cut_to_in2 || end_time <= cut_from_in2)
	return pssig_dominant_input->getSoundPortion(start_time, nsamples);

    Number *output_buffer = new Number[nsamples];
    computeSamples(output_buffer, start_time, nsamples);
    return SoundPortion(output_buffer, new SharedSoundStore(output_buffer));
}	


void PSSParallelOutput::computeSamples(Number *output,long start_time, long nsamples) const
{
    SoundPortion sp_dom = pssig_dominant_input->getSoundPortion(start_time, nsamples);
    SoundPortion sp_in2 = pssig_input2        ->getSoundPortion(start_time, nsamples); 
    const Number *dom   = sp_dom.getSamples();
    const Number *in2   = sp_in2.getSamples();
    while (nsamples--) *output++ = *dom++ + *in2++;
}
