
#include "MSetParameter.h"

class MGSetParameter : public ModuleGenerator
{
    SignalType parameter_signal_type;
    SignalType operand_signal_type;
public:
    MGSetParameter(SignalType parameter_signal_type, SignalType operand_signal_type) 
	: parameter_signal_type(parameter_signal_type), operand_signal_type(operand_signal_type) {};
    Module *create(string par) 
	const { return new MSetParameter(parameter_signal_type, operand_signal_type, par); };
    string getName() 
	const { return MSetParameter::getName(parameter_signal_type, operand_signal_type); };
};

MGSetParameter mg_setParameter_sound_sound  (SOUND_TYPE,  SOUND_TYPE);
MGSetParameter mg_setParameter_sound_number (SOUND_TYPE,  NUMBER_TYPE);
MGSetParameter mg_setParameter_sound_text   (SOUND_TYPE,  TEXT_TYPE);
MGSetParameter mg_setParameter_number_sound (NUMBER_TYPE, SOUND_TYPE);
MGSetParameter mg_setParameter_number_number(NUMBER_TYPE, NUMBER_TYPE);
MGSetParameter mg_setParameter_number_text  (NUMBER_TYPE, TEXT_TYPE);
MGSetParameter mg_setParameter_text_sound   (TEXT_TYPE,   SOUND_TYPE);
MGSetParameter mg_setParameter_text_number  (TEXT_TYPE,   NUMBER_TYPE);
MGSetParameter mg_setParameter_text_text    (TEXT_TYPE,   TEXT_TYPE);

class SSigSetParameter : public Signal
{
public:
    SSigSetParameter(Module *m, SignalType operand_signal_type) 
	: Signal(operand_signal_type, "output", "input with set parameter", m) {};
    PreparedSignal *prepareSignal(Metainfo *mi, const Parameterset *parset) {
	return ((MSetParameter *)getModule())->slot_input->getPreparedSignal(this, mi, parset);
    };
};


class SSlotSetParameter : public Slot
{
    Slot *slot_parameter;
    string *parametername;
public:
    SSlotSetParameter(Slot *slot_parameter, string *parametername, Module *module,
		      SignalType operand_signal_type)
	: Slot(operand_signal_type, "input", "Signal whose parameter is to set", module, 7),
	  slot_parameter(slot_parameter), parametername(parametername) {};
    Signal *getParameterSignal(const char *name);
};

// ----------------------------------------------------------------------

MSetParameter::MSetParameter(SignalType parameter_signal_type, 
			     SignalType operand_signal_type, string pn)
    : parameter_signal_type(parameter_signal_type)
    , operand_signal_type(operand_signal_type)
    , parametername(pn)
{
    if (parametername == "") parametername = "par";
    slot_parameter = new Slot(parameter_signal_type, "parameter","Value of the parameter", this, 9);
    addConnector(slot_input = 
		 new SSlotSetParameter(slot_parameter, &parametername, this, operand_signal_type));
    addConnector(slot_parameter);
    addConnector(new SSigSetParameter(this, operand_signal_type));
}


string MSetParameter::toString() const
{
    return parametername;
}


string MSetParameter::getName(SignalType parameter_signal_type, SignalType operand_signal_type)
{
    return string("set-") 
	+ signal_type_name[parameter_signal_type]
	+ "-parameter-on-"
	+ signal_type_name[operand_signal_type];
}

void MSetParameter::setParameterName(string name)
{
    parametername = name;
}


Signal *SSlotSetParameter::getParameterSignal(const char *name)
{
    // A question for parameter value is redirected to the slot "parameter".
    // The argument 0 for getSignal means: I will provide no
    // parameters.

    if (!strcmp(name, parametername->c_str())) return slot_parameter->getSignal(0);
    else                               return Slot::getParameterSignal(name); 
}
