// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MVolume.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************

#define MODULE_NAME "volume"

#include "ModuleMacros.h"

BEGIN_MODULE_DEFINITION(Volume);
    Slot *sslot_input;
    Slot *nslot_volume;
END_MODULE_DEFINITION(Volume);

class SSVolumeOutput : public Signal
{
public:
    SSVolumeOutput(MVolume *m) : Signal(SOUND_TYPE, "output", "Input with changed volume", m) {};
    PreparedSignal *prepareSignal(Metainfo *, const Parameterset *);
};

class PSSVolumeOutput : public PreparedSoundSignal
{
    friend class SSVolumeOutput;
    PreparedSoundSignal  *pssig_input;
    PreparedNumberSignal *pnsig_volume;
public:
    PSSVolumeOutput(PreparedSoundSignal *pssig_input, PreparedNumberSignal *pnsig_volume) 
	: pssig_input(pssig_input), pnsig_volume(pnsig_volume) {};
    ~PSSVolumeOutput() { delete pssig_input; delete pnsig_volume; };
    void computeSamples(Number *, long start_time, long number_of_samples);
};


// ---------------------------------------------------------------------------
//                             Implementation
// ---------------------------------------------------------------------------

// #include <math.h>

MVolume::MVolume(string)
{
    addConnector(sslot_input = new Slot(SOUND_TYPE, "input", "Input sound signal", this, 5));
    addConnector(nslot_volume = new Slot(NUMBER_TYPE, "volume", "Relative volume, 1.0 = no change",this,13));
    addConnector(new SSVolumeOutput(this));
}


PreparedSignal *SSVolumeOutput::prepareSignal(Metainfo *mi,
					      const Parameterset *parset)
{
    // No parameters nor metainfo is involved
    PSSVolumeOutput *pps = new PSSVolumeOutput(
	getPreparedSoundSignal(this,  ((MVolume *)getModule())->sslot_input, mi, parset),
	getPreparedNumberSignal(this, ((MVolume *)getModule())->nslot_volume, 1.0));
    return pps;
}


void PSSVolumeOutput::computeSamples(Number *output, long start_time, long nsamples)
{
    // TODO: optimize 0 volume!
    Number volume = pnsig_volume->getNumber();
    SoundPortion sp_input = pssig_input->getSoundPortion(start_time, nsamples);
    const Number *input = sp_input.getSamples();
    while (nsamples--) *output++ = *input++ * volume;
}
