#include <stdio.h>
#include <bspinbox.h>
#include <bspinbox.moc>

RapidButton::RapidButton( bool up, unsigned int *val, QWidget *parent )
	: QPushButton( parent, 0 )
{
	going_up = up;
	value = val;

	push_timer = new QTimer(this);
	QObject::connect( push_timer, SIGNAL( timeout() ), this, SLOT( valueIncr() ) );

	modified = false;
}

void RapidButton::mousePressEvent( QMouseEvent * )
{
	push_timer->start( 100 );
}

void RapidButton::mouseReleaseEvent( QMouseEvent * )
{
	if ( modified == false ) {
		valueIncr();
	}

	push_timer->stop();
	modified = false;
}

void RapidButton::valueIncr()
{
	modified = true;

	if ( going_up ) {
		(*value)++;
	} else {
		if ( *value != 0 ) {
			(*value)--;
		}
	}

	valueModified();
}

BSpinbox::BSpinbox( unsigned int initial, unsigned int min, unsigned int max, unsigned int digits, QWidget *parent )
	: QFrame( parent, 0, 0, TRUE )
{
	QColorGroup colGrp(red, gray, red, red, red, red, white);

	lcd = new QLCDNumber(digits, this);
	lcd->setPalette(QPalette(colGrp,colGrp,colGrp));
	lcd->setSegmentStyle(QLCDNumber::Filled);
	lcd->setBackgroundColor( black );
	lcd->resize( 40, 40 );

	up = new RapidButton(true, &value, this);
	up->resize(10, lcd->height()/2);
	up->move(lcd->width(), 0);
	QObject::connect( up, SIGNAL(valueModified()), this, SLOT(updateNumber()));

	down = new RapidButton(false, &value, this);
	down->resize(10, lcd->height()/2);
	down->move(lcd->width(), lcd->height()/2);
	QObject::connect( down, SIGNAL(valueModified()), this, SLOT(updateNumber()));

	min_value = min;
	max_value = max;
	value = initial;
	updateNumber();

	resize( lcd->width() + 10, lcd->height() );
}

void BSpinbox::resize(int w, int h)
{
	lcd->resize( w - 10, h );
	up->resize( 10, lcd->height()/2);
	down->resize( 10, lcd->height()/2);

	up->move(lcd->width(), 0);
	down->move(lcd->width(), lcd->height()/2);

	QFrame::resize( lcd->width() + 10, lcd->height() );
}

void BSpinbox::setValue(unsigned int v)
{
	value = v;
	updateNumber();
}

void BSpinbox::updateNumber()
{
	if ( value < min_value ) { value = min_value; }
	if ( value > max_value ) { value = max_value; }

	QString s;
	s.sprintf( "%03d", value );
	lcd->display( s );

	valueChanged( (int) value );
}

