#ifndef BTOOLBUTTON_H_INCLUDED
#define BTOOLBUTTON_H_INCLUDED

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qframe.h>
#include <qpixmap.h>

class BToolButton : public QFrame
{
	Q_OBJECT
private:
	QPixmap *icon;
	bool ispressed;
	bool ispressable;
	bool nopixmap;
	char *thetext;
public:
	BToolButton( bool pressable, QPixmap *_icon, QWidget *parent );
	BToolButton( bool pressable, QWidget *parent );

	void setText( const char *text );
	void setPressed( bool press );
	void enterEvent( QEvent *e );
	void leaveEvent( QEvent *e );
	void mousePressEvent( QMouseEvent *mev );
	void mouseReleaseEvent( QMouseEvent *mev );
	void paintEvent( QPaintEvent *pev );
signals:
	void stateChanged( bool );
	void pressed();
};

#endif // BTOOLBUTTON_H_INCLUDED
