#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <dspcontrol.h>
#include <samplechannel.h>
#include <util.h>

dspcontrol::dspcontrol()
{
	isthreaded = false;
}

dspcontrol::~dspcontrol()
{
	if ( isthreaded == true ) {
		stop();
	}
}

void dspcontrol::timerTick()
{
	doSelect( false );
}

void dspcontrol::clearBuffer( DSPDeviceClass *curdev )
{
	sample_t *buf;
	int buffsize, i;

	buf = curdev->dspdev->getBuffer();
	buffsize = curdev->dspdev->getBuffsize();

	for ( i = 0; i < buffsize; i++ ) {
		*buf++ = 0;
	}
}

void dspcontrol::fillBuffer( DSPDeviceClass *curdev )
{
	sample_t *buf;
	int buffsize;
	unsigned int framesleft, relcurpos, stoppos, i, fpb;
	sampleChannel *cursamp;

	buf = curdev->dspdev->getBuffer();
	buffsize = curdev->dspdev->getBuffsize();
	fpb = gsong->getFpb();

	framesleft = buffsize / 2;
	relcurpos = curdev->pos % fpb;
	stoppos = fpb;

	if ( relcurpos == 0 ) {
		for ( i = 0; i < MAX_CHANNELS; i++ ) {
			if ( ( gsong->getChannelType( i ) == 1 ) && ( gsong->getChannelDevice( i ) == curdev->id ) ) {
				if ( gsong->isSoloModeActive() == true ) {
					if ( ( gsong->isChannelSolo( i ) == true ) &&
					     ( gsong->isChannelMuted( i ) == false ) ) {
						if ( gsong->getSongNote( i, gsong->getCurPat(),
						     gsong->getCurBeat() ) != -1 ) {
							gsong->getChannelSample( i )->on();
						}
					}
				} else {
					if ( gsong->isChannelMuted( i ) == false ) {
						if ( gsong->getSongNote( i, gsong->getCurPat(),
						     gsong->getCurBeat() ) != -1 ) {
							gsong->getChannelSample( i )->on();
						}
					}
				}
			}
		}
	}

	while ( framesleft > 0 ) {
		sample_t *orig_buf = buf;

		if ( ( relcurpos + framesleft ) < fpb ) {
			stoppos = relcurpos + framesleft;
		}

		for ( i = 0; i < MAX_CHANNELS; i++ ) {
			if ( ( gsong->getChannelType( i ) == 1 ) && ( gsong->getChannelDevice( i ) == curdev->id ) ) {
				buf = orig_buf;
				cursamp = gsong->getChannelSample( i );

				for ( unsigned int j = relcurpos; j < stoppos; j++ ) {
					if ( cursamp->isOn() ) {
						sample_t val = cursamp->getFrame();
						*buf++ += (sample_t) ( val * cursamp->getLeftAmplification() );
						*buf++ += (sample_t) ( val * cursamp->getRightAmplification() );
					} else {
						break;
					}
				}
			}
		}

		buf = orig_buf;
		buf += ((stoppos - relcurpos) * 2);
		curdev->pos += (stoppos - relcurpos);
		framesleft -= (stoppos - relcurpos);

		// either at the start of a beat, or we're done
		// if framesleft == 0, then we're done
		if ( stoppos == fpb ) {
			gsong->incrBeat();

			for (i=0; i < MAX_CHANNELS; i++) {
				if ( ( gsong->getChannelType( i ) == 1 ) &&
				     ( gsong->getChannelDevice( i ) == curdev->id ) ) {

					if ( gsong->isSoloModeActive() == true ) {
						if ( ( gsong->isChannelSolo( i ) == true ) &&
						     ( gsong->isChannelMuted( i ) == false ) ) {
							if ( gsong->getSongNote( i, gsong->getCurPat(),
							     gsong->getCurBeat() ) != -1 ) {
								gsong->getChannelSample( i )->on();
							}
						}
					} else {
						if ( gsong->isChannelMuted( i ) == false ) {
							if ( gsong->getSongNote( i, gsong->getCurPat(),
							     gsong->getCurBeat() ) != -1 ) {
								gsong->getChannelSample( i )->on();
							}
						}
					}
				}
			}
		}

		if ( framesleft == 0 ) break;
		relcurpos = 0;
	}
}

void dspcontrol::watchDevices()
{
	isthreaded = true;

	for (;;) {
		testcancel();
		doSelect( true );
	}
}

void dspcontrol::checkRequests()
{
	unsigned int i;
	DSPDeviceClass **dsplist;

	dsplist = devcontrol->getDspList();

	for ( i = 0; i < MAX_DSP_DEVICES; i++ ) {
		if ( dsplist[ i ] != NULL ) {
			pthread_mutex_lock( &devcontrol->mutex );
			if ( dsplist[ i ]->reqopened == true ) {
				dsplist[ i ]->openDevice();
				dsplist[ i ]->reqopened = false;
				pthread_cond_signal( &devcontrol->doneop );
				pthread_mutex_unlock( &devcontrol->mutex );
				return;
			}
			if ( dsplist[ i ]->reqclosed == true ) {
				dsplist[ i ]->closeDevice();
				dsplist[ i ]->reqclosed = false;
				devcontrol->scanDspDevices();
				pthread_cond_signal( &devcontrol->doneop );
				pthread_mutex_unlock( &devcontrol->mutex );
				return;
			}
			pthread_mutex_unlock( &devcontrol->mutex );
		}
	}

}

void dspcontrol::doSelect( bool block )
{
	struct timeval timeout;
	fd_set write_fds, except_fds;
	DSPDeviceClass **dsplist;
	unsigned int i;

	checkRequests();

	timeout.tv_sec = 0;
	timeout.tv_usec = 0;

	devcontrol->computeHighestDspFd();

	FD_ZERO( &write_fds );
	FD_ZERO( &except_fds );
	devcontrol->setAllDspDescriptors( &write_fds );
	devcontrol->setAllDspDescriptors( &except_fds );

	if ( devcontrol->isDspDeviceOpen() == false ) {
		usleep( 0 );
		return;
	}

  retry:
	if ( select( devcontrol->getHighestDspFd(), NULL, &write_fds, &except_fds, block ? NULL : &timeout) == -1 ) {
		if ( errno == EINTR ) goto retry;
		perror("dspcontrol::thread_main: select punted");
		exit( 1 );
	}

	dsplist = devcontrol->getDspList();

	for ( i = 0; i < MAX_DSP_DEVICES; i++ ) {
		if ( dsplist[ i ] != NULL ) {
//			if ( dsplist[ i ]->opened == true ) {
			if ( dsplist[ i ]->dspdev != NULL ) {
				if ( FD_ISSET( dsplist[ i ]->dspdev->getFd(), &write_fds ) ) {
					int readyfrags = dsplist[ i ]->dspdev->writeableFragments();

					for ( int j = 0; j < readyfrags; j++ ) {
						clearBuffer( dsplist[ i ] );

						if ( gsong->isPlaying() == 1 ) {
							fillBuffer( dsplist[ i ] );
						}

						dsplist[ i ]->dspdev->writeBuffer();
					}
				}
			}
		}
	}
}

void dspcontrol::thread_main(void)
{
	watchDevices();
}
