#include <unistd.h>
#include <qpixmap.h>
#include "globals.h"
#include "songwidget.h"
#include "icons/zoomin.xpm"
#include "icons/zoomout.xpm"

SongWidget::SongWidget( QWidget *parent )
:QFrame( parent, 0, 0, TRUE )
{
    topbar = 0;
    rightscroll = new QScrollBar( 0, MAX_CHANNELS, 1, 1, 0, QScrollBar::Vertical, this );
    QObject::connect( rightscroll, SIGNAL( valueChanged( int ) ), this, SLOT( rightScrollBarMove( int ) ) );

    bottomscroll = new QScrollBar( 0, MAX_PATTERNS, 1, 1, 0, QScrollBar::Horizontal, this );

    leftfiller = new QFrame( this );
    leftfiller->setFrameStyle( QFrame::Panel | QFrame::Raised );
    leftfiller->setLineWidth( 2 );

    barframe = new QFrame( this );

    for ( int i = 0; i < MAX_CHANNELS; i++ ) {
        bar[ i ] = new SongBar( i, barframe );
        QObject::connect( bar[ i ], SIGNAL( barCursorUp( int, int ) ), this, SLOT( barCursorUp( int, int ) ) );
        QObject::connect( bar[ i ], SIGNAL( barCursorDown( int, int ) ), this, SLOT( barCursorDown( int, int ) ) );
        QObject::connect( bar[ i ], SIGNAL( barGiveCursor( int, int ) ), this, SLOT( barGiveCursor( int, int ) ) );
        QObject::connect( bottomscroll, SIGNAL( valueChanged( int ) ), bar[ i ], SLOT( scrollPatternBar( int ) ) );
    }
    bar[ 0 ]->getBarCursor( 0 );
    hascursor = 0;

    positionbar = new BPositionBar( this );
    QObject::connect( bottomscroll, SIGNAL( valueChanged( int ) ), positionbar, SLOT( scrollPositionBar( int ) ) );

    scalebar = new BScaleBar( this );
    QObject::connect( bottomscroll, SIGNAL( valueChanged( int ) ), scalebar, SLOT( scrollScaleBar( int ) ) );

    zoomin = new QPushButton( this );
    zoomin->resize( 20, 20 );
    zoomin->setPixmap( QPixmap( ( const char ** ) zoomin_xpm ) );
    QObject::connect( zoomin, SIGNAL( pressed() ), this, SLOT( zoomInPattern() ) );
    QObject::connect( zoomin, SIGNAL( pressed() ), scalebar, SLOT( zoomIn() ) );
    QObject::connect( zoomin, SIGNAL( pressed() ), positionbar, SLOT( zoomIn() ) );

    zoomout = new QPushButton( this );
    zoomout->resize( 20, 20 );
    zoomout->setPixmap( QPixmap( ( const char ** ) zoomout_xpm ) );
    QObject::connect( zoomout, SIGNAL( pressed() ), this, SLOT( zoomOutPattern() ) );
    QObject::connect( zoomout, SIGNAL( pressed() ), scalebar, SLOT( zoomOut() ) );
    QObject::connect( zoomout, SIGNAL( pressed() ), positionbar, SLOT( zoomOut() ) );

    bpmselect = new BBPMSelect( this );
    bpmselect->move( 0, 0 );
}

void SongWidget::resizeEvent( QResizeEvent *rev )
{
    positionbar->move( bar[ 0 ]->leftBarWidth(), 0 );
    positionbar->resize( rev->size().width() - bar[ 0 ]->leftBarWidth() - 20, 10 );

    scalebar->move( bar[ 0 ]->leftBarWidth(), 10 );
    scalebar->resize( rev->size().width() - bar[ 0 ]->leftBarWidth() - 20, 30 );

    barframe->move( 0, 40 );
    barframe->resize( rev->size().width() - 20, rev->size().height() - 60 );

    for ( int i = 0; i < MAX_CHANNELS; i++ ) {
            bar[ i ]->move( 0, ( bar[ i ]->height() * ( i - topbar ) ) );
    }

    rightscroll->resize( 20, rev->size().height() - 21 );
    rightscroll->move( rev->size().width() - 20, 0 );

    bottomscroll->resize( width() - 20 - bar[ 0 ]->leftBarWidth() - 20, 20 );
    bottomscroll->move( bar[ 0 ]->leftBarWidth(), rev->size().height() - 20 );

    leftfiller->resize( bar[ 0 ]->leftBarWidth(), 20 );
    leftfiller->move( 0, rev->size().height() - 20 );

    zoomin->move( rev->size().width() - 20 - 20, rev->size().height() - 20 );
    zoomout->move( rev->size().width() - 20, rev->size().height() - 20 );

    QFrame::resizeEvent( rev );
}

void SongWidget::barCursorUp( int channel, int pos )
{
    if ( channel == 0 ) {
        bar[ 0 ]->getBarCursor( pos );
    } else {
        bar[ channel - 1 ]->getBarCursor( pos );
        hascursor = channel - 1;
    }
}

void SongWidget::barCursorDown( int channel, int pos )
{
    if ( channel == MAX_CHANNELS - 1 ) {
        bar[ MAX_CHANNELS - 1 ]->getBarCursor( pos );
    } else {
        bar[ channel + 1 ]->getBarCursor( pos );
        hascursor = channel + 1;
    }
}

void SongWidget::barGiveCursor( int channel, int pos )
{
    bar[ hascursor ]->noBarCursor();
    bar[ channel ]->getBarCursor( pos );
    hascursor = channel;
}

void SongWidget::rightScrollBarMove( int newpos )
{
    topbar = newpos;
    for ( int i = 0; i < MAX_CHANNELS; i++ ) {
            bar[ i ]->move( 0, ( bar[ i ]->height() * ( i - topbar ) ) );
    }
}

void SongWidget::zoomInPattern()
{
    for ( int i = 0; i < MAX_CHANNELS; i++ ) {
        bar[ i ]->zoomInPattern();
    }
}

void SongWidget::zoomOutPattern()
{
    for ( int i = 0; i < MAX_CHANNELS; i++ ) {
        bar[ i ]->zoomOutPattern();
    }
}

void SongWidget::saveSong( int fd )
{
    const char *curtext;
    int j;

    for ( int i = 0; i < MAX_CHANNELS; i++ ) {
        curtext = bar[ i ]->getName();
        j = 0;
        for (;;) {
            write( fd, &curtext[ j ], sizeof( char ) );
            if ( curtext[ j++ ] == '\0' ) {
                break;
            }
        }
    }
}

void SongWidget::loadSong( int fd )
{
    char curtext[ 255 ];
    int j;

    for ( int i = 0; i < MAX_CHANNELS; i++ ) {
        j = 0;
        for (;;) {
            read( fd, &curtext[ j ], sizeof( char ) );
            if ( curtext[ j ] == '\0' ) {
                break;
            }
            j++;
        }
        bar[ i ]->setName( curtext );
    }

    // Sync up the GUI
    bpmselect->resetBPM();
    scalebar->setLoopPoints( gsong->getLoopStart(), gsong->getLoopEnd() );
    for ( int i = 0; i < MAX_CHANNELS; i++ ) {
        bar[ i ]->reSync();
    }
}

void SongWidget::repaintStuff()
{
    scalebar->repaint();
}

