#include <stdlib.h>
#include <assert.h>
#include <thread.h>

void *thread::thread_thunk( void *pthis )
{
	( (thread *) pthis )->thread_main();
	return NULL;
}

bool thread::run( void )
{
	assert( !running );

	if ( pthread_create( &thread_handle, NULL, thread_thunk, this ) != 0 ) {
		return false;
	}

	running = true;
	return true;
}

void thread::stop( void )
{
	assert( running );

	cancel_requested = true;
	pthread_join( thread_handle, NULL );

	running = false;
	cancel_requested = false;
}

thread::~thread()
{
	if ( running ) stop();
}
