#ifndef THREAD_H_INCLUDED
#define THREAD_H_INCLUDED

#include <pthread.h>

class thread
{
private:
	pthread_t thread_handle;
	bool running;
	bool cancel_requested;

	static void *thread_thunk( void *pthis );

protected:
	// Call this function to start the thread. You probably just want
	// to make this public. Returns true iff the thread was started.
	// If you call this function and it succeeds, then you can't call it
	// again for the same object.
	bool run( void );

	// Kills the thread. You can only call this if the thread is running.
	void stop( void );

	// Override this function and put your thread's code here.
	virtual void thread_main( void ) = 0;

	void testcancel( void )
		{ if ( cancel_requested ) { pthread_cancel( thread_handle ); pthread_testcancel(); }; }

public:
	thread()
		: running( false ), cancel_requested( false )
		{ }

	virtual ~thread();
};

#endif // THREAD_H_INCLUDED
