#ifndef UTIL_H_INCLUDED
#define UTIL_H_INCLUDED

#include <string.h>

void debug_printf(const char *fmt, ...);

// Example usage of DEBUG_PRINTF:
// 	DEBUG_PRINTF(("file size is %lu\n", size));
// Note that the double parentheses are correct and required.

#ifdef DEBUG
#define DEBUG_PRINTF(X) do { debug_printf X ; } done(0)
#else
//#define DEBUG_PRINTF(x) do { ((void)(x)); } while(0)
#define DEBUG_PRINTF(X)
#endif


static inline bool streq( const char *a, const char *b )
{
	return strcmp( a, b ) == 0;
}

bool checkFilename( const char *filename );

#endif
