/* 
    channel for Bt848 frame grabber driver

    Copyright (C) 1996,97 Marcus Metzler (mocm@thp.uni-koeln.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _channel_h
#define _channel_h

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <strstream.h>


#define CFVER_XTV   0
#define CFVER_1     1  // bis 0.6.11
#define CFVER_2     2  // ab 0.6.12
#define CFVER_3     3  // ab 0.6.15
#define CFVER_CUR   CFVER_3

class channel
{
public:
  static int version;
  
  int id;

  int frequency;
  int color;
  int brightness;
  int hue;
  int contrast;
  int norm;
  int input;
  
  int country;

  char *name;
  char *channelId;

  // constructors, destructor
  channel()
  {
    country=-1;
    channelId=NULL;
    name=NULL;
  }
  
  channel(int freq,const char *n,int c,int b,int hu,int co,int no,int in,int cntry=-1,const char *cid=0);

  ~channel();

  static void setVersion( int v ) { version=v; }
  static int getVersion() { return version; }

  // streams
  friend ostream &operator<<(ostream &stream, channel &x);
  friend istream &operator>>(istream &stream, channel &x);

private:
  channel(const channel &);
};

#endif /* _channel_h */
/* DON'T ADD STUFF AFTER THIS #endif */











