/**********************************************************************

	--- Qt Architect generated file ---

	File: osnapshot.cpp
	Last generated: Thu Jun 11 14:05:59 1998

 *********************************************************************/

#include <stdlib.h>
#include <wintv.h>
#include <qfiledlg.h>
#include <v4lxif.h>
#include <osnapshot.h>

#ifdef myDEBUG
#define ossDEBUG
#endif

struct pictab {
  int id;
  char * lname;
  bool compress;
  int crl,crh,crdefault;
};

static struct pictab os_picformats[] = {
  { SNAPSHOT_PNM , "PNM", false, 0, 0, 0 },      /* libpnm, portable anymap */
#ifdef HAVE_LIBJPEG
  { SNAPSHOT_JPEG, "JPEG", true, 1, 100, 75 },   
#endif
#ifdef HAVE_LIBTIFF
  { SNAPSHOT_TIFF, "TIFF", false, 0, 0, 0 },
#endif
#ifdef HAVE_LIBPNG
  { SNAPSHOT_PNG, "PNG", true, 0, 9, 6 },
#endif
  { -1, NULL }
};

#define Inherited osnapshotdata

osnapshot::osnapshot
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
  rc=NULL;
  prefix=(char *)malloc(1024);

  int i=0;
  while ( cv_dimensions[i].id != -1 ) {
    thesize->insertItem(cv_dimensions[i].lname);
    i++;
  }

  i=0;
  while ( os_picformats[i].id != -1 ) {
    theimageformat->insertItem(os_picformats[i].lname);
    i++;
  }
}


osnapshot::~osnapshot()
{
  if (rc) free(rc);
  free(prefix);
}

void osnapshot::setData(rcfile *_rc)
{
  
#ifdef ossDEBUG
  debug("oss: setData");
#endif
  if (rc) free(rc);
  rc= (rcfile *)malloc( sizeof(rcfile) );

  rc->ss_quality=_rc->ss_quality;
  rc->ss_fixed=_rc->ss_fixed;
  rc->ss_width=_rc->ss_width;
  rc->ss_height=_rc->ss_height;
  rc->ss_format=_rc->ss_format;
  strcpy(prefix,(const char*)_rc->ss_prefix);
  //debug("oss: setData 1 %s",prefix);
  //debug("oss: setData 2 %d, %d",rc->ss_fixed,rc->ss_format);
  imagename->setText(prefix);
  r_tvsize->setChecked(!rc->ss_fixed);
  r_fixedsize->setChecked(rc->ss_fixed);
  
  theimageformat->setCurrentItem(rc->ss_format);

  if ( !((rc->ss_quality >= os_picformats[rc->ss_format].crl) && 
       (rc->ss_quality <= os_picformats[rc->ss_format].crh)) ) {
    rc->ss_quality=os_picformats[rc->ss_format].crdefault;
  } 
  thequality->setValue(rc->ss_quality);
  thequality->setEnabled(os_picformats[rc->ss_format].compress);

  int i=0;
  while ( cv_dimensions[i].id != -1 ) {
    if ( cv_dimensions[i].w == rc->ss_width ) {
      thesize->setCurrentItem(i);
      break;
    }
    i++;
  }

  thesize->setEnabled( rc->ss_fixed );
#ifdef ossDEBUG
  debug("oss: setData end");
#endif
}
void osnapshot::buttonSLOT(int id)
{
  rc->ss_fixed=id;
  thesize->setEnabled( id );
#ifdef ossDEBUG
  debug("oss: fixed snap shot %s",id?"on":"off");
#endif
}
void osnapshot::thesizeSLOT(int id)
{
  rc->ss_width=cv_dimensions[id].w;
  rc->ss_height=cv_dimensions[id].h;
#ifdef ossDEBUG
  debug("oss: new fixed size: %d x %d",rc->ss_width,rc->ss_height);
#endif
}
void osnapshot::imagenameSLOT(const char* name)
{
  strcpy(prefix,name);
}
void osnapshot::imageformatSLOT(int id)
{
  rc->ss_format= id;

  rc->ss_quality=os_picformats[rc->ss_format].crdefault;
  thequality->setValue(rc->ss_quality);
  thequality->setEnabled(os_picformats[rc->ss_format].compress);
  
#ifdef ossDEBUG
  debug("oss: new format %d",rc->ss_format);
#endif
}
void osnapshot::browseSLOT()
{
  QString fileName = 
    QFileDialog::getExistingDirectory(prefix);
  if ( !fileName.isNull() ) {                 // got a file name
    fileName+="/";
    imagename->setText(fileName);
#ifdef ossDEBUG
    debug("oss: dir %s",(const char *)fileName);
#endif
  }
}
void osnapshot::newQualitySLOT(int val)
{
  rc->ss_quality= val;
}
//  do not edit
#include "osnapshot.moc"




