/* 
    kwintv

    Copyright (C) 1998,1999 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <errno.h>

#include <pagelist.h>

#include <winvtxmain.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kwm.h>

#ifdef myDEBUG
#define vtxDEBUG
#endif

#define SBI_L1    0

#define BID_L1    0
#define BID_CP    1
#define BID_L2    2
#define BID_CSP   3
#define BID_NEXT  4
#define BID_PREV  5
#define BID_HOME  6
#define BID_CLOSE 7
#define BID_SNEXT  8
#define BID_SPREV  9
#define BID_L3   10
#define BID_PROG 11
#define BID_BACK  12
#define BID_RELOAD 13

#define RCDIR ".kwintvrc"

const QColor CLUT[8] = { black, red, green, yellow, blue, magenta, cyan, white };

winVTXMainWidget::winVTXMainWidget( parsecl * pcl, QWidget* parent, const char* name )
  :  KTopLevelWidget( name )
{
  inInitPhase= true;

  cplist= new QStrList;
  csplist= new QStrList;

  pagelist.clear();

  strcpy(dummy," ");

  cacheDir=QDir::homeDirPath()+QString("/")+QString(RCDIR)+QString("/vtx_cache/");
  currProgram="RTL-Text";
  currPage=FIRSTPAGE;
  currSubPage=0;

  // read the config stuff
  KConfig *config=kapp->getConfig();
  config->setGroup("CONFIG_VideoText");
  cacheDir=config->readEntry("VTXCacheDir",cacheDir);
  currProgram=config->readEntry("CurrentProgram",currProgram);
  vtx_charset=config->readNumEntry("VTXCharSet",vtx_charset);

  QDir rcdir(cacheDir);
  if (!rcdir.exists()) {
    rcdir.mkdir(rcdir.absPath());
  }


  KWM::setIcon(winId(), kapp->getIcon());
  KWM::setMiniIcon(winId(), kapp->getMiniIcon());

  setCaption((const char*)(QString("kWinTV ")+QString(VERSION)+QString(" -- VideoText")));
  // set icon
  
  KIconLoader *loader = kapp->getIconLoader();

  /////////////////////////////////////////////////////////////////////////////
  statusbar= new KStatusBar(this);
  statusbar->insertItem(i18n("VTX"),SBI_L1);
  setStatusBar(statusbar);

  // toolbar
  toolbar = new KToolBar(this); // 22,26
  toolbar->setBarPos(KToolBar::Top);

  pm=loader->loadIcon("back.xpm");
  toolbar->insertButton(pm,BID_PREV,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("previous aviable page"));
  pm=loader->loadIcon("forward.xpm");
  toolbar->insertButton(pm,BID_NEXT,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("next aviable page"));

  pm=loader->loadIcon("back.xpm");
  toolbar->insertButton(pm,BID_SPREV,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("previous aviable subpage"));
  pm=loader->loadIcon("forward.xpm");
  toolbar->insertButton(pm,BID_SNEXT,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("next aviable subpage"));

  pm=loader->loadIcon("back.xpm");
  toolbar->insertButton(pm,BID_BACK,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("back to last page"));

  pm=loader->loadIcon("home.xpm");
  toolbar->insertButton(pm,BID_HOME,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("home to page 100"));
  pm=loader->loadIcon("reload.xpm");
  toolbar->insertButton(pm,BID_RELOAD,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("reload this page"));

  toolbar->insertSeparator();
  pm=loader->loadIcon("delete.xpm");
  toolbar->insertButton(pm,BID_CLOSE,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("close window"));

  ctoolbar = new KToolBar(this); // 22,26
  ctoolbar->setBarPos(KToolBar::Top);
  QLabel *l1= new QLabel("Page:",ctoolbar);
  l1->setAutoResize(true);
  ctoolbar->insertWidget(BID_L1,l1->width(),l1);
  ctoolbar->insertCombo("100",BID_CP,true,SIGNAL(activated(const char *)),
		       this,SLOT(newCPageSLOT(const char *)),true,"Page",60);
  ctoolbar->getCombo(BID_CP)->setCompletion(true);

  QLabel *l2= new QLabel(" Sub:",ctoolbar);
  l2->setAutoResize(true);
  ctoolbar->insertWidget(BID_L2,l2->width(),l2);
  ctoolbar->insertCombo("0",BID_CSP,true,SIGNAL(activated(const char *)),
		       this,SLOT(newCSubPageSLOT(const char *)),true,"Subpage",50);
  ctoolbar->getCombo(BID_CSP)->setCompletion(true);

  QLabel *l3= new QLabel(" Program",ctoolbar);
  l3->setAutoResize(true);
  ctoolbar->insertWidget(BID_L3,l3->width(),l3);
  ctoolbar->getCombo(BID_PROG)->setCompletion(true);

//(QStrList *list, int id, bool writable, const char *signal, QObject *recevier, const char *slot, bool
//   enabled=true, const QString& tooltiptext=QString::null, int size=70, int index=-1, KCombo::Policy policy =
//     KCombo::AtBottom)
 
  addToolBar(toolbar);
  addToolBar(ctoolbar);

  QPopupMenu *exmenu=new QPopupMenu;
  exmenu->insertItem(i18n("&GIF"));
  exmenu->insertItem(i18n("&PPM"));
  exmenu->insertItem(i18n("&PGN"));
  exmenu->insertItem(i18n("&ASCII"));

  connect(exmenu,SIGNAL(activated(int)),this,SLOT(exportAsSLOT(int)));

  // file menu
  QPopupMenu *filemenu=new QPopupMenu;
  filemenu->insertItem(i18n("&Open ..."),this,SLOT(loadVTXSLOT()));
  filemenu->insertItem(i18n("&Save as ..."),this,SLOT(saveAsVTXSLOT()));
  filemenu->insertItem(i18n("&Export as"),exmenu);
  filemenu->insertSeparator();
  filemenu->insertItem(i18n("&Close"),this,SLOT(closeRequestSLOT()));

  QPopupMenu *fontmenu=new QPopupMenu;
  fontmenu->insertItem(i18n("vtx 10x12"));
  fontmenu->insertItem(i18n("vtx 15x18"));
  fontmenu->insertItem(i18n("vtx 20x24"));

  connect(fontmenu,SIGNAL(activated(int)),this,SLOT(newFontSLOT(int)));
  connect(fontmenu,SIGNAL(highlighted(int)),this,SLOT(newFontSLOT(int)));

  // options menu
  QPopupMenu *opmenu=new QPopupMenu;
  opmenu->insertItem(i18n("&Font size"),fontmenu);

  // menu bar  
  menubar = new KMenuBar( this );
  menubar->insertItem(i18n("&File"),filemenu);
  menubar->insertItem(i18n("&Options"),opmenu);
  setMenu(menubar);

  //vtxout = new QWidget( this );
  //setView(vtxout);
  
  vtxmap=0;
  cpagep=0;
  setNewFontSize( 12 );

  inInitPhase= false;

  pages= new pagedir;
  channels= new cachedir((const char *)(cacheDir));
  pages->setDir((const char *)(cacheDir+currProgram));

  ctoolbar->insertCombo(channels->getList(),BID_PROG,false,SIGNAL(activated(const char *)),
		       this,SLOT(newProgramSLOT(const char *)),true,"Program",120);

  ctoolbar->setCurrentComboItem(BID_PROG,0);

  currPage=FIRSTPAGE;
  showVTXPage(pages->setPage(currPage),false);
}

winVTXMainWidget::~winVTXMainWidget()
{
#ifdef vtxDEBUG
  debug("main: destroying winVTXMainWidget");
#endif

  // write back config
  KConfig *config=kapp->getConfig();
  config->setGroup("CONFIG_VideoText");
  config->writeEntry("VTXCacheDir",cacheDir);
  config->writeEntry("CurrentProgram",currProgram);
  config->writeEntry("VTXCharSet",vtx_charset);
  config->sync();

  delete pages;
#ifdef vtxDEBUG
  debug("main: ~winVTXMainWidget ends");
#endif
} 

void winVTXMainWidget::paintEvent( QPaintEvent * event )
{
#ifdef vtxDEBUG
  debug("vtx: paintEvent");
#endif
  bitBlt(this,0,menubar->height()+toolbar->height()+ctoolbar->height(),vtxmap);
}

void winVTXMainWidget::mouseReleaseEvent ( QMouseEvent * me )
{
#ifdef vtxDEBUG
  debug("vtx: mouseReleaseEvent");
#endif
  if ((me->button() == LeftButton)) {
    _page_ref * page= pagelist.first();
    while ( page ) {
      if ( page->rect.contains( me->pos() ) ) {
#ifdef vtxDEBUG
	debug("vtx: mouseReleaseEvent on page %d",page->page);
	debug("vtx: page %d,%d,%d,%d",page->rect.x(),page->rect.y(),page->rect.width(),page->rect.height());
	debug("vtx: mouse %d,%d",me->pos().x(),me->pos().y());
#endif
	lastPage=currPage;
	currPage=page->page;
	showVTXPage(pages->setPage(currPage));
	break;
      }
      page= pagelist.next();
    }
  }
}

void winVTXMainWidget::showVTXPageSLOT( vtxpage_t * page  )
{
#ifdef vtxDEBUG
  debug("vtx: show");
#endif
  int dn,dnp;
  int pos,x,y;
  int bg,fg,lbg,lfg,hidden;
  lbg=-1; lfg=-1;
  bool show_hidden=false;

  if ( !page ) return;

  pagelist.clear();

  vtxp->begin( vtxmap );
  vtxp->setFont(QFont("videotext",currFSize));
  vtxp->setBackgroundMode( OpaqueMode );

  x=0;y=fm_height;
  for ( pos = 0; pos < VTX_PAGESIZE; pos++) {
    fg     =  page->attrib[pos] & VTX_COLMASK;
    bg     = (page->attrib[pos] & VTX_BGMASK) >> 3;
    hidden = (page->attrib[pos] & VTX_HIDDEN) && !show_hidden;

    // check for page numbers
    if ( (pos > 40) && (dummy[0] >= '0') && (dummy[0] <= '9') ) {
      dn++;
      switch (dn) {
      case 1: dnp+= 100*(dummy[0]-'0'); break;
      case 2: dnp+= 10*(dummy[0]-'0'); break;
      case 3: dnp+= (dummy[0]-'0'); break;
      }
      if ( dn == 3 ) {
	_page_ref * prf = new _page_ref;
	prf->page=dnp;
	prf->fga=lfg;
	prf->bga=lbg;
	prf->rect.setRect(x-(3*fm_width),y-fm_height+ytoffset,3*fm_width,fm_height);
#ifdef vtxDEBUG
	//debug("vtx: page %d,%d,%d,%d",x-(3*fm_width),y-fm_height+ytoffset,3*fm_width,fm_height);
#endif
	pagelist.append(prf);
      }
    } else { 
      
      dn=0;
      dnp=0;
    }

    // draw the character
    if (fg != lfg || bg != lbg) {
      // set the color
      vtxp->setPen( CLUT[fg] ); 
      vtxp->setBackgroundColor( CLUT[bg] );
      lfg = fg;
      lbg = bg;
    }
    dummy[0]=page->chr[pos];
    vtxp->drawText( x, y, dummy );
    x+= fm_width;
    if ( (pos % 40) == 39 ) {
      y+= fm_height;
      x=0;
    }
  }
  vtxp->flush();
#ifdef vtxDEBUG
  _page_ref *pr= pagelist.first();
  while (pr) {
    vtxp->setPen( black );
    vtxp->drawRect(pr->rect.x(),pr->rect.y()-ytoffset,pr->rect.width(),pr->rect.height());
    vtxp->setPen( CLUT[fg] ); 
    pr= pagelist.next();
  }
#endif
  vtxp->end();

  repaint();
}

void winVTXMainWidget::closeRequestSLOT()
{
}

void winVTXMainWidget::loadVTXSLOT()
{
  warning("vtx: unsupported");
}

void winVTXMainWidget::saveAsVTXSLOT()
{
  warning("vtx: unsupported");
}

void winVTXMainWidget::exportAsSLOT(int val)
{
  switch (val) {
  default:
    warning("vtx: unsupported");
  }
}

void winVTXMainWidget::newCPageSLOT(const char * npage)
{
  lastPage=currPage;
  currPage=atoi(npage);
  showVTXPage(pages->setPage(currPage),false);
#ifdef vtxDEBUG
  debug("vtx: newCPage %s,%d",npage,currPage);
#endif
}

void winVTXMainWidget::newCSubPageSLOT(const char * npage)
{
  currSubPage=atoi(npage);
  showVTXPage(pages->setSubPage(currSubPage),false);
#ifdef vtxDEBUG
  debug("vtx: newCSubPage %s,%d",npage,currSubPage);
#endif
}

void winVTXMainWidget::insertPageToCombos( int p, int sp )
{
  QString dum;
  dum.setNum(currPage);
  if ( !cplist->contains(dum) ) {
    cplist->append(dum);
    ctoolbar->insertComboItem(BID_CP,(const char *)dum,-1);
    ctoolbar->setCurrentComboItem(BID_CP,cplist->count()-1);
    
  }
  dum.setNum(currSubPage);
  if ( !csplist->contains(dum) ) {
    csplist->append(dum);
    ctoolbar->insertComboItem(BID_CSP,(const char *)dum,-1);
    ctoolbar->setCurrentComboItem(BID_CSP,cplist->count()-1);
  }
}

void winVTXMainWidget::showVTXPage( vtxpage_t * page, bool insert )
{
#ifdef vtxDEBUG
  debug("vtx: showVTXPage");
#endif
  if ( page == cpagep ) return;
  cpagep= page;
  if ( cpagep ) {
    showVTXPageSLOT( cpagep );
    currPage=pages->currentPage();
    currSubPage=pages->currentSubPage(); 
    if ( insert ) insertPageToCombos(currPage,currSubPage);
  }
}

void winVTXMainWidget::buttonsSLOT(int id)
{
  switch (id) {
  case BID_NEXT:
    {
      lastPage=currPage;
      showVTXPage(pages->nextPage());
      currPage=pages->currentPage();
    }
    break;
  case BID_PREV:
    {
      lastPage=currPage;
      showVTXPage(pages->prevPage());
      currPage=pages->currentPage();
    }
    break;
  case BID_SNEXT:
    {
      showVTXPage(pages->nextSubPage());
      currSubPage=pages->currentSubPage();
    }
    break;
  case BID_SPREV:
    {
      showVTXPage(pages->prevSubPage());
      currSubPage=pages->currentSubPage();
    }
    break;
  case BID_HOME:
    {
      lastPage=currPage;
      currPage=100;
      currSubPage=0;
      showVTXPage(pages->setPage(currPage));
    }
    break;
  case BID_RELOAD:
    {
      showVTXPage(pages->reload());
    }
    break;
  case BID_BACK:
    {
      showVTXPage(pages->setPage(lastPage));
    }
    break;
  case BID_CLOSE:
    closeRequestSLOT();
    break;
  default:
    warning("vtx: unsupported toolbar button!");
  }
}

void winVTXMainWidget::newFontSLOT( int val )
{
#ifdef vtxDEBUG
    debug("vtx: newFontSLOT %d",val);
#endif
  int fs=12;
  switch (val) {
  case 0: fs=12; break;
  case 1: fs=18; break;
  case 2: fs=24; break;
  }

  setNewFontSize(fs);
}

void winVTXMainWidget::setNewFontSize( int size )
{
#ifdef vtxDEBUG
    debug("vtx: setNewFontSize %d",size);
#endif
  int w,h;
  currFSize= size;
  vtxp = new QPainter();
  vtxp->begin( this );
  vtxp->setFont(QFont("videotext",size));
  QFontMetrics fm = vtxp->fontMetrics();
  fm_width=fm.width(' ');
  fm_height=fm.height();
  w=40*fm.width(' ');
  h=25*fm.height();
  vtxp->end();

  if ( vtxmap ) delete vtxmap;
  vtxmap= new QPixmap( w, h );
  
  yoffset= menubar->height()+toolbar->height()+ctoolbar->height()+statusbar->height();
  ytoffset= menubar->height()+toolbar->height()+ctoolbar->height();

  setFixedSize( w, h+yoffset );
  resize( w, h+yoffset );

  if ( cpagep ) {
    showVTXPageSLOT( cpagep );
  }
}

void winVTXMainWidget::newProgramSLOT( const char * name )
{
#ifdef vtxDEBUG
  debug("vtx: newProgram %s",(const char *)name);
#endif 
  currProgram=name;
  pages->setDir((const char *)(cacheDir+currProgram));

  cplist->clear();  
  ctoolbar->clearCombo(BID_CP); 
  csplist->clear();
  ctoolbar->clearCombo(BID_CSP); 

  lastPage=FIRSTPAGE;
  currPage=FIRSTPAGE;
  currSubPage=0;
  showVTXPage(pages->setPage(currPage));
}

//----------------------------------------------------------------------
// do not edit!
#include "winvtxmain.moc"

