/* $Id: dlgAutomation.cpp,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: dlgAutomation.cpp,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.1  1999/02/07 17:11:28  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>

#include <kapp.h>

#include "dlgAutomation.h"

extern QString getStringFromBool( bool x );
extern QString getStringFromInt( int x );
extern bool getBoolFromString( QString s );
extern int getIntFromString( QString s );

DlgAutomation::DlgAutomation(QWidget *parent, const char *name, WFlags f)
  : QWidget(parent, name, f)
{

  QGridLayout *topGridLayout = new QGridLayout(this, 10, 7, 5);

  topGridLayout->addRowSpacing(0,10);
  topGridLayout->addRowSpacing(6,10);
  topGridLayout->addRowSpacing(9,10);

  topGridLayout->addColSpacing(0,5);
  topGridLayout->addColSpacing(6,5);

  topGridLayout->setRowStretch(0,5);
  topGridLayout->setRowStretch(1,10);
  topGridLayout->setRowStretch(2,10);
  topGridLayout->setRowStretch(3,10);
  topGridLayout->setRowStretch(4,10);
  topGridLayout->setRowStretch(5,10);
  topGridLayout->setRowStretch(6,10);
  topGridLayout->setRowStretch(7,10);
  topGridLayout->setRowStretch(8,10);
  topGridLayout->setRowStretch(9,5);
    
  topGridLayout->setColStretch(0,2);
  topGridLayout->setColStretch(1,10);
  topGridLayout->setColStretch(2,10);
  topGridLayout->setColStretch(3,2);
  topGridLayout->setColStretch(4,5);
  topGridLayout->setColStretch(5,5);
  topGridLayout->setColStretch(6,2);

  // auto save
  cb_autoSave = new QCheckBox( i18n("Auto save file list every"), this );
  cb_autoSave->setMinimumSize( cb_autoSave->sizeHint() );
  topGridLayout->addMultiCellWidget( cb_autoSave, 1, 1, 1, 2 );

  le_autoSave = new KIntegerLine( this );
  le_autoSave->setFixedHeight( le_autoSave->sizeHint().height() );
  topGridLayout->addMultiCellWidget( le_autoSave, 1, 1, 3, 4 );

  lb_autoSave = new QLabel( i18n("minutes"), this );
  topGridLayout->addWidget( lb_autoSave, 1, 5 );

  connect( cb_autoSave, SIGNAL(toggled(bool)),le_autoSave, SLOT(setEnabled(bool)) );

  // auto disconnect
  cb_autoDisconnect = new QCheckBox( i18n("Auto disconnect after done downloading"),
				     this );
  cb_autoDisconnect->setMinimumSize( cb_autoDisconnect->sizeHint() );
  topGridLayout->addMultiCellWidget( cb_autoDisconnect, 2, 2, 1, 3 );

  lb_autoDisconnect = new QLabel(i18n("Disconnect command :"), this);
  topGridLayout->addMultiCellWidget( lb_autoDisconnect, 3, 3, 2, 3 );

  le_autoDisconnect = new QLineEdit(this);
  le_autoDisconnect->setFixedHeight( le_autoDisconnect->sizeHint().height() );
  topGridLayout->addMultiCellWidget( le_autoDisconnect, 3, 3, 4, 5 );

  cb_timedDisconnect = new QCheckBox( i18n("Timed disconnect"),
				      this );
  cb_timedDisconnect->setMinimumSize( cb_timedDisconnect->sizeHint() );
  topGridLayout->addMultiCellWidget( cb_timedDisconnect, 4, 4, 1, 3 );

  spins = new BWDateTime(disconnectDateTime, this, "spins");
  spins->setMinimumHeight( 95 );
  topGridLayout->addMultiCellWidget( spins, 5, 5, 2, 5 );

  connect( cb_autoDisconnect, SIGNAL(toggled(bool)), this, SLOT( disconnectToggled(bool)));
  connect( cb_timedDisconnect, SIGNAL(toggled(bool)),spins, SLOT(setEnabled(bool)) );
  
  // auto shutdown
  cb_autoShutdown = new QCheckBox( i18n("Auto shutdown after done downloading"),
				   this );
  cb_autoShutdown->setMinimumSize( cb_autoShutdown->sizeHint() );
  topGridLayout->addMultiCellWidget( cb_autoShutdown, 7, 7, 1, 3 );
  
  // auto paste
  cb_autoPaste = new QCheckBox( i18n("Auto paste from clipboard"),
				   this );
  topGridLayout->addMultiCellWidget( cb_autoPaste, 8, 8, 1, 2 );

  topGridLayout->activate();
}


DlgAutomation::~DlgAutomation()
{
}


void DlgAutomation::disconnectToggled(bool flag) {

  le_autoDisconnect->setEnabled( flag );
  cb_timedDisconnect->setEnabled( flag );
  if ( cb_timedDisconnect->isChecked() )
    spins->setEnabled( flag );
}


void DlgAutomation::setData(QStrList *strList)
{
  // auto save
  bool autoSave = getBoolFromString( strList->first() );
  le_autoSave->setEnabled( autoSave );
  cb_autoSave->setChecked( autoSave );
  
  le_autoSave->setValue( getIntFromString( strList->next() ) );

  // auto disconnect
  bool autoDisconnect = getBoolFromString( strList->next() );
  le_autoDisconnect->setEnabled( autoDisconnect );
  cb_timedDisconnect->setEnabled( autoDisconnect );
  spins->setEnabled( autoDisconnect );
  cb_autoDisconnect->setChecked( autoDisconnect );

  le_autoDisconnect->setText( strList->next() );

  bool timedDisconnect = getBoolFromString( strList->next() );
  cb_timedDisconnect->setChecked( timedDisconnect );
  spins->setEnabled( timedDisconnect );

  if ( timedDisconnect ) {
    QTime time;
    QDate date;
    int hour = getIntFromString( strList->next() );
    int minute = getIntFromString( strList->next() );
    time.setHMS( hour, minute , 0 );
    int year = getIntFromString( strList->next() );
    int month = getIntFromString( strList->next() );
    int day = getIntFromString( strList->next() );
    date.setYMD( year, month, day );
    disconnectDateTime.setTime( time );
    disconnectDateTime.setDate( date );
  } else {
    disconnectDateTime = QDateTime::currentDateTime();
  }

  spins->setDateTime( disconnectDateTime );

  // auto shutdown
  cb_autoShutdown->setChecked( getBoolFromString( strList->next() ) );

  // auto paste
  cb_autoPaste->setChecked( getBoolFromString( strList->next() ) );

}


static QStrList strList(true);


QStrList DlgAutomation::getData() const
{
  strList.clear();
  QString tmp;
  
  // auto save
  strList.append( getStringFromBool( cb_autoSave->isChecked() ) );
  strList.append( getStringFromInt( le_autoSave->value() ) );
  strList.append( getStringFromBool( cb_autoDisconnect->isChecked() ) );
  strList.append( le_autoDisconnect->text() );
  strList.append( getStringFromBool( cb_timedDisconnect->isChecked() ) );
  if ( cb_timedDisconnect->isChecked() ) {
    QTime time = spins->getDateTime().time();
    QDate date = spins->getDateTime().date();
    strList.append( getStringFromInt( time.hour() ) );
    strList.append( getStringFromInt( time.minute() ) );
    strList.append( getStringFromInt( date.year() ) );
    strList.append( getStringFromInt( date.month() ) );
    strList.append( getStringFromInt( date.day() ) );
  }
  strList.append( getStringFromBool( cb_autoShutdown->isChecked() ) );
  strList.append( getStringFromBool( cb_autoPaste->isChecked() ) );

  return strList;
}
