extern "C" 
{
  #include "k2url.parse.h"

  void k2url_mainParse( char *_code );  
};

#include "k2url.h"

#include <assert.h>
#include <stdlib.h>

K2URL* g_pKURL = 0L;
bool g_error = false;

bool k2url_parse( K2URL *_url, const char *_txt )
{
  g_pKURL = _url;
  g_error = false;

  k2url_mainParse( (char*)_txt );

  return !g_error;
}

void k2url_setError()
{
  g_error = true;
}

// HACK decode stuff here!

void k2url_setProtocol( char* _txt )
{
  assert( g_pKURL );
  
  g_pKURL->setProtocol( _txt );
} 

void k2url_setUser( char * _txt )
{
  assert( g_pKURL );

  g_pKURL->setUser( _txt );
}

void k2url_setPass( char* _txt )
{
  assert( g_pKURL );

  g_pKURL->setPass( _txt );
}

void k2url_setHost( char* _txt )
{
  assert( g_pKURL );

  g_pKURL->setHost( _txt );
}

void k2url_setPort( char* _txt )
{
  assert( g_pKURL );

  g_pKURL->setPort( atoi( _txt ) );
}

void k2url_setPath( char* _txt )
{
  assert( g_pKURL );

  g_pKURL->setEncodedPathAndQuery( _txt );
}

void k2url_setRef( char* _txt )
{
  assert( g_pKURL );

  g_pKURL->setRef( _txt );
}

