/************************************************************
  	Copyright (c) 97 Michael Glauche
  	Copyright (c) 98 Karl Backstrm

  	This code is under GPL - see COPYING.
  ************************************************************/

#include <sys/types.h>
#include <signal.h>
#include <unistd.h>

#include <ktopwidget.h>
#include <kpanner.h>
#include <time.h>        
#include <qlined.h>
#include <ktabctl.h>
#include <qregexp.h>
#include <qlayout.h>
#include <qchkbox.h>
#include <qfile.h>
#include <qtstream.h>
#include <qtextstream.h>
#include <qfileinfo.h>
#include <qmessagebox.h>
#include <qdir.h>

#include "bind.h"
#include "ksoaedit.h"
#include "secondary.h"
#include "newPrimary.h"
#include "newSecondary.h"
#include "bindDialog.h"
#include "setupDialog.h"

#include "bind.moc"

#define  X_LIST_SIZE     150

const char *TYPES2[] = {"","A","NS","","","CNAME","SOA","MB","MG","MR",
			"","WKS","PTR","HINFO","MINFO","MX","TXT","RP",
			"AFSDB","X25","ISDN","RT"} ;

KBindWidget::KBindWidget(QWidget *parent, const char *name):
  KConfigWidget(parent, name)
{
  QBoxLayout *topLayout = new QVBoxLayout(this, 5);

  KTabCtl *tb = new KTabCtl(this);

  topLayout->addWidget(tb,1);

  QWidget *primary = new QWidget(tb);
  QWidget *other = new QWidget(tb); 
  QWidget *misc = new QWidget(tb);
  QWidget *misc2 = new QWidget(tb);
  QWidget *simplestats = new QWidget(tb);
  QWidget *running = new QWidget(tb);

  directory = new QString();
  cache = new QString();
  namedxfer = new QString();
  dump = new QString();
  memstatistics  = new QString();
  pid = new QString();
  statistics = new QString();

  tb->addTab(primary,i18n("Primary/Secondary"));
  tb->addTab(other,i18n("Other"));
  tb->addTab(misc,i18n("Misc"));
  tb->addTab(misc2,i18n("8.1+ Misc"));
  tb->addTab(simplestats,i18n("Status"));
  tb->addTab(running,i18n("Running"));

  QBoxLayout *tabPSLayout = new QVBoxLayout(primary, 5);
  QBoxLayout *tabOLayout = new QVBoxLayout(other, 5);
  QBoxLayout *tabMiscLayout = new QVBoxLayout(misc, 5);
  QGridLayout *tabMiscGrid = new QGridLayout(3, 2);
  QBoxLayout *tabMisc2Layout = new QVBoxLayout(misc2, 5);
  QGridLayout *tabMisc2Grid = new QGridLayout(2, 2);
  QBoxLayout *tabSSLayout = new QVBoxLayout(simplestats, 5);
  QBoxLayout *tabRLayout = new QHBoxLayout(running, 5); 

  QBoxLayout *primaryLayout = new QHBoxLayout();
  QBoxLayout *secondaryLayout = new QHBoxLayout();

  QBoxLayout *forwardLayout = new QHBoxLayout();
  QBoxLayout *xferLayout = new QHBoxLayout();
  QBoxLayout *bogusLayout = new QHBoxLayout();

  QGridLayout *dataGrid = new QGridLayout( 2, 3);
  QGridLayout *dataGrid2 = new QGridLayout( 3, 5);

  QBoxLayout *tabRLeftLayout = new QVBoxLayout();
  QBoxLayout *tabRRightLayout = new QVBoxLayout();

  QBoxLayout *leftPrimaryLayout = new QVBoxLayout();
  QBoxLayout *rightPrimaryLayout = new QVBoxLayout();
  QBoxLayout *leftSecondaryLayout = new QVBoxLayout();
  QBoxLayout *rightSecondaryLayout = new QVBoxLayout();
  QBoxLayout *leftForwardLayout = new QVBoxLayout();
  QBoxLayout *rightForwardLayout = new QVBoxLayout();
  QBoxLayout *leftXferLayout = new QVBoxLayout();
  QBoxLayout *rightXferLayout = new QVBoxLayout();
  QBoxLayout *leftBogusLayout = new QVBoxLayout();
  QBoxLayout *rightBogusLayout = new QVBoxLayout();

  QFont font( "helvetica", 10, 50, 0 );
  font.setStyleHint( (QFont::StyleHint)0 );
  font.setCharSet( (QFont::CharSet)0 );

  tabMiscLayout->addLayout( dataGrid);
  tabMiscLayout->addLayout(tabMiscGrid, 5);

  tabMisc2Layout->addLayout( dataGrid2);
  tabMisc2Layout->addLayout(tabMisc2Grid, 5);

  dataGrid->setColStretch( 2, 10);
  dataGrid2->setColStretch( 4, 10);

  tabPSLayout->addLayout(primaryLayout, 1);
  tabPSLayout->addLayout(secondaryLayout, 0);

  tabOLayout->addLayout(forwardLayout, 0);
  tabOLayout->addLayout(xferLayout, 0);
  tabOLayout->addLayout(bogusLayout, 1);

  tabRLayout->addLayout(tabRLeftLayout);
  tabRLayout->addLayout(tabRRightLayout,5);

  primaryLayout->addLayout(leftPrimaryLayout, 10);
  primaryLayout->addLayout(rightPrimaryLayout, 0);
  secondaryLayout->addLayout(leftSecondaryLayout, 10);
  secondaryLayout->addLayout(rightSecondaryLayout, 0);
  forwardLayout->addLayout(leftForwardLayout, 1);
  forwardLayout->addLayout(rightForwardLayout, 0);
  xferLayout->addLayout(leftXferLayout, 1);
  xferLayout->addLayout(rightXferLayout, 0);
  bogusLayout->addLayout(leftBogusLayout, 1);
  bogusLayout->addLayout(rightBogusLayout, 0);

  newp = new QPushButton(i18n("New"),primary);
  newp->setMinimumSize(newp->sizeHint());
  rightPrimaryLayout->addWidget(newp);
  connect(newp,SIGNAL(clicked()),SLOT(pnewclicked()));

  delp = new QPushButton(i18n("Delete"),primary);
  delp->setMinimumSize(delp->sizeHint());
  rightPrimaryLayout->addWidget(delp);
  connect(delp,SIGNAL(clicked()),SLOT(pdelclicked()));
  delp->setEnabled(false);

  rightPrimaryLayout->addStretch(1);

  pl1 = new QLabel(i18n("Primary Domains:"),primary);  
  pl1->setAutoResize(TRUE);
  pl1->setMinimumSize(pl1->sizeHint());
  leftPrimaryLayout->addWidget(pl1);

  plist = new QListBox(primary,"primary");
  plist->setMinimumSize(X_LIST_SIZE,80);
  leftPrimaryLayout->addWidget(plist, 1);

  //  leftPrimaryLayout->addStretch(1);

  news = new QPushButton(i18n("New"),primary);
  news->setMinimumSize(news->sizeHint());
  rightSecondaryLayout->addWidget(news);
  connect(news,SIGNAL(clicked()),SLOT(snewclicked()));

  dels = new QPushButton(i18n("Delete"),primary);
  dels->setMinimumSize(dels->sizeHint());
  rightSecondaryLayout->addWidget(dels);
  connect(dels,SIGNAL(clicked()),SLOT(sdelclicked()));
  dels->setEnabled(false);

  rightSecondaryLayout->addStretch(1);

  sl1 = new QLabel(i18n("Secondary Domains:"),primary);  
  sl1->setAutoResize(TRUE);
  sl1->setMinimumSize(sl1->sizeHint());
  leftSecondaryLayout->addWidget(sl1);

  slist = new QListBox(primary,"secondary");
  slist->setMinimumSize(X_LIST_SIZE,80);
  leftSecondaryLayout->addWidget(slist, 1);

  //  leftSecondaryLayout->addStretch(1);

  QLabel *fl = new QLabel(i18n("Forwarders (Name servers to send unresolved querys to) :"),other);
  fl->setAutoResize(TRUE);
  fl->setMinimumSize(fl->sizeHint());
  leftForwardLayout->addWidget(fl);
  
  flist = new QListBox(other,"forwarders");
  flist->setMinimumSize(X_LIST_SIZE,80);
  leftForwardLayout->addWidget(flist);

  newf = new QPushButton(i18n("New"),other);
  newf->setMinimumSize(news->sizeHint());
  rightForwardLayout->addWidget(newf);
  connect(newf,SIGNAL(clicked()),SLOT(fnewclicked()));

  delf = new QPushButton(i18n("Delete"),other);
  delf->setMinimumSize(delf->sizeHint());
  rightForwardLayout->addWidget(delf);
  connect(delf,SIGNAL(clicked()),SLOT(fdelclicked()));
  delf->setEnabled(false);

  rightForwardLayout->addStretch(1);
  leftForwardLayout->addStretch(1);

  QLabel *xl = new QLabel(i18n("Answer only these hosts :"),other);
  xl->setAutoResize(TRUE);
  xl->setMinimumSize(xl->sizeHint());
  leftXferLayout->addWidget(xl);

  xlist = new QListBox(other,"xfernets");
  xlist->setMinimumSize(X_LIST_SIZE,80);
  leftXferLayout->addWidget(xlist);

  newx = new QPushButton(i18n("New"),other);
  newx->setMinimumSize(newx->sizeHint());
  rightXferLayout->addWidget(newx);
  connect(newx,SIGNAL(clicked()),SLOT(xnewclicked()));

  delx = new QPushButton(i18n("Delete"),other);
  delx->setMinimumSize(delx->sizeHint());
  rightXferLayout->addWidget(delx);
  connect(delx,SIGNAL(clicked()),SLOT(xdelclicked()));
  delx->setEnabled(false);

  leftXferLayout->addStretch(1);
  rightXferLayout->addStretch(1);

  QLabel *bl = new QLabel(i18n("Bogus (Don't query these Servers) :"), other);
  bl->setAutoResize(TRUE);
  bl->setMinimumSize(bl->sizeHint());
  leftBogusLayout->addWidget(bl);
    
  blist = new QListBox(other,"bogusns");
  blist->setMinimumSize(X_LIST_SIZE,80);
  leftBogusLayout->addWidget(blist);

  newb = new QPushButton(i18n("New"),other);
  newb->setMinimumSize(newb->sizeHint());
  rightBogusLayout->addWidget(newb);
  connect(newb,SIGNAL(clicked()),SLOT(bnewclicked()));

  delb = new QPushButton(i18n("Delete"),other);
  delb->setMinimumSize(delb->sizeHint());
  rightBogusLayout->addWidget(delb);
  connect(delb,SIGNAL(clicked()),SLOT(bdelclicked()));
  delb->setEnabled(false);


  leftBogusLayout->addStretch(1);
  rightBogusLayout->addStretch(1);

  ml1 = new QLabel(i18n("Data Path :"),misc);
  ml1->setMinimumSize(ml1->sizeHint());
  dataGrid->addWidget(ml1, 0, 0);

  ml2 = new QLabel(i18n("Cache Data file :"),misc);
  ml2->setMinimumSize(ml2->sizeHint());
  dataGrid->addWidget(ml2, 1, 0);

  ml7 = new QLabel(i18n("Named-xfer :"),misc2);
  ml7->setMinimumSize(ml7->sizeHint());
  dataGrid2->addWidget(ml7, 0, 0);

  ml3 = new QLabel(i18n("Pid file :"),misc2);
  ml3->setMinimumSize(ml3->sizeHint());
  dataGrid2->addWidget(ml3, 1, 0);

  ml4 = new QLabel(i18n("Dump file :"),misc2);
  ml4->setMinimumSize(ml4->sizeHint());
  dataGrid2->addWidget(ml4, 2, 0);

  ml5 = new QLabel(i18n("Statistics file :"),misc2);
  ml5->setMinimumSize(ml5->sizeHint());
  dataGrid2->addWidget(ml5, 0, 2);

  ml6 = new QLabel(i18n("Memstatistics file :"),misc2);
  ml6->setMinimumSize(ml6->sizeHint());
  dataGrid2->addWidget(ml6, 1, 2);

  diredit = new QLineEdit(misc);
  diredit->setFixedSize(100,20);
  diredit->setFont( font );
  dataGrid->addWidget(diredit, 0, 1);

  cacheedit = new QLineEdit(misc);
  cacheedit->setFixedSize(100,20);
  cacheedit->setFont( font );
  dataGrid->addWidget(cacheedit, 1, 1);

  xferedit = new QLineEdit(misc2);
  xferedit->setFixedSize(100,20);
  xferedit->setFont( font );
  dataGrid2->addWidget(xferedit, 0, 1);

  pidedit = new QLineEdit(misc2);
  pidedit->setFixedSize(100,20);
  pidedit->setFont( font );
  dataGrid2->addWidget(pidedit, 1, 1);

  dumpedit = new QLineEdit(misc2);
  dumpedit->setFixedSize(100,20);
  dumpedit->setFont( font );
  dataGrid2->addWidget(dumpedit, 2, 1);

  statisticsedit= new QLineEdit(misc2);
  statisticsedit->setFixedSize(100,20);
  statisticsedit->setFont( font );
  dataGrid2->addWidget(statisticsedit, 0, 3);

  memstatisticsedit= new QLineEdit(misc2);
  memstatisticsedit->setFixedSize(100,20);
  memstatisticsedit->setFont( font );
  dataGrid2->addWidget(memstatisticsedit, 1, 3);

  QSize *object_size = new QSize();

  option_box = new QGroupBox(i18n("Options"),misc);
  tabMiscGrid->addMultiCellWidget( option_box, 0, 1, 0, 0 );

  fo_check = new QCheckBox(i18n("Forward Only"),option_box);
  fo_check->setFont( font );
  *object_size = fo_check->sizeHint();
  fo_check->setGeometry(10,15,object_size->width(),object_size->height());

  nor_check = new QCheckBox(i18n("No Recursion"),option_box);
  nor_check->setFont( font );
  *object_size = nor_check->sizeHint();
  nor_check->setGeometry(10,30,object_size->width(),object_size->height());

  nofg_check = new QCheckBox(i18n("No Fetch Glue"),option_box);
  nofg_check->setFont( font );
  *object_size = nofg_check->sizeHint();
  nofg_check->setGeometry(10,45,object_size->width(),object_size->height());

  ql_check = new QCheckBox(i18n("Query Log"),option_box);
  ql_check->setFont( font );
  *object_size = ql_check->sizeHint();
  ql_check->setGeometry(10,60,object_size->width(),object_size->height());

  fi_check = new QCheckBox(i18n("Fake Iquery"),option_box);
  fi_check->setFont( font );
  *object_size = fi_check->sizeHint();
  fi_check->setGeometry(10,75,object_size->width(),object_size->height());

  option_box2 = new QGroupBox(i18n("Options"),misc2);
  option_box2->setFixedWidth( 200);
  tabMisc2Grid->addMultiCellWidget( option_box2, 0, 1, 0, 0 );

  non_check = new QCheckBox(i18n("No Notify"),option_box2);
  non_check->setFont( font );
  *object_size = non_check->sizeHint();
  non_check->setGeometry(10,15,object_size->width(),object_size->height());

  mc_check = new QCheckBox(i18n("Multiple Cnames"),option_box2);
  mc_check->setFont( font );
  *object_size = mc_check->sizeHint();
  mc_check->setGeometry(10,30,object_size->width(),object_size->height());

  hs_check = new QCheckBox(i18n("Host Statistics"),option_box2);
  hs_check->setFont( font );
  *object_size = hs_check->sizeHint();
  hs_check->setGeometry(10,45,object_size->width(),object_size->height());

  doe_check = new QCheckBox(i18n("Deallocate on Exit"),option_box2);
  doe_check->setFont( font );
  *object_size = doe_check->sizeHint();
  doe_check->setGeometry(10,60,object_size->width(),object_size->height());

  nan_check = new QCheckBox(i18n("No Auth Nxdomain"),option_box2);
  nan_check->setFont( font );
  *object_size = nan_check->sizeHint();
  nan_check->setGeometry(10,75,object_size->width(),object_size->height());

  limits2GroupBox = new QGroupBox( i18n("Limits"), misc2 );
  tabMisc2Grid->addWidget( limits2GroupBox, 0, 1 );

  limitTransferFormatLabel = new QLabel( i18n("Transfer Format :"), limits2GroupBox );
  *object_size = limitTransferFormatLabel->sizeHint();
  limitTransferFormatLabel->setGeometry(10,15,object_size->width(),object_size->height());
  limitTransferFormatComboBox = new QComboBox( FALSE, limits2GroupBox );   
  limitTransferFormatComboBox->insertItem( i18n("One answer (default)") );
  limitTransferFormatComboBox->insertItem( i18n("Many answers") );
  *object_size = limitTransferFormatComboBox->sizeHint();
  limitTransferFormatComboBox->setGeometry( 130, 15, object_size->width(),object_size->height());

  limitCoreSizeLabel = new QLabel( i18n("Coresize :"), limits2GroupBox );
  *object_size = limitCoreSizeLabel->sizeHint();
  limitCoreSizeLabel->setGeometry( 10, 45, object_size->width(),object_size->height());
  limitCoreSizeEdit = new QLineEdit( limits2GroupBox );
  limitCoreSizeEdit->setGeometry( 160, 45, 75, 20);

  limitStackSizeLabel = new QLabel( i18n("Stacksize :"), limits2GroupBox );
  *object_size = limitStackSizeLabel->sizeHint();
  limitStackSizeLabel->setGeometry( 10, 70, object_size->width(),object_size->height());
  limitStackSizeEdit = new QLineEdit( limits2GroupBox );
  limitStackSizeEdit->setGeometry( 160, 70, 75, 20);

  limitTransfersOutLabel = new QLabel( i18n("Transfers out :"), limits2GroupBox );
  *object_size = limitTransfersOutLabel->sizeHint();
  limitTransfersOutLabel->setGeometry( 10, 95, object_size->width(),object_size->height());
  limitTransfersOutEdit = new QLineEdit( limits2GroupBox );
  limitTransfersOutEdit->setGeometry( 160, 95, 75, 20);

  limitMaxTransferTimeInLabel = new QLabel( i18n("Max transfer time in :"), limits2GroupBox );
  *object_size = limitMaxTransferTimeInLabel->sizeHint();
  limitMaxTransferTimeInLabel->setGeometry( 10, 120, object_size->width(),object_size->height());
  limitMaxTransferTimeInEdit = new QLineEdit( limits2GroupBox );
  limitMaxTransferTimeInEdit->setGeometry( 160, 120, 75, 20);

  intervalGroupBox = new QGroupBox( i18n("Periodic Task Intervals"), misc2 );
  intervalGroupBox->setFixedHeight( 100 );
  tabMisc2Grid->addWidget( intervalGroupBox, 1, 1 );

  intervalCleaningLabel = new QLabel( i18n("Cleaning :"), intervalGroupBox );
  *object_size = intervalCleaningLabel->sizeHint();
  intervalCleaningLabel->setGeometry( 10, 20, object_size->width(),object_size->height());
  intervalCleaningEdit = new QLineEdit( intervalGroupBox );
  intervalCleaningEdit->setGeometry( 160, 20, 75, 20);

  intervalInterfaceLabel = new QLabel( i18n("Interface :"), intervalGroupBox );
  *object_size = intervalInterfaceLabel->sizeHint();
  intervalInterfaceLabel->setGeometry( 10, 45, object_size->width(),object_size->height());
  intervalInterfaceEdit = new QLineEdit( intervalGroupBox );
  intervalInterfaceEdit->setGeometry( 160, 45, 75, 20);

  intervalStatisticsLabel = new QLabel( i18n("Statistics :"), intervalGroupBox );
  *object_size = intervalStatisticsLabel->sizeHint();
  intervalStatisticsLabel->setGeometry( 10, 70, object_size->width(),object_size->height());
  intervalStatisticsEdit = new QLineEdit( intervalGroupBox );
  intervalStatisticsEdit->setGeometry( 160, 70, 75, 20);
  
  ///// Beginning check-names section. /////
  checkNamesGroupBox = new QGroupBox( i18n("Check names"), misc );
  checkNamesGroupBox->setFixedSize( 300, 100 );
  tabMiscGrid->addWidget( checkNamesGroupBox, 0, 1 );

  checkNamePrimaryLabel = new QLabel( i18n("Primary :"), checkNamesGroupBox );
  // checkNamePrimaryLabel->setFont( font );
  *object_size = checkNamePrimaryLabel->sizeHint();
  checkNamePrimaryLabel->setGeometry(10,15,object_size->width(),object_size->height());
  checkNamePrimaryComboBox = new QComboBox( FALSE, checkNamesGroupBox );   
  checkNamePrimaryComboBox->insertItem( i18n("Default") );
  checkNamePrimaryComboBox->insertItem( i18n("Fail") );
  checkNamePrimaryComboBox->insertItem( i18n("Ignore") );
  checkNamePrimaryComboBox->insertItem( i18n("Warn") );
  // checkNamePrimaryComboBox->setFont( font );
  *object_size = checkNamePrimaryComboBox->sizeHint();
  checkNamePrimaryComboBox->setGeometry( 140, 15, object_size->width(),object_size->height());
  
  checkNameSecondaryLabel = new QLabel( i18n("Secondary :"), checkNamesGroupBox );
  // checkNameSecondaryLabel->setFont( font );
  *object_size = checkNameSecondaryLabel->sizeHint();
  checkNameSecondaryLabel->setGeometry( 10, 40,object_size->width(),object_size->height());
  checkNameSecondaryComboBox = new QComboBox( FALSE, checkNamesGroupBox );  
  checkNameSecondaryComboBox->insertItem( i18n("Default") );
  checkNameSecondaryComboBox->insertItem( i18n("Fail") );
  checkNameSecondaryComboBox->insertItem( i18n("Ignore") );
  checkNameSecondaryComboBox->insertItem( i18n("Warn") );
  // checkNameSecondaryComboBox->setFont( font );
  *object_size = checkNameSecondaryComboBox->sizeHint();
  checkNameSecondaryComboBox->setGeometry( 140, 40, object_size->width(),object_size->height());

  checkNameResponseLabel = new QLabel( i18n("Response :"), checkNamesGroupBox );
  // checkNameResponseLabel->setFont( font );
  *object_size = checkNameResponseLabel->sizeHint();
  checkNameResponseLabel->setGeometry( 10, 65, object_size->width(),object_size->height());
  checkNameResponseComboBox = new QComboBox( FALSE, checkNamesGroupBox );  
  checkNameResponseComboBox->insertItem( i18n("Default") );
  checkNameResponseComboBox->insertItem( i18n("Fail") );
  checkNameResponseComboBox->insertItem( i18n("Ignore") );
  checkNameResponseComboBox->insertItem( i18n("Warn") );
  // checkNameResponseComboBox->setFont( font );
  *object_size = checkNameResponseComboBox->sizeHint();
  checkNameResponseComboBox->setGeometry( 140, 65, object_size->width(),object_size->height());

  /////  Beginning limits section. /////
  limitsGroupBox = new QGroupBox( i18n("Limits"), misc );
  //limitsGroupBox->setFixedWidth( 270 );
  tabMiscGrid->addMultiCellWidget( limitsGroupBox, 1, 2, 1, 1 );

  limitDataSizeLabel = new QLabel( i18n("Datasize :"), limitsGroupBox );
  *object_size = limitDataSizeLabel->sizeHint();
  limitDataSizeLabel->setGeometry( 10, 20, object_size->width(),object_size->height());
  limitDataSizeEdit = new QLineEdit( limitsGroupBox );
  limitDataSizeEdit->setGeometry( 130, 15, 75, 20);
    
  limitMaxFileHandlesLabel = new QLabel( i18n("Open files :"), limitsGroupBox ); 
  *object_size = limitMaxFileHandlesLabel->sizeHint();
  limitMaxFileHandlesLabel->setGeometry( 10, 45, object_size->width(),object_size->height());
  limitMaxFileHandlesEdit = new QLineEdit( limitsGroupBox );
  limitMaxFileHandlesEdit->setGeometry( 130, 40, 75, 20);

  limitTransfersInLabel = new QLabel( i18n("Transfers in :"), limitsGroupBox );
  *object_size = limitTransfersInLabel->sizeHint();
  limitTransfersInLabel->setGeometry( 10, 70, object_size->width(),object_size->height());
  limitTransfersInEdit = new QLineEdit( limitsGroupBox );
  limitTransfersInEdit->setGeometry( 130, 65, 75, 20);

  limitTransfersPerNsLabel = new QLabel( i18n("Tranfers per ns :"), limitsGroupBox );
  *object_size = limitTransfersPerNsLabel->sizeHint();
  limitTransfersPerNsLabel->setGeometry( 10, 95, object_size->width(),object_size->height());
  limitTransfersPerNsEdit = new QLineEdit( limitsGroupBox );
  limitTransfersPerNsEdit->setGeometry( 130, 90, 75, 20);
    
  // init the QList 
  primaryList = new (QList<PrimaryDomain>);
  secondaryList = new (QList<secondaryDomain>);
  primaryList->setAutoDelete(TRUE);
  secondaryList->setAutoDelete(TRUE);
  forwarders=new QStrList();
  xfrnets = new QStrList();
  bogusns = new QStrList();
  
  options=0;
    
  connect(plist,SIGNAL(selected(const char *)),SLOT(primaryClick(const char *)) );
  connect(slist,SIGNAL(selected(const char *)),SLOT(secondaryClick(const char *)) );
  connect(plist,SIGNAL(highlighted(int)),SLOT(plistsel(int)));
  connect(slist,SIGNAL(highlighted(int)),SLOT(slistsel(int)));
  connect(flist,SIGNAL(highlighted(int)),SLOT(flistsel(int)));
  connect(xlist,SIGNAL(highlighted(int)),SLOT(xlistsel(int)));
  connect(blist,SIGNAL(highlighted(int)),SLOT(blistsel(int)));
    
  tl = new QLabel(simplestats);
  tl->setMinimumSize(tl->sizeHint());
  tabSSLayout->addWidget(tl);

  simplestatlist = new QListBox(simplestats);
  tabSSLayout->addWidget(simplestatlist, 1);
    
  statlist=new KTabListBox(simplestats,"stats",25,0); 
  tabSSLayout->addWidget(statlist, 1);
  statlist->clearTableFlags(Tbl_hScrollBar);
  statlist->setTableFlags(Tbl_autoHScrollBar);
  statlist->setTableFlags(Tbl_autoVScrollBar);
  statlist->setSeparator(' ');

  setup = new QPushButton(i18n("Setup"),running);
  setup->setMinimumSize(setup->sizeHint());
  tabRLeftLayout->addWidget(setup);
  connect(setup,SIGNAL(clicked()),SLOT(setupclicked()));
  
  startButton = new QPushButton(i18n("Start"),running);
  startButton->setMinimumSize(startButton->sizeHint());
  tabRLeftLayout->addWidget(startButton);
  connect(startButton,SIGNAL(clicked()),SLOT(StartClicked()));

  stopButton = new QPushButton(i18n("Stop"),running);
  stopButton->setMinimumSize(stopButton->sizeHint());
  tabRLeftLayout->addWidget(stopButton);
  connect(stopButton,SIGNAL(clicked()),SLOT(StopClicked()));

  restartButton = new QPushButton(i18n("Restart"),running);
  restartButton->setMinimumSize(restartButton->sizeHint());
  tabRLeftLayout->addWidget(restartButton);
  connect(restartButton,SIGNAL(clicked()),SLOT(RestartClicked()));

  statusButton = new QPushButton(i18n("Reload status"),running);
  statusButton->setMinimumSize(statusButton->sizeHint());
  tabRLeftLayout->addWidget(statusButton);
  connect(statusButton,SIGNAL(clicked()),SLOT(StatusClicked()));

  dumpButton = new QPushButton(i18n("Dumping cached records"),running);
  dumpButton->setMinimumSize(dumpButton->sizeHint());
  tabRLeftLayout->addWidget(dumpButton);
  connect(dumpButton,SIGNAL(clicked()),SLOT(DumpClicked()));

  tabRLeftLayout->addSpacing(20);

  init();
    
  topLayout->activate();
  tabPSLayout->activate();
  tabOLayout->activate();
  tabMiscLayout->activate();
  tabMisc2Layout->activate();
  tabRLayout->activate();
  tabSSLayout->activate();
  tl->setMinimumSize(tl->sizeHint());
  // tb->setMinimumWidth((sl1->width()+slist->width()));
  // tb->setMinimumHeight(300);
  // tb->setFixedSize(misc->sizeHint());
  // setFixedSize(sizeHint());
  setMinimumHeight(400);
  // named_81_style = false; /* FIXME */
}


KBindWidget::~KBindWidget() //Since QList don't inherit QObject, all lists must be
{                           //deleted.
  secondaryDomain *secondaryTmp;
  delete forwarders;
  delete bogusns;
  delete xfrnets;
  delete primaryList; //PrimaryDomain takes care of it's own list deletion.

  for ( secondaryTmp = secondaryList->first();  //Travel through the whole list.
	secondaryTmp != 0;
	secondaryTmp = secondaryList->next() )
    {
      delete secondaryTmp->ip;
      delete secondaryTmp->alsonotify;
    }
  delete secondaryList;
}


bool KBindWidget::isIP(QString ip)
{
  int n=0;
  QRegExp r = QRegExp("*.*.*.*",TRUE,TRUE);
  n=ip.contains(r);
  return n==4;
}

void KBindWidget::applySettings()
{
  
  /******************************
				 Writing /etc/named.boot
  ****************************/
  
  PrimaryDomain *pl;
  secondaryDomain *sl; 
  unsigned int temp = 1;
  QString temp2;
  QTextStream t;
  QFile f;
  QFileInfo checkWritePermFileInfo;
  QDir dbDir;

  switch ( QMessageBox::warning( this, i18n("Kcmbind"),i18n("Do you really want to save this?\nRemember that this is only a ALPHA\nversion, please also remember to take\na backup of your /etc/named.boot\nand /var/named/ directory."), QMessageBox::Yes|QMessageBox::Default, QMessageBox::No ) )
    {
    case QMessageBox::Yes:
      if(bind81config_write) 
	{
	  f.setName("/etc/named.conf");
	  checkWritePermFileInfo.setFile( "/etc/named.conf" );
	  while ( !checkWritePermFileInfo.isWritable() )
	    {
	      switch( QMessageBox::critical( this, "Kcmbind", i18n("You don't have write permission on /etc/named.conf" ), QMessageBox::Retry | QMessageBox::Default, QMessageBox::Abort | QMessageBox::Escape )) 
		{
		case QMessageBox::Retry:
		  break;
		  
		case QMessageBox::Abort: 
		  return; //Do nothing.
		  break;
		}
	    }
	      if ( f.open(IO_WriteOnly) ) {            
		t.setDevice( &f );        
		QString s;
		t << "//Generated by kcmbind\n\noptions {"; 
		if (strcmp( diredit->text(), "" ) != 0 )
		  t << "\n\tdirectory \"" << diredit->text() << "\";";
		
		if (strcmp( xferedit->text(), "" ) != 0 )
		  t << "\n\tnamed-xfer \"" << xferedit->text() << ";";
		if (strcmp( dumpedit->text(), "" ) != 0 )
		  t << "\n\tdump-file \"" << dumpedit->text() << "\";";
		if (strcmp( memstatisticsedit->text(), "" ) != 0 )
		  t << "\n\tmemstatistics-file \"" << memstatisticsedit->text() << "\";";
		if (strcmp( pidedit->text(), "" ) != 0 )
		  t << "\n\tpid-file \"" << pidedit->text() << "\";";
		if (strcmp( statisticsedit->text(), "" ) != 0 )
		  t << "\n\tstatistics-file \"" << statisticsedit->text() << "\";";
		if(nan_check->isChecked() == true)
		  t << "\n\tauth-nxdomain no;";
		if(doe_check->isChecked() == true)
		  t << "\n\tdeallocate-on-exit yes;";
		if(fi_check->isChecked() == true)
		  t << "\n\tfake-iquery yes;";
		if(nofg_check->isChecked() == true)
		  t << "\n\tfetch-glue no;";
		if(hs_check->isChecked() == true)
		  t << "\n\thost-statistics yes;";
		if(mc_check->isChecked() == true)
		  t << "\n\tmultiple-cnames yes;";
		if(non_check->isChecked() == true)
		  t << "\n\tnotify no;";
		if(nor_check->isChecked() == true)
		  t << "\n\trecursion no;";
		if(fo_check->isChecked() == true)
		  t << "\n\tforward only;";
	      
		if(forwarders->count() != 0)
		  t << "\n\tforwarders {\n\t\t" << forwarders->first() << ";";
		while(forwarders->count() > temp) {
		  if(forwarders->next() != 0)
		    t << "\n\t\t" << forwarders->current() << ";";
		  temp++;
		}
		if(forwarders->count() != 0)
		  t << "\n\t};";
		temp = 0;
	      
		if ( strcmp( checkNamePrimaryComboBox->currentText(), "Fail" ) == 0 )
		  t << "\n\tcheck-names\tmaster\tfail;";
		else if ( strcmp( checkNamePrimaryComboBox->currentText(), "Ignore" ) == 0 )
		  t << "\n\tcheck-names\tmaster\tignore;";
		else if ( strcmp( checkNamePrimaryComboBox->currentText(), "Warn" ) == 0 )
		  t << "\n\tcheck-names\tmaster\twarn;";
	      
		if ( strcmp( checkNameSecondaryComboBox->currentText(), "Fail" ) == 0 )
		  t << "\n\tcheck-names\tslave\tfail;";
		else if ( strcmp( checkNameSecondaryComboBox->currentText(), "Ignore" ) == 0 )
		  t << "\n\tcheck-names\tslave\tignore;";
		else if ( strcmp( checkNameSecondaryComboBox->currentText(), "Warn" ) == 0 )
		  t << "\n\tcheck-names\tslave\twarn;";
	      
		if ( strcmp( checkNameResponseComboBox->currentText(), "Fail" ) == 0 )
		  t << "\n\tcheck-names\tresponse\tfail;";
		else if ( strcmp( checkNameResponseComboBox->currentText(), "Ignore" ) == 0 )
		  t << "\n\tcheck-names\tresponse\tignore;";
		else if ( strcmp( checkNameResponseComboBox->currentText(), "Warn" ) == 0 )
		  t << "\n\tcheck-names\tresponse\twarn;";
	      
		if (strcmp( limitMaxTransferTimeInEdit->text(), "" ) != 0 )
		  t << "\n\tmax-transfer-time-in " << limitMaxTransferTimeInEdit->text() << ";";
		if (strcmp( limitTransfersInEdit->text(), "" ) != 0)
		  t << "\n\ttransfers-in " << limitTransfersInEdit->text() << ";";
		if (strcmp( limitTransfersOutEdit->text(), "" ) != 0)
		  t << "\n\ttransfers-out " << limitTransfersOutEdit->text() << ";";
		if (strcmp( limitTransfersPerNsEdit->text(), "" ) != 0)
		  t << "\n\ttransfers-per-ns " << limitTransfersPerNsEdit->text() << ";";
		if (strcmp( limitCoreSizeEdit->text(), "" ) != 0 )
		  t << "\n\tcoresize " << limitCoreSizeEdit->text() << ";";
		if (strcmp( limitDataSizeEdit->text(), "" ) != 0 )
		  t << "\n\tdatasize " << limitDataSizeEdit->text() << ";";
		if (strcmp( limitMaxFileHandlesEdit->text(), "" ) != 0 )
		  t << "\n\tfiles " << limitMaxFileHandlesEdit->text() << ";";	
		if (strcmp( limitStackSizeEdit->text(), "" ) != 0 )
		  t << "\n\tstacksize " << limitStackSizeEdit->text() << ";";
		if (strcmp( intervalCleaningEdit->text(), "" ) != 0 )
		  t << "\n\tcleaning-interval " << intervalCleaningEdit->text() << ";";
		if (strcmp( intervalInterfaceEdit->text(), "" ) != 0 )
		  t << "\n\tinterface-interval " << intervalInterfaceEdit->text() << ";";
		if (strcmp( intervalStatisticsEdit->text(), "" ) != 0 )
		  t << "\n\tstatistics-interval " << intervalStatisticsEdit->text() << ";";
	      
		if(xfrnets->count() != 0) {
		  t << "\n\tallow-transfer {\n\t\t" << xfrnets->first();
		  temp2=xfrnets->first();
		  temp2=temp2.left(temp2.find('.'));
		  if (temp2.toInt() < 128) {
		    t << "/8;";
		  } 
		  if (temp2.toInt() < 192 && temp2.toInt() >= 128) {
		    t << "/16;";
		  } 
		  if (temp2.toInt() > 192)  {
		    t << "/24;";
		  }
		}
	      
		while(xfrnets->count() > temp) {
		  if(xfrnets->next() != 0) {
		    t << "\n\t\t" << xfrnets->current();
		    temp2=xfrnets->current();
		    temp2=temp2.left(temp2.find('.'));
		    if (temp2.toInt() < 128) {
		      t << "/8;";
		    } 
		    if (temp2.toInt() < 192 && temp2.toInt() >= 128) {
		      t << "/16;";
		    } 
		    if (temp2.toInt() > 192)  {
		      t << "/24;";
		    }
		  }
		  temp++;
		}
		if(xfrnets->count() != 0)
		  t << "\n\t};";
		temp = 0;
	      
		t << "\n\t/*\n\t * If there is a firewall between you and nameservers you want\n\t * to talk to, you might need to uncomment ";
		t << "the query-source\n\t * directive below.  Previous versions of BIND always asked\n\t * questions using port 53, but BIND 8.1 uses"; 
		t << "an unprivileged\n\t * port by default.\n\t */\n\t// query-source address * port 53;";
		t << "\n};\n\n";
	      
		if(ql_check->isChecked() == true)
		  t << "logging {\n\tcategory queries {\ndefault_syslog; };\n};\n\n";
	      
		if(bogusns->count() != 0) 
		  t << "server " << bogusns->first() << " {\n\tbogus yes;\n};\n\n";
		while(bogusns->count() > temp) {
		  if(bogusns->next() != 0)
		    t << "server " << bogusns->current() << " {\n\tbogus yes;\n};\n\n";
		  temp++;
		}
		temp = 0;
	      
		if(strcmp( cacheedit->text(), "" ) != 0)
		  t << "zone \".\" {\n\ttype hint;\n\tfile \"" 
		    << cacheedit->text() << "\";\n};\n\n";
	      
		for (pl=primaryList->first();pl!=0;pl=primaryList->next()) {
		  t << "zone \"" << pl->domain << "\" {\n\ttype master;\n"; 
		  t << "\tfile \"" << pl->fileName << "\";\n};\n\n";
		} 
		for (sl=secondaryList->first();sl!=0;sl=secondaryList->next()) {
		  t << "zone \"" << sl->domain << "\" {\n\ttype slave;\n";
		  t << "\tfile \"" << sl->file << "\";\n\tmasters {";
		  if(sl->ip->count() != 0)
		    t << "\n\t\t" << sl->ip->first() << ";";
		  while(sl->ip->count() > temp) {
		    if(sl->ip->next() != 0)
		      t << "\n\t\t" << sl->ip->current() << ";";
		    temp++;
		  }
		  t<< "\n\t};\n};\n\n";
		}
	      }
	}
      else 
	{
	  f.setName("/etc/named.boot");    
	  checkWritePermFileInfo.setFile( "/etc/named.boot" );
	  while ( !checkWritePermFileInfo.isWritable() )
	    {
	      switch( QMessageBox::critical( this, "Kcmbind", i18n("You don't have write permission on /etc/named.boot" ), QMessageBox::Retry | QMessageBox::Default, QMessageBox::Abort | QMessageBox::Escape )) 
		{
		case QMessageBox::Retry:
		  break;
		  
		case QMessageBox::Abort: 
		  return; //Do nothing.
		  break;
		}
	    }
	  if ( f.open(IO_WriteOnly) ) 
	    {            
	      t.setDevice( &f );        
	      QString s;        
	      // int n = 1;        
	      if (strcmp( diredit->text(), "" ) != 0 )
		t << "directory\t" << diredit->text() << "\n";
	      if(strcmp( cacheedit->text(), "" ) != 0)
		t << "cache\t\t.\t\t\t\t" << cacheedit->text() << "\n";
	      for (pl=primaryList->first();pl!=0;pl=primaryList->next()) {
		t << "primary\t\t" << pl->domain; 
		if(pl->domain.length() > 24)
		  t << "\t";
		if(pl->domain.length() < 24 && pl->domain.length() >= 16)
		  t << "\t\t";
		if(pl->domain.length() < 16 && pl->domain.length() >= 8)
		  t << "\t\t\t";
		if(pl->domain.length() < 8)
		  t << "\t\t\t\t";
		t << pl->fileName << "\n";
	      } 
	      for (sl=secondaryList->first();sl!=0;sl=secondaryList->next()) {
		t << "secondary\t" << sl->domain;
		temp = 0;
		if(sl->ip->count() != 0)
		  t << "\t" << sl->ip->first();
		while(sl->ip->count() > temp) {
		  if(sl->ip->next() != 0)
		    t << "\t" << sl->ip->current();
		  temp++;
		}
		t<< "\t" << sl->file << "\n";
	      }
	      if(forwarders->count() != 0)
		t << "forwarders\t" << forwarders->first() << "\n";
	      while(forwarders->count() > temp) {
		if(forwarders->next() != 0)
		  t << "forwarders\t" << forwarders->current() << "\n";
		temp++;
	      }
	      temp = 0;
	      if(xfrnets->count() != 0)
		t << "xfrnets\t\t" << xfrnets->first() << "\n";
	      while(xfrnets->count() > temp) {
		if(xfrnets->next() != 0)
		  t << "xfrnets\t\t" << xfrnets->current() << "\n";
		temp++;
	      }
	      temp = 0;
	      if(bogusns->count() != 0) t << "bogusns\t\t" << bogusns->first() << "\n";
	      while(bogusns->count() > temp) {
		if(bogusns->next() != 0)
		  t << "bogusns\t\t" << bogusns->current() << "\n";
		temp++;
	      }
	  
	      ///// Beginning check-names section. /////
	  
	      if ( strcmp( checkNamePrimaryComboBox->currentText(), "Fail" ) == 0 )
		t << "check-names\tprimary\tfail\n";
	      else if ( strcmp( checkNamePrimaryComboBox->currentText(), "Ignore" ) == 0 ) 
		t << "check-names\tprimary\tignore\n";	  
	      else if ( strcmp( checkNamePrimaryComboBox->currentText(), "Warn" ) == 0 )	  
		t << "check-names\tprimary\twarn\n";	        
	      if ( strcmp( checkNameSecondaryComboBox->currentText(), "Fail" ) == 0 )	  
		t << "check-names\tsecondary\tfail\n";	  
	      else if ( strcmp( checkNameSecondaryComboBox->currentText(), "Ignore" ) == 0 )	  
		t << "check-names\tsecondary\tignore\n";	  
	      else if ( strcmp( checkNameSecondaryComboBox->currentText(), "Warn" ) == 0 )	  
		t << "check-names\tsecondary\twarn\n";	  
	      if ( strcmp( checkNameResponseComboBox->currentText(), "Fail" ) == 0 )	  
		t << "check-names\tresponse\tfail\n";	  
	      else if ( strcmp( checkNameResponseComboBox->currentText(), "Ignore" ) == 0 )	  
		t << "check-names\tresponse\tignore\n";	  
	      else if ( strcmp( checkNameResponseComboBox->currentText(), "Warn" ) == 0 )	  
		t << "check-names\tresponse\twarn\n";	  
	  
	      ///// Beginning limits section. /////
	      if ( strcmp( limitDataSizeEdit->text(), "" ) != 0 )	      
		t << "limit datasize " << limitDataSizeEdit->text() << "\n";	     
	      if ( strcmp( limitMaxFileHandlesEdit->text(), "" ) != 0 )	      
		t << "limit max-files " << limitMaxFileHandlesEdit->text() << "\n";  
	      if ( strcmp( limitTransfersInEdit->text(), "" ) != 0 )
		t << "limit transfers-in " << limitTransfersInEdit->text() << "\n";
	      if ( strcmp( limitTransfersPerNsEdit->text(), "" ) != 0 )	      
		t << "limit transfers-per-ns " << limitTransfersPerNsEdit->text() << "\n";
	  
	      if(ql_check->isChecked() == true)
		t << "options\t\tquery-log\n";
	      if(fi_check->isChecked() == true)
		t << "options\t\tfake-iquery\n";
	      if(fo_check->isChecked() == true)
		t << "options\t\tforward-only\n";
	      if(nor_check->isChecked() == true)
		t << "options\t\tno-recursion\n";
	      if(nofg_check->isChecked() == true)
		t << "options\t\tno-fetch-glue\n";
	    }
	}
    
      /****************
		       Files ;)
      ****************/
      *directory = diredit->text();

      if ( strcmp( "", diredit->text() ) == 0 )
	{
	  QMessageBox::critical( this, "Kcmbind", i18n("You haven't specified any directory!" ) );
	  return;
	}

      dbDir.setPath( diredit->text() );
      if ( !dbDir.exists() )
	{
	  switch( QMessageBox::warning( this, "Kcmbind", i18n("The specified directory doesn't exist, create?" ), QMessageBox::Yes | QMessageBox::Default, QMessageBox::No )) 
	    {
	    case QMessageBox::Yes:
	      while ( !dbDir.mkdir( ( const char * ) directory ) ) //If failure for some reason.
		{
		  switch( QMessageBox::critical( this, "Kcmbind", i18n("Failed to create directory, \ndo you have write permission on the parent directory?" ), QMessageBox::Retry | QMessageBox::Default, QMessageBox::Abort )) 
		    {
		    case QMessageBox::Abort:
		      return; //Looping as long as the user chooses to retry.
		    }
		}
	      break;

	    case QMessageBox::No: 
	      return; //If we shouldn't create we can't perform the rest.
	      break;

	    }  
	}
      else //Check the permissions. If created, the owner will be this process, and
	{                           //therefor have permissions.
	  checkWritePermFileInfo.setFile( diredit->text() );	 
	  while ( !checkWritePermFileInfo.isWritable() )
	    {
	      switch( QMessageBox::critical( this, "Kcmbind", i18n("You don't have write permission on the specified directory!" ), QMessageBox::Retry | QMessageBox::Default, QMessageBox::Abort ) )
		{
		case QMessageBox::Abort:
		  return;
		}
	    }
	}
      for (pl=primaryList->first();pl!=0;pl=primaryList->next())
	{
	  //Remove the old file because a new one will be created, and we don't know if it will have the same name.
	  {
	    remove( ( const char * ) QString( *directory + '/' + pl->fileName ) );
	  }
	  if(auto_reverse_lookup) 
	    {
	      if ( strcmp( ( const char * ) pl->domain.right( strlen( ".in-addr.arpa" ) ) , ".in-addr.arpa" ) != 0 ) //Omit reverse-lookups.
		{
		  pl->save( *directory, &t , auto_reverse_lookup, bind81config_write);
		}
	    }
	  else
	    {
	      pl->save( *directory, &t , auto_reverse_lookup, bind81config_write);
	    }
	}      
      f.close();
	
      //Tell named to refresh settings and database.
      QFile *pidFile = new QFile("/var/run/named.pid");
  
      if( pidFile->open( IO_ReadOnly ) )
	{
	  char tmp[255];
	  int pid;
	  pidFile->readLine( tmp, 255 );
	  pid = atoi(tmp);
	  kill( pid, SIGHUP );
	  pidFile->close();
	}
      break; //The QMessageBox-switch
    }
}

void KBindWidget::setupclicked()
{
  setupDialog *set = new setupDialog(this, "setup");
  set->show();
}



 


 

