/************************************************************
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#include "newSecondary.h"
#include "newSecondary.moc"
#include <qlabel.h>
#include <qlayout.h>

newSecondary::newSecondary (QList<secondaryDomain> *sl, QWidget* parent,
			const char* name) 
                        : QDialog ( parent, name, TRUE, 634880 )
{

  QBoxLayout *topLayout = new QVBoxLayout(this, 5);
  QGridLayout *gridLayout = new QGridLayout(3, 2);
  QBoxLayout *buttonLayout = new QHBoxLayout();

  topLayout->addLayout(gridLayout, 10);
  topLayout->addLayout(buttonLayout, 0);

  gridLayout->setColStretch(0, 10);

  buttonLayout->addStretch(10);

  QFont font( "helvetica", 10, 50, 0 );
  font.setStyleHint( (QFont::StyleHint)0 );
  font.setCharSet( (QFont::CharSet)0 );
  
  Label_1 = new QLabel(i18n("Domain :"), this);
  Label_1->setMinimumSize(Label_1->sizeHint());
  gridLayout->addWidget(Label_1, 0, 0);
  
  Label_2 = new QLabel(i18n("Datafile :"), this);
  Label_2->setMinimumSize(Label_2->sizeHint());
  gridLayout->addWidget(Label_2, 1, 0);
  
  Label_3 = new QLabel(i18n("Servers :"), this);
  Label_3->setMinimumSize(Label_3->sizeHint());
  gridLayout->addWidget(Label_3, 2, 0);

  Domain_Edit = new QLineEdit(this);
  Domain_Edit->setMinimumSize( 140, 20 );
  Domain_Edit->setFont( font );
  gridLayout->addWidget(Domain_Edit, 0, 1);
  
  Data_Edit = new QLineEdit(this);
  Data_Edit->setMinimumSize( 140, 20 );
  Data_Edit->setFont( font );
  gridLayout->addWidget(Data_Edit, 1, 1);
  
  Ip_Edit = new QLineEdit(this);
  Ip_Edit->setMinimumSize( 140, 20 );
  Ip_Edit->setFont( font );
  gridLayout->addWidget(Ip_Edit, 2, 1);
	
  Ok_Button = new QPushButton(i18n("OK"), this);
  Ok_Button->setMinimumSize(Ok_Button->sizeHint());
  connect( Ok_Button, SIGNAL(clicked()), SLOT(OK_Click()) );
  buttonLayout->addWidget(Ok_Button);

  Cancel_Button = new QPushButton(i18n("Cancel"), this);
  Cancel_Button->setMinimumSize(Cancel_Button->sizeHint());
  connect( Cancel_Button, SIGNAL(clicked()), SLOT(Cancel_Click()) );
  buttonLayout->addWidget(Cancel_Button);

  setCaption(i18n("New Secondary Domain"));
  secondaryL = sl;

  setFixedSize(50,50);

  //  gridLayout->addColSpacing(0, 100);
  topLayout->activate();
}


newSecondary::~newSecondary()
{
}

void newSecondary::OK_Click()
{
   if ( (strlen(Domain_Edit->text()) > 0) &&
   	(strlen(Data_Edit->text()) > 0) &&
   	(strlen(Ip_Edit->text()) > 0) ) {
		QString RP;
									       
		secondaryDomain *sd;
		sd = new secondaryDomain();
		sd->domain = Domain_Edit->text();
		sd->file = Data_Edit->text();
		sd->ip = new QStrList;
		sd->ip->append(Ip_Edit->text());
		// sd->data = new (QList<records>);
		//sd->data->setAutoDelete(TRUE);
		secondaryL->append(sd);	
		close();
	} else {
		debug("Not all Fields filled out !!!!");
	}
}

void newSecondary::Cancel_Click()
{
  //	debug("Cancel Clicked !");
	close();
}


