/************************************************************
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#include "patternDialog.h"
#include "patternDialog.moc"
#include <qlabel.h>
#include <qlayout.h>
#include "record.h"
#include <kmsgbox.h>
#include "qstring.h"
#include <qregexp.h>

patternDialog::patternDialog (PrimaryDomain *p, int ls, QWidget* parent, 
			      const char* name) 
                        : QDialog ( parent, name, TRUE, 634880 )
{

  QBoxLayout *topLayout = new QVBoxLayout(this, 5);
  QGridLayout *gridLayout = new QGridLayout(3, 6);
  QBoxLayout *buttonLayout = new QHBoxLayout();

  topLayout->addLayout(gridLayout, 10);
  topLayout->addLayout(buttonLayout, 0);

  // gridLayout->setColStretch(0, 10);

  buttonLayout->addStretch(10);

  QFont font( "helvetica", 10, 50, 0 );
  font.setStyleHint( (QFont::StyleHint)0 );
  font.setCharSet( (QFont::CharSet)0 );

  Label = new QLabel(i18n("Use # as wildcard."), this);
  Label->setMinimumSize(Label->sizeHint());
  gridLayout->addMultiCellWidget(Label, 0, 0, 0, 5);
  
  Label = new QLabel(i18n("Owner :"), this);
  Label->setMinimumSize(Label->sizeHint());
  gridLayout->addWidget(Label, 1, 0);

  Label = new QLabel(i18n("Address :"), this);
  Label->setMinimumSize(Label->sizeHint());
  gridLayout->addWidget(Label, 2, 0);

  Label = new QLabel(i18n("From :"), this);
  Label->setMinimumSize(Label->sizeHint());
  gridLayout->addWidget(Label, 1, 2);

  Label = new QLabel(i18n("From :"), this);
  Label->setMinimumSize(Label->sizeHint());
  gridLayout->addWidget(Label, 2, 2);

  Label = new QLabel(i18n("To :"), this);
  Label->setMinimumSize(Label->sizeHint());
  gridLayout->addWidget(Label, 1, 4);

  SpinBox_From_1 = new KIntegerLine(this);
  SpinBox_From_1->setMinimumSize(50,20);
  //SpinBox_From_1->setRange(0,1000);
  SpinBox_From_1->setValue(0);
  gridLayout->addWidget(SpinBox_From_1, 1, 3);

  SpinBox_From_2 = new KIntegerLine(this);
  SpinBox_From_2->setMinimumSize(50,20);
  //SpinBox_From_2->setRange(0,1000);
  SpinBox_From_2->setValue(0);
  gridLayout->addWidget(SpinBox_From_2, 2, 3);

  SpinBox_To_1 = new KIntegerLine(this);
  SpinBox_To_1->setMinimumSize(50,20);
  //SpinBox_To_1->setRange(0,255);
  SpinBox_To_1->setValue(0);
  gridLayout->addWidget(SpinBox_To_1, 1, 5);

  //SpinBox_To_2 = new KNumericSpinBox(this);
  //SpinBox_To_2->setMinimumSize(65,20);
  //SpinBox_To_2->setRange(0,255);
  //gridLayout->addWidget(SpinBox_To_2, 2, 5);

  Text_Edit1 = new QLineEdit(this);
  Text_Edit1->setMinimumSize( 125, 20 );
  Text_Edit1->setFont( font );
  //Text_Edit1->setMaxLength(3);
  gridLayout->addWidget(Text_Edit1, 1, 1);

  Text_Edit2 = new QLineEdit(this);
  Text_Edit2->setMinimumSize( 125, 20 );
  Text_Edit2->setFont( font );
  //Text_Edit2->setMaxLength(3);
  gridLayout->addWidget(Text_Edit2, 2, 1);
	
  Ok_Button = new QPushButton(i18n("OK"), this);
  Ok_Button->setMinimumSize(Ok_Button->sizeHint());
  connect( Ok_Button, SIGNAL(clicked()), SLOT(OK_Click()) );
  buttonLayout->addWidget(Ok_Button);

  Cancel_Button = new QPushButton(i18n("Cancel"), this);
  Cancel_Button->setMinimumSize(Cancel_Button->sizeHint());
  connect( Cancel_Button, SIGNAL(clicked()), SLOT(Cancel_Click()) );
  buttonLayout->addWidget(Cancel_Button);

  pd = p;
  setCaption(i18n("Insert Pattern"));

  setFixedSize(50,50);
  topLayout->activate();
}


patternDialog::~patternDialog()
{
}

void patternDialog::OK_Click()
{
  if(SpinBox_From_1->value() < SpinBox_To_1->value())
    {
      record *rl;
      int tmp1, tmp2, tmp3;
      QString tmp_str1, tmp_str2;
      tmp1 = SpinBox_From_1->value();
      tmp2 = SpinBox_To_1->value();
      tmp3 = SpinBox_From_2->value();
      while(tmp1 <= tmp2)
	{
	  rl = new record;
	  tmp_str1 = Text_Edit1->text();
	  tmp_str2 = Text_Edit2->text();
	  tmp_str1.replace( QRegExp("#"),  QString().setNum(tmp1));
	  rl->owner = (const char*)tmp_str1;
	  rl->type = 1;
	  rl->i = 0;
	  tmp_str2.replace( QRegExp("#"),  QString().setNum(tmp3));
	  rl->st1   = (const char*)tmp_str2;
	  pd->data->append(rl);
	  ++tmp1;
	  ++tmp3;
	}
	
      
      //rl = new record;
      //rl->owner = Text_Edit1->text();
      //rl->type = 1;
      //rl->st1   = Text_Edit2->text();
      //if(num != -1)
      //  pd->data->insert(num, rl);
      //else
      //pd->data->append(rl);
      close();
    }
  else
    KMsgBox::message(this,i18n("Warning!"), i18n("Sorry, the value in the From box is higher than it is in the To box!"), KMsgBox::STOP, i18n("OK"));
}

void patternDialog::Cancel_Click()
{
  close();
}
