/************************************************************
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#include "setupDialog.h"
#include "setupDialog.moc"
#include <qlabel.h>
#include <qlayout.h>
#include "bind.h"

setupDialog::setupDialog (QWidget* parent, const char* name) 
                        : QDialog ( parent, name, TRUE, 634880 )
{

  QBoxLayout *topLayout = new QVBoxLayout(this, 5);
  QBoxLayout *buttonLayout = new QHBoxLayout();

  QSize *object_size = new QSize();
  
  setup_box = new QGroupBox(i18n("Setup"),this);
  topLayout->addWidget(setup_box, 10);
  setup_box->setFixedSize( 210, 110);
  
  bind_81 = new QLabel(i18n("Use Bind 8.1+ style:"),setup_box);
  *object_size = bind_81->sizeHint();
  bind_81->setGeometry(10,15,object_size->width(),object_size->height());
  
  bind81config_check_write = new QCheckBox(i18n("Writing"),setup_box);
  *object_size = bind81config_check_write->sizeHint();
  bind81config_check_write->setGeometry(10,30,object_size->width(),object_size->height());
  
  bind81config_check_read = new QCheckBox(i18n("Reading"),setup_box);
  *object_size = bind81config_check_read->sizeHint();
  bind81config_check_read->setGeometry(10,45,object_size->width(),object_size->height());
  //  bind81config_check_read->setEnabled(false);
  
  reverse_check = new QCheckBox(i18n("Auto Reverse Lookup"),setup_box);
  *object_size = reverse_check->sizeHint();
  reverse_check->setGeometry(10,65,object_size->width(),object_size->height());

  status_check = new QCheckBox(i18n("Parse status"),setup_box);
  *object_size = status_check->sizeHint();
  status_check->setGeometry(10,80,object_size->width(),object_size->height());


  topLayout->addLayout(buttonLayout, 0);
  buttonLayout->addStretch(10);

  QFont font( "helvetica", 10, 50, 0 );
  font.setStyleHint( (QFont::StyleHint)0 );
  font.setCharSet( (QFont::CharSet)0 );


	
  Save_Button = new QPushButton(i18n("Save"), this);
  Save_Button->setMinimumSize(Save_Button->sizeHint());
  connect( Save_Button, SIGNAL(clicked()), SLOT(Save_Click()) );
  buttonLayout->addWidget(Save_Button);

  Exit_Button = new QPushButton(i18n("Exit"), this);
  Exit_Button->setMinimumSize(Exit_Button->sizeHint());
  connect( Exit_Button, SIGNAL(clicked()), SLOT(Exit_Click()) );
  buttonLayout->addWidget(Exit_Button);

  setCaption(i18n("Setup"));

  init();

  setFixedSize(50,50);
  topLayout->activate();
}


setupDialog::~setupDialog()
{
}

void setupDialog::Save_Click()
{
  kc->setGroup("General");

  if(bind81config_check_write->isChecked()) kc->writeEntry("Bind81Write", 1); 
  else kc->writeEntry("Bind81Write", 0);
  
  if(bind81config_check_read->isChecked()) kc->writeEntry("Bind81Read", 1);
  else kc->writeEntry("Bind81Read", 0);

  if(status_check->isChecked()) kc->writeEntry("Status", 1);
  else kc->writeEntry("Status", 0);

  if(reverse_check->isChecked()) kc->writeEntry("AutoReverseLookup", 1);
  else kc->writeEntry("AutoReverseLookup", 0);

  kc->sync();
}

void setupDialog::Exit_Click()
{
  close();
}

void setupDialog::init()
{
  kc = kapp->getConfig();
  kc->setGroup("General");

  if(kc->readEntry("Bind81Write", 0) != "0" && kc->readEntry("Bind81Write", 0) != 0) 
    {
      bind81config_check_write->setChecked(TRUE);
    }

  if(kc->readEntry("Bind81Read", 0) != "0" && kc->readEntry("Bind81Read", 0) != 0) 
    {
      bind81config_check_read->setChecked(TRUE);
    }

  if(kc->readEntry("Status", 0) != "0" &&
     kc->readEntry("Status", 0) != 0) 
    {
      status_check->setChecked(TRUE);
    }
  if(kc->readEntry("AutoReverseLookup", 0) != "0" &&
     kc->readEntry("AutoReverseLookup", 0) != 0) 
    {
      reverse_check->setChecked(TRUE);
    }

}
