/************************************************************
        Copyright (c) 1998-1999 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/


#ifndef _DHCP_
#define _DHCP_

#include <signal.h>
#include <unistd.h>
#include <time.h>

#include "kcontrol.h"

#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>
#include <qtabdlg.h>
#include <qpushbt.h>
#include <qtimer.h>
#include <qlist.h>
#include <qlistbox.h>
#include <qlined.h>
#include <qstrlist.h>
#include <qchkbox.h>
#include <qgroupbox.h>
#include <ktabctl.h>
#include <qregexp.h>
#include <qlayout.h>
#include <qfile.h>
#include <qtstream.h>
#include <qtextstream.h>
#include <qfont.h>

#include <kapp.h>
#include <ktopwidget.h>
#include <ktablistbox.h>
#include <kconfig.h>
#include <kpanner.h>
#include <kmsgbox.h>

class scopeAddresses {
public:
   scopeAddresses(QString s, QString n) 
     {
       subnet=s;subnetMask=n;
       include = new QStrList();
       routers = "";
       leaseDurations = -1;
       maxLeaseDurations = -1;
       netbiosNodeType = -1;
       netbiosDDServer = "";
       nisDomain = "";
       nisServers = "";
       displayManager = "";
       broadcastAddress = "";
       fontServers = "";
       ntpServers = "";
       swapServer = "";
       impressServers = "";
       resourceLocationServers = "";
       lprServers = "";
       cookieServers = "";
       logServers = "";
       ien116nameServers = "";
       timeServers = "";
     }
   QStrList *include;
   QString subnet;
   QString subnetMask;
   QString routers;
   QString domainName;
   QString nameServers;
   QString netbiosNameServers;
   QString netbiosDDServer;
   QString nisDomain;
   QString nisServers;

   QString displayManager;
   QString fontServers;
   QString ntpServers;
   QString swapServer;
   QString impressServers;
   QString resourceLocationServers;
   QString lprServers;
   QString cookieServers;
   QString logServers;
   QString ien116nameServers;
   QString timeServers;

   QString broadcastAddress;
   int netbiosNodeType;
   int leaseDurations;
   int maxLeaseDurations;
   int timeOffset;
   bool ipForward;
};

class leasesAddress {
public:
  leasesAddress(QString s) {ip=s;}
  QString ip;
  QString startsDate;
  QString startsTime;
  QString endsDate;
  QString endsTime;
  QString hardwareType;
  QString hardwareAddress;
  QString uid;
  QString hostName;
};
    
class hostAddress {
public:
  hostAddress(QString n) {name=n;}
  QString name;
  QString hardwareType;
  QString hardwareAddress;
  QString fixedAddress;
  QString hostName;
};

class DhcpWidget : public KConfigWidget
{
  Q_OBJECT;

public:

  DhcpWidget(QWidget *parent, const char *name);
  void readConfig() {};
  void loadSettings() {};
  void applySettings();

private:
  
  QListBox *scopes, *options;
  QList<scopeAddresses> *scopeList;
  QPushButton *addButton, *delButton, *propButton, *leasesButton;

  void  init();
  void  parseconf();
  void  parselog();
  void  readStat();
  void  displaySettings();
  bool  isIP(QString ip);
  bool yes_no(const char *);
public slots:

private slots:
  void createScope();
  void deleteScope();
  void propScope();
  void leasesScope();
};

#endif
