#ifndef _MDI_H
#define _MDI_H

// This code is based from mdi.h , mdi.cpp by Aaron Granick
// Modificated and changed for keirc

#include <qlayout.h>
#include <qwidget.h>
#include <qevent.h>
#include <qframe.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qmenubar.h>
#include <qlist.h>
#include <qpixmap.h>

#include <ktopwidget.h> 

class MDIManager;
class MDIWindow;

class Label : public QLabel
{
  Q_OBJECT
  friend class MDIWindow;
  friend class MDIManager;
public:
  Label(QWidget* parent=0, const char* name=0);
  virtual ~Label(){};
signals:
  void moving ();
  void popupMenu(QPoint);
protected:
  void mousePressEvent ( QMouseEvent *);
};

class TitleBar : public QWidget
{
  Q_OBJECT
  friend class MDIWindow;
  friend class MDIManager;
public:
  TitleBar(const char* icon=0L, QWidget* p=0L, const char* n=0L);
  virtual ~TitleBar(){};
  void setEnabled(bool);
protected:
  QButton* detachBtn;
  QButton* minBtn;
  QButton* maxBtn;
  QButton* closeBtn;
  Label*   caption;
  QPixmap  detachPic;
  QPixmap  attachPic;
};

// MDIWindow is a basic window that can appear in an MDIManager
class MDIWindow : public QWidget
{
    Q_OBJECT
    friend class MDIManager;
protected:
    QFrame*   frame;
    TitleBar* titleBar;
    QWidget*  view;
    QPoint anchorPoint;
    QRect  anchorRect;
    QPoint popupPoint;
    int restoreX;
    int restoreY;
    int restoreWidth;
    int restoreHeight;

    bool eraseResizeRect;
    bool moveMode;
    int  resizeMode;
    int  corner;
    bool isMinimized;
    bool isMaximized;
    bool isSelected;
    bool isAttached;
    QWidget* oldParent;
    WFlags   oldWFlags;
    int      flag;
public:
    MDIWindow ( QWidget *parent=0, const char *name=0, 
		int flag=0, const char* icon=0L);
    virtual ~MDIWindow(){}
    inline bool IsMinimized () { 
      return isMinimized; 
    }
    inline bool IsMaximized () { 
      return isMaximized; 
    }
    inline bool IsSelected () { 
      return isSelected; 
    }
    void drawRect ( QRect &rt, bool fancy=false );
    int getFlag(){
       return flag;
    }
public slots:
    void slotMinimize(bool emitted);
    void slotMaximize(bool emitted);
    void slotMinimize(){
       slotMinimize(true);
    }
    void slotMaximize(){
       slotMaximize(true);
    }
    void slotRestore ();
    void slotClose   ();
    void slotSelect(bool restoreIfMinimized = true, bool emitted=true);
    void slotDetach();
    void slotAttach(); 
    void slotMoving();
    void setView    (QWidget *);
    void setCaption (const char * );
    void changeColorSelect(bool);
 signals: 
    void minimized (MDIWindow *);
    void maximized (MDIWindow *);
    void restored  (MDIWindow *);
    void closed    (MDIWindow *);
    void selected  (MDIWindow *); 
    void moved     (int x, int y);
    void moved     (MDIWindow *, int x, int y);
    void captionChanged(MDIWindow *, const char *);
protected:
    virtual void focusInEvent(QFocusEvent*);
    virtual void focusOutEvent(QFocusEvent*);
    virtual bool eventFilter ( QObject *, QEvent *);
    virtual void resizeEvent ( QResizeEvent *);
    virtual void mousePressEvent ( QMouseEvent *);
    virtual void mouseMoveEvent ( QMouseEvent *);
    virtual void mouseReleaseEvent ( QMouseEvent *);
    void linkChildren(QWidget *);
    void drawResizeAnimation(QRect &, QRect &);
    void doResizing();
    void doMove(QMouseEvent*);
    int isInResizeArea ( int x, int y);
    QPoint getCursorPos();
};


// MDIManager manages a collection of MDIWindows, and provides for minimizing, maximizing,
// closing, resizing and moving these windows
class MDIManager : public QFrame
{
    Q_OBJECT
    friend class TitleBar;
    friend class MDIWindow;
protected:
    MDIWindow* selectedWnd;
    int numWindows;
    int defaultWindowWidth;
    int defaultWindowHeight;
    int defaultWindowPosX;
    int defaultWindowPosY;
    bool smartPlacement;
    QList <MDIWindow>* windowList;
    static QString attachPic;
    static QString detachPic;
    static QString minimizePic;
    static QString maximizePic;
    static QString closePic;
    QPixmap bgPixmap;
public:
    MDIManager (QWidget* p=0L, const char *name = 0, 
		const char *detachButton=0, 
                const char *attachButton=0, 
		const char *minimizeButton=0,
                const char *maximizeButton=0, 
		const char *closeButton=0 );
    virtual ~MDIManager();
    inline MDIWindow *SelectedWindow() { 
      return selectedWnd; 
    }
    inline QList<MDIWindow> *WindowList() { 
      return windowList; 
    }
signals:
    void windowRemoved(MDIWindow *);
    void windowAdded  (MDIWindow *);
public slots:
    MDIWindow *getWindowByName (const char *name, bool caseSensitive = false);
    MDIWindow *getWindowByIndex(int index );
    inline int numberOfWindows () { 
      return numWindows; 
    }
    MDIWindow* addWindow (QWidget *,   int flag , const char* icon=0L); 
    void addWindow       (MDIWindow *, int flag=0);
    void removeWindow    (MDIWindow * );
    void removeWindow    (const char* name);
    void tile (); // tiles the windows
    void cascade (); // cascades the windows from the upper left corner
    void setDefaultWindowSize( int w, int h);
    void setDefaultWindowPos ( int x, int y);
    void setSmartPlacement(bool);
    void nextWindow(); // switches focus to the next window
    void prevWindow(); // switches focus to the previous window
    void slotSetBgImage(const char*);
    void slotSetColor  (const QColor&, int);
protected:
    bool isPointTaken    (int x, int y); // true if point is not already occupied
    virtual void resizeEvent ( QResizeEvent *);
protected slots:
     void handleWindowSelect ( MDIWindow *);
};



#endif

