#include <iostream.h>
#include <ctype.h>
#include "StringToken.h"

void StringToken::Init()
{
  currentPos = 0;
  maxPos     = 0;
}

StringToken::StringToken(QString str, const char* delim)
{
  Init();
  this->str = str;
  delimit  = delim;
  maxPos   = str.length();
}

StringToken::StringToken(const char* str, const char* delim)
{
  Init();
  this->str = str;
  delimit  = delim;
  maxPos   = strlen(str);
}


StringToken::~StringToken()
{
}

void StringToken::skipDelimit()
{
  while ((currentPos < maxPos) &&
	 (delimit.find(str[currentPos])>=0))
    currentPos++;
}

bool StringToken::hasMoreTokens(const char* delim)
{
  if (delim)
     delimit = delim;
  skipDelimit();
  return (currentPos<maxPos);
}

QString StringToken::nextToken(const char* delim)
{
  if (delim)
     delimit = delim;
  skipDelimit();
  if (currentPos >= maxPos)
     return NULL;
  int start = currentPos;
  while ((currentPos < maxPos) &&
	 (delimit.find(str[currentPos]) < 0))
    currentPos++;
  if (currentPos>maxPos){
     currentPos=start;
     return NULL;
  }
  else
     return str.mid(start, currentPos-start);
}

QString StringToken::nextToken(const char* delim, int* len)
{
  *len = 0;
  if (delim)
     delimit = delim;

  while ((currentPos < maxPos) && (delimit.find(str[currentPos])>=0)){
    currentPos++;
    (*len)++;
  }

  if (currentPos >= maxPos)
     return NULL;
  int start = currentPos;
  while ((currentPos < maxPos) && (delimit.find(str[currentPos]) < 0)){
    currentPos++;
    (*len)++;
  }
  if (currentPos>maxPos){
     currentPos=start;
     return NULL;
  }
  else
     return str.mid(start, currentPos-start);
}

QString StringToken::nextDigit(const char* delim, int* len)
{
  *len = 0;
  if (delim)
     delimit = delim;

  while ((currentPos < maxPos) && (delimit.find(str[currentPos])>=0)){
    currentPos++;
    (*len)++;
  }

  if (currentPos >= maxPos)
     return NULL;
  int start = currentPos;
  while ((currentPos < maxPos) && isdigit(str[currentPos]) ){
    currentPos++;
    (*len)++;
  }
  if (currentPos>maxPos){
     currentPos=start;
     return NULL;
  }

  QString rs = str.mid(start, currentPos-start);

  if (!rs)
     return NULL;
  bool ok;
  rs.toULong(&ok);
  if (ok==TRUE)
     return rs;
  else
     return NULL;
}

QString StringToken::nextInt(const char* delim, int* len)
{
  QString str = nextToken(delim, len);
  if (!str)
     return NULL;
  bool ok;
  str.toInt(&ok);
  if (ok==TRUE)
     return str;
  else
     return NULL;
}

QString StringToken::toEnd(const char* delim)
{
  if (delim)
     delimit = delim;
  skipDelimit();
  if (currentPos >= maxPos)
     return NULL;
  return str.mid(currentPos, maxPos-currentPos);
}

QString StringToken::toToken(const char* token)
{
  QString delim=token;
  if (currentPos<maxPos)
     currentPos++;
  else
     return NULL;
  int start=currentPos;
  while ((currentPos < maxPos) &&
	 (delim.find(str[currentPos]) < 0))
    currentPos++;
  return str.mid(start, currentPos-start);
}

int StringToken::countTokens(const char* delim)
{
  if (delim)
     delimit=delim;
  int count = 0;
  int CurrentPos = currentPos; 
  while (CurrentPos < maxPos){
    while ((CurrentPos < maxPos) &&
	   (delimit.find(str[CurrentPos])>=0))
       CurrentPos++;
    if (CurrentPos > maxPos)
       return count;
    while ((CurrentPos < maxPos) &&
	   (delimit.find(str[CurrentPos]) < 0))
       CurrentPos++;
    if (CurrentPos > maxPos)
       return count;
    count++;
  }
  return count;
}







