#include <iostream.h>
#include "StringToken.h"
#include "lineDialog.h"
#include "clientCore.h"
#include "clientCore.moc"

ClientCore::ClientCore(QObject* Parent, const char* Name, ulong CusInterval, bool Start):
  IrcCore(Parent, Name, CusInterval, Start)
{
}

ClientCore::~ClientCore()
{
}

void ClientCore::slotCurrentNick(const char* nick)
{
  mNick = nick;
}

QString ClientCore::cmdSubstitution(QDict<char>& list, const char* Txt)
{
#ifdef EDEBUG
  cout << "ClientCore::cmdSub:"<<Txt<<endl;
#endif
  int     idx;
  QString s=Txt;
  if (s.isEmpty())
     return "";

  idx = -1;
  while((idx=s.find('$', idx+1, FALSE))>=0){
    if (idx!=0 && s[idx-1]=='\\')
       continue;
    QString key;
    QDictIterator<char> it(list);
    for (it.current();it.current();++it){
      key=it.currentKey();
      if (!strnicmp(QString(s.mid(idx, s.length()-idx)), key, key.length())){
	 s.replace(idx, key.length(), it.current());
	 continue;  
      }
    }
    if (s[idx+1]=='?'){
       StringToken tt(s.mid(idx, s.length()-idx));
       QString txt=tt.nextToken("$?:");
       SingleDialog sd("Text:", "", txt);
       if (sd.exec() ) {
	  QString e = sd.getText(TRUE);
	  if (!e.isEmpty()){
	     s.replace(idx, txt.length()+3,e);
	  }
	  else
	     s.replace(idx, txt.length()+3,"");
       }
       else
          continue;
    }
  }
  return s;
}

void ClientCore::slotWriteMsg(int Type, const char* Msg, bool Parsen)
{
  emit signWriteMsg(Type, Msg, Parsen);
}







