#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qtooltip.h> 
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "StringToken.h"
#include "ircDefine.h"
#include "ircClient.h"
#include "dccFileDialog.h"
#include "dccFileDialog.moc"
#include "ircApp.h"

void DCCFileDialog::Init()
{
  userList.setAutoDelete(true);
}

DCCFileDialog::DCCFileDialog(IrcClient* client, bool Modal, QWidget *parent, const char *name ) : 
  QDialog( parent, name, Modal )
{
#ifdef EDEBUG
  cout << "DCCFileDialog Konstruktor" << endl;
#endif
  Init();
  this->client=client;
  horLayout = new QHBoxLayout(this, 5);
  createFileBox();
  horLayout->addWidget(fileBox, 10);
  createButton();
  createListBox();
  horLayout->activate();
  readConfig();
  setFixedSize(600,300);
  setCaption("DCC Send Dialog");
}

DCCFileDialog::~DCCFileDialog()
{
#ifdef EDEBUG
  cout << "Destruktor DCCFileDialog" << endl;
#endif
}

void DCCFileDialog::createFileBox()
{
  QString entry = "DCCFileDir";
  QString value = ircapp->readEntry(entry, ircapp->home);
  fileBox = new FileBox(this, "fileBox", "*.*", value);
}

void DCCFileDialog::createButton()
{
  horLayout->addSpacing(5);

  QVBoxLayout* vbox;
  vbox = new QVBoxLayout(0);
  horLayout->addLayout(vbox);

  vbox->addStretch(10);
  QPushButton* btn;
  btn = new QPushButton(" >> ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotAddFile()));
  vbox->addWidget(btn);
  btn->setFixedSize(75, 25);

  btn = new QPushButton(" Delete ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotDelFile()));
  vbox->addWidget(btn);
  btn->setFixedSize(75, 25);

  btn = new QPushButton(" Clear ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotClear()));
  vbox->addWidget(btn);
  btn->setFixedSize(75, 25);

  vbox->addSpacing(10);

  btn = new QPushButton(" Send ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotSend()));
  vbox->addWidget(btn);
  btn->setFixedSize(75, 25);

  vbox->addSpacing(10);

  btn = new QPushButton(" OK ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotOk()));
  vbox->addWidget(btn);
  btn->setFixedSize(75, 25);
  
  btn = new QPushButton(" Cancel ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotCancel()));
  vbox->addWidget(btn);
  btn->setFixedSize(75, 25);

  vbox->addStretch(10);
}

void DCCFileDialog::createListBox()
{
  horLayout->addSpacing(5);

  QString entry;

  QHBoxLayout* hbox;
  QVBoxLayout* vbox;
  QLabel* label;

  vbox = new QVBoxLayout(0);
  horLayout->addLayout(vbox, 10);
  hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);
  label = new QLabel("To: ", this);
  hbox->addWidget(label);
  label->setFixedSize(label->sizeHint());

  comboBox = new QComboBox(TRUE, this);
  comboBox->setInsertionPolicy (QComboBox::AtCurrent);
  hbox->addWidget(comboBox, 10);
  comboBox->setFixedHeight(comboBox->sizeHint().height());

  vbox->addSpacing(35);

  frame=new QFrame(this);
  frame->setLineWidth(2);
  frame->setFrameStyle(QFrame::Panel|QFrame::Sunken);
  vbox->addWidget(frame, 10);

  listBox = new KTabListBox(frame, "ListBox", 2);
  listBox->setColumn(0, "Filename");
  listBox->setColumn(1, "Size");
  listBox->setColumnWidth(0, 150);
  listBox->setColumnWidth(1, 100);
  listBox->setSeparator(' ');
}

void DCCFileDialog::readConfig()
{
  QString dir=ircapp->readEntry("DCCFileDir", ircapp->home);
  fileBox->setDir(dir);

  KConfig* config=ircapp->getConfig();
  config->setGroup(ircapp->entryGroup);
  userList.clear();
  QStrList list;
  config->readListEntry("DCCFileUser", list);
  QString s;
  for (s=list.first();s;s=list.next()){
      s=s.stripWhiteSpace();
      if (userList.find(s)<0)
	 userList.inSort(s);
  }
  if (userList.count()>0){
     comboBox->insertStrList(&userList);
  }
  comboBox->insertItem("", 0);
}

void DCCFileDialog::slotAddFile()
{
  QString file=fileBox->selectedFile();
  if (file.isEmpty())
     return;
  QFileInfo fi(file);
  
  QString size;
  size.setNum(fi.size());
  listBox->appendItem(file+' '+size);
  listBox->setCurrentItem(listBox->count()-1);
}

void DCCFileDialog::slotDelFile()
{
#ifdef EDEBUG
  cout << "DCCFileDialog::slotDelFile:"<<endl;
#endif
  int idx=listBox->currentItem();
  if (idx<0)
     return;
  listBox->removeItem(idx);
  
  listBox->repaint();
}

void DCCFileDialog::slotClear()
{
  listBox->clear();
  listBox->repaint();
}

void DCCFileDialog::slotSend()
{
  StringToken t=comboBox->currentText();
  while(t.hasMoreTokens()){
    QString to=t.nextToken();
    for (uint i=0;i<listBox->count();i++){
       StringToken t(listBox->text(i));
       QString file=t.nextToken();
       client->slotCommand(to, "/DCC SEND "+to+" "+file);
    }
  }
}

void DCCFileDialog::slotOk()
{
  slotSend();

  for (int i=0;i<comboBox->count();i++){
     QString s=comboBox->text(i);
     s = s.stripWhiteSpace();
     if (userList.find(s)<0)
        userList.inSort(s);
  }

  KConfig* config=ircapp->config;
  config->writeEntry("DCCFileUser", userList);
  comboBox->changeItem("", 0);
  hide();
}

void DCCFileDialog::slotCancel()
{
  hide();
}

void DCCFileDialog::show(const char* to)
{
  if (to){
    int idx=comboBox->currentItem();
    QString cur=comboBox->currentText();
    if (cur.find(to, 0, false)<0)
       cur +=  " "+QString(to);
    if (userList.find(to)<0){
        userList.inSort(to);
	comboBox->insertItem(to);
    }
    comboBox->changeItem(cur, idx);
  }

  QPoint p=pos();
  move(p);
  if (isVisible())
     raise();
  else
     QDialog::show();
}

void DCCFileDialog::resizeEvent(QResizeEvent*)
{
  listBox->setGeometry(3,
		       3,
		       frame->width()-6,
		       frame->height()-6);
}
