#include "ircDefine.h"
#include "ircBan.h"
#include "StringToken.h"
#include "ircClient.h"

extern toUsermask(const char* ident);

IrcBan::IrcBan(const char* Banned, const char* By, ulong Interval):
  IrcCore(0, Banned, Interval)
{
  if (!Banned)
     return;

  mBanned = Banned;
  if (!By)
     mBy = "";
  else
     mBy = By;
}

IrcBan::IrcBan(const char* BanStr, ulong Interval):
  IrcCore(0, 0, Interval)
{
  StringToken st(BanStr);
  if (!(mBanned=st.nextToken()))
     return;
  setName(mBanned);
  if (!(mBy=st.nextToken()))
     mBy="";
}

QString IrcBan::ban()
{
  return mBanned;
}


BanUser::BanUser(const char* ident, int level, const char* channel, ulong second) :
  FriendUser(ident, level, channel)
{
  mSecond = second;
  if (second>0)
     mTemporary=true;
  else
     mTemporary=false;
}

BanUser::~BanUser()
{
}

BanList::BanList(IrcClient* client):
  FriendList(client)
{
}

BanList::~BanList()
{
}

BanUser* BanList::getUser(const char* ident, bool wildcard)
{
  return (BanUser*)FriendList::getUser(ident, wildcard);
}

BanUser* BanList::addUser(const char* ident, int level, const char* channel, ulong second)
{
   BanUser* bu = getUser(ident);
   if (bu==0L){
      bu = new BanUser(ident, level, channel, second);
      mList.append((FriendUser*)bu);
      mUpdate = true;
      QString s(1024);
      s.sprintf("Add Ban : %s level %d on channel %s for %u seconds", 
		           ident, level, channel, second);
      client->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
      return bu;
   }
   return 0L;
}

void BanList::delUser(const char* ident, bool wildcard)
{
  FriendList::delUserIn("Ban", ident, wildcard);
}

void BanList::checkUser()
{
  BanUser* bu;
  for (bu=first();bu!=0L;){
     if (bu->getSecond()>1){
        bu->mSecond--;
	mUpdate = true;
	bu=next();
     }
     else if (bu->getSecond()==1){
        delUser(bu->getIdent());
	mUpdate = true;
	bu=current();
     }
     else
        bu=next();
  } 
}


IgnoreUser::IgnoreUser(const char* ident, const char* flag, ulong second) :
  BanUser(ident, 0, "*", second)
{
   setIgnFlag(flag);
}

IgnoreUser::~IgnoreUser()
{
}

void IgnoreUser::setIgnFlag(const char* flag)
{
  if (flag==0L)
     return;
  // private, channel, notice,dcc file, dcc chat, invite, sound
  QString valid="pcnftis";
  for (uint i=0;i<strlen(flag);i++){
    if (valid.contains(flag[i], FALSE)>0){
       if (mIgnFlag.contains(flag[i], FALSE)<1)
	  mIgnFlag += flag[i];
    }
  }
}



IgnoreList::IgnoreList(IrcClient* client):
  BanList(client)
{
}

IgnoreList::~IgnoreList()
{
}

IgnoreUser* IgnoreList::getUser(const char* ident, bool wildcard)
{
  return (IgnoreUser*)BanList::getUser(ident, wildcard);
}

IgnoreUser* IgnoreList::addUser(const char* ident, const char* flag, ulong second)
{
   IgnoreUser* iu = getUser(ident);
   if (iu==0L){
      iu = new IgnoreUser(ident, flag, second);
      mList.append((FriendUser*)iu);
      mUpdate = true;
      QString s(1024);
      s.sprintf("Add Ignore : %s %s for %u seconds", ident, flag, second);
      client->slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
      return iu;
   }
   return 0L;
}


// -1: not found
int IgnoreList::matchUser(const char* ident, const char* flag, bool wildcard)
{
  IgnoreUser* iu = getUser(ident, wildcard);
  if (iu!=0L){
     QString f = iu->getIgnFlag();
     for (uint i=0;i<strlen(flag);i++){
       if (f.contains(flag[i], false)>0)
	  return 1;
     }
  }
  return 0;
}



void IgnoreList::delUser(const char* ident, bool wildcard)
{
  FriendList::delUserIn("Ignore", ident, wildcard);
}

void IgnoreList::checkUser()
{
  IgnoreUser* iu;
  for (iu=first();iu!=0L;){
     if (iu->getSecond()>1){
        iu->mSecond--;
	mUpdate = true;
	iu=next();
     }
     else if (iu->getSecond()==1){
        delUser(iu->getIdent());
	mUpdate = true;
	iu=current();
     }
     else
        iu=next();
  }
}





