#include <stdlib.h>
#include <sys/time.h>
#include <qregexp.h>
#include <qmetaobj.h>
#include <iostream.h>
#include <qclipbrd.h>
#include "StringToken.h"
#include "MsgParser.h"
#include "ircClient.h"
#include "ircDefine.h"
#include "ircSleeper.h"
#include "ircApp.h"


void host2list(const char* host, QStrList& list, bool& isIP)
{
  StringToken st(host, ". ");
  QString s;
  isIP=true;
  while(st.hasMoreTokens()){
     bool ok;
     s=st.nextToken();
     list.append(s);
     s.toInt(&ok);
     if (ok==false)
        isIP=false;
  }

  QString hostname=host;

  // tld , domain, host
  if (!isIP){
     hostname.insert(0, '.');
     int idx   = 0;
     int oldIdx= hostname.length();
     list.clear();
     while((idx=hostname.findRev('.', idx-1))>=0){
        QString s=hostname.mid(idx+1, oldIdx-idx-1);
	list.append(s);
	oldIdx=idx;
	if (idx==0)
	   break;
     }
     hostname.remove(0, 1);
  }

  for (int i=list.count();i<3;i++)
      list.append("");

}

void IrcClient::Init()
{
   state    = 0;
   channel  = 0L;
   privMsg  = 0L;
   sn       = 0L;
   cmdChar  = "/";
   startAction.setAutoDelete(true);
   isonList.setAutoDelete   (true);
   onList.setAutoDelete     (true);

   bell.setAutoDelete(false);
   timerList.setAutoDelete(true);
   ctcpReplyList.setAutoDelete(true);

   ircapp->writeEntry("InvDlgCur",        0);
   ircapp->writeEntry("PrivMsgDlgCur",    0);
   ircapp->writeEntry("PrivMsgClientCur", 0);
   ircapp->writeEntry("DCCChatDlgCur", 0);
   ircapp->writeEntry("DCCChatClientCur", 0);
   ircapp->writeEntry("DCCFileClientCur", 0);
   ircapp->writeEntry("DCCFileDlgCur", 0);
}

IrcClient::IrcClient() : ClientCore(0, "@IrcClient@"), ClientConfig()
{
   webServer = new WebServer(this);

   stop();
   Init();
   channel = new QDict<IrcChannel>(20, FALSE, TRUE);
   channel->setAutoDelete(true);
   privMsg = new QDict<IrcPrivMsg>(20, FALSE, TRUE);
   privMsg->setAutoDelete(true);
   dccChat = new QDict<DCCChat>(20, FALSE, TRUE);
   dccChat->setAutoDelete(true);
   dccFile = new QDict<DCCFile>(20, FALSE, TRUE);
   dccFile->setAutoDelete(true);
   msgParser = new MsgParser(this);
   cmdParser = new CmdParser(this);
   alias     = new IrcAlias ("IrcClientAlias", "kEirc.alias");
   popup.insert("Main",         new IrcPopup("MainPopup",     "Main.popup"));
   popup.insert("Channel",      new IrcPopup("ChannelPopup",  "Channel.popup"));
   popup.insert("UserList",     new IrcPopup("UserList",      "UserList.popup"));
   popup.insert("PrivMsg",      new IrcPopup("PrivMsgPopup",  "PrivMsg.popup"));
   popup.insert("Default",      new IrcPopup("DefaultPopup",  "Default.popup"));
   popup.insert("DCCChat",      new IrcPopup("DCCChatPopup",  "DCCChat.popup"));
   popup.insert("DCCFile",      new IrcPopup("DCCFilePopup",  "DCCFile.popup"));
   popup.insert("Input",        new IrcPopup("InputPopup",    "Input.popup"));

   IrcCore* ic;
   timerList.insert("CtcpReply", ic=new IrcCore(this, "CtcpReply", 5));
   connect(ic,
	   SIGNAL(signCusTimeout(IrcCore*)),
	   SLOT  (slotCtcpReply (IrcCore*)));
   timerList.insert("IsOn", ic=new IrcCore(this, "IsOn", 2));
   connect(ic,
	   SIGNAL(signCusTimeout(IrcCore*)),
	   SLOT  (slotIsOn      (IrcCore*)));

   dccFileDlg = new DCCFileDialog(this, false);
   mediaPlayer = new QDict<char>(20, FALSE, TRUE);
   mediaPlayer->setAutoDelete(true);
   mediaDlg   = new MediaDialog  (this, false);

#ifdef TCL
   tclCmd = new TclCmd(this);
#endif

   friendList = new FriendList(this);
   banList    = new BanList(this);
   ignList    = new IgnoreList(this);

   optPrefDlg = new OptPrefDialog(this, 0L);
   clientSetup= new IrcSetup     (this, 0L);
   whoisCache = new QDict<IrcUser>(10, FALSE, TRUE);
   whoisCache->setAutoDelete(TRUE);

   dlgList = new QDict<QWidget>(10, FALSE, TRUE);
   dlgList->setAutoDelete(FALSE);
   dlgList->insert("ClientSetup",    clientSetup);
   dlgList->insert("OptPrefDialog",  optPrefDlg);
   dlgList->insert("MediaDialog",    mediaDlg);
   dlgList->insert("DCCFileDialog",  dccFileDlg);
   dlgList->insert("ChannelDialog",  new ChannelDialog (this));
   dlgList->insert("OpActionDialog", new OpActionDialog(this));
   dlgList->insert("WhoisDialog",    new WhoisDialog   (this));
}

IrcClient::~IrcClient()
{
#ifdef EDEBUG
  cout << "Destruktor IrcClient" << endl;
#endif
  delete channel;
  delete privMsg;
  delete dccChat;
  delete dccFile;
  delete msgParser;
  delete cmdParser;
  delete alias;
  delete sn;
  delete dccFileDlg;
  delete mediaDlg;
  delete mediaPlayer;
  delete friendList;
  delete banList;
  delete ignList;
  delete optPrefDlg;
  delete clientSetup;
#ifdef TCL
  delete tclCmd;
#endif

  delete webServer;
  delete dlgList;
}

QString IrcClient::cmdSubstitution(const char* Txt)
{
  QDict<char> list;
  list.setAutoDelete(true);
  list.insert("$nick", qstrdup(curNick));
  QString s;
  QClipboard *cb = ircapp->clipboard();
  s = cb->text();
  if (s.isEmpty())
     s="";
  list.insert("$selected", qstrdup(s));

  s.setNum((ulong)time(NULL));
  list.insert("$time", qstrdup(s));
  
  return ClientCore::cmdSubstitution(list, Txt);
}

// Type = 0 -> ausgabe
// Type = 1 -> cmd
QString IrcClient::cmdFilter(const char* Txt, int* Type)
{
#ifdef EDEBUG
    cout << "IrcClient::cmdFilter:"<<Txt << endl;
#endif
  QString t = Txt;
  QString n;
  *Type = 1;
  // endlose Schleife
  //while (n=alias->eval(t)){
  if (n=alias->eval(t)){
    if (n[0]==cmdChar[0]){
       *Type=1;
       n.remove(0, 1);
    }
    else
      *Type=0;
    t = n;
  }
  if (n)
     t = n;

  if (t[0]==cmdChar[0])
       t.remove(0, 1);
#ifdef EDEBUG
    cout << "After IrcClient::cmdFilter:"<<t << endl;
#endif
  return t;
}

bool IrcClient::isIgnored(const char* Who, const char* flag)
{
#ifdef EDEBUG
  cout << "IrcClient::isIgnored:"<<Who<<endl;
#endif
  QString entry = "IgnListActivate";
  QString value = ircapp->readEntry(entry, "Yes");
  if (value=="No")
     return false;

  QString s;
  QString w=Who;
  w=w.stripWhiteSpace();
  if (ignList->matchUser(w, flag)<1)
     return false;
  return true;
}

void IrcClient::addNick(const char* n)
{
  StringToken token(n);
  QString s;
  if ((s=token.nextToken()) != NULL)
    if (nick.find(s) < 0){
       nick.inSort(s);
       emit signAddNick(s);
    }

}

void IrcClient::setCurNick(const char* n)
{
  StringToken token(n);
  QString s;
  if ((s=token.nextToken()) != NULL){
    if (nick.find(s) >= 0){
       curNick=s;
       emit signCurNick(curNick);
    }
    else{
       addNick(s);
       setCurNick(s);
    }
  }
}

void IrcClient::addServer(const char* s)
{
  StringToken token(s," :");
  QString se,po,pa,in;
  if (!(se=token.nextToken()))
     return;
  if (!(po=token.toToken(":")))
     po="6667";
  if (!(pa=token.toToken(":")))
     pa="";
  if ((in=token.toEnd()) == NULL)
     in="";
  if (server->find(se+":"+po)!=NULL)
     return;
  IrcServer* is;
  server->insert(se+":"+po, (is = new IrcServer(se, po.toInt(), pa, in)));
  emit signAddServer(is);
}

void IrcClient::delServer(const char* s)
{
  StringToken token(s," :");
  QString se,po,pa,in;
  if (!(se=token.nextToken()))
     return;
  if (!(po=token.nextToken()))
     po="6667";

  if (server->find(se+":"+po)!=NULL){
     server->remove(se+":"+po);
     emit signDelServer(se+":"+po);
  }
}

void IrcClient::setCurServer(const char* s)
{
  StringToken token(s," :");
  QString se,po,pa,in;
  if (!(se=token.nextToken()))
     return;
  if (!(po=token.nextToken()))
     po="6667";
  if ((in=token.toEnd()) == 0L)
     in="";
  IrcServer* is = curServer;
  if ((curServer=server->find(se+":"+po)) != 0L){
     emit signCurServer(curServer);
     return;
  }
  addServer(s);
  setCurServer(s);
  curServer=is;
}

void IrcClient::slotConnect(IrcCore* ic)
{
#ifdef EDEBUG
  cout << "IrcClient::slotConnect:"<<endl;
#endif
  if ((state & SOCKS_CONNECTED)!=0)
     slotDisconnected();

  state = 0;
  QString value=ircapp->readEntry("OnProxy", "PROXY_DONTUSE");
  if (!stricmp(value, "PROXY_DONTUSE"))
     state |= SOCKET_DIRECT;
  else if (!stricmp(value, "PROXY_SOCKS")){
     value = ircapp->readEntry("CurrentSocksProxy", "");
     if (!value.isEmpty()){
        state |= SOCKET_SOCKS;
        socket.setParameter(value);
     }
     else
        ircapp->writeEntry("OnProxy", "PROXY_DONTUSE");
  }

  if (!ic){
     IrcServer* is=curServer;
     is->stop();
     connect(is,    SIGNAL(signCusTimeout(IrcCore*)),
	     this,  SLOT  (slotConnect   (IrcCore*)));
     emit signConnect(is);
     is->setCusInterval(1);
     is->start();
     return;
  }
  if (sn){
     delete sn;
     sn = NULL;
  }
  IrcServer* is=(IrcServer*)ic;
  is->stop();
  disconnect(is,  SIGNAL(signCusTimeout(IrcCore*)),
	     this,SLOT  (slotConnect   (IrcCore*)));

  QString str(4096);
  int status=-1;
  if (state & SOCKET_DIRECT)
     status=socket.Open(is);
  else if (state & SOCKET_SOCKS)
     status=socket.ROpen(is);

  if (status<1)
     slotDisconnect(is);
  else
     slotConnected(is);
}

void IrcClient::slotConnected(IrcServer* is)
{
  if (state & SOCKET_SOCKS){
     state |= SOCKS_CONNECTED;
     QString s, p;
     p.setNum(socket.getPeerPort());
     s += 0x02;
     s += "You are connected to proxy socks "+socket.getInetAddress().getHostAddress()+" on port "+p;
     s += 0x02;
     emit signWriteMsg(TYPE_INFO|TYPE_IMG, s);
  }
  else if (state & SOCKET_DIRECT){
     state |= SOCKET_CONNECTED;
     if (state & SOCKET_CONNECTED){
        socket.sendNick(curNick);
	QString str(4096);
	str.sprintf("%s %s %s :%s", curUser.data(), 
		    socket.getLocalInetAddress().getHostName().data(),
		    is->Host().data(),
		    curIrcname.data());
	socket.sendUser(str);
     }
  }
  emit signConnected(is);
  sn=new QSocketNotifier(socket.getSocket(), QSocketNotifier::Read, this);
  QObject::connect(sn, SIGNAL(activated(int)), this, SLOT(slotMsgParse(int)));
  connect(&socket,
	  SIGNAL(signError()),
	  SLOT  (slotDisconnected()));
  connect(&socket,
	  SIGNAL(signText(const char*)),
	  SLOT  (slotSocketText(const char*)));
  setCurServer(is->toString());
}

void IrcClient::slotDisconnect(IrcServer* is)
{
  QString s;
  if (state & SOCKET_SOCKS){
     QString s, p;
     p.setNum(socket.getPeerPort());
     s += 0x02;
     s += "Connection failed to proxy socks "+socket.getInetAddress().getHostName()+" on port "+p;
     s += 0x02;
     emit signWriteMsg(TYPE_ERROR|TYPE_IMG, s);
  }
  emit signDisconnect(is);
  state = 0;
  if ((s=ircapp->readEntry("AutoReconnect", "No")) && s.find("Yes", 0, false)==0){
     IrcServer* tis;
     int delta=ircapp->readNumEntry("ReconnectionDelay", 1);
     if (delta<1)
        delta=1;
     if (itServer==NULL){
        itServer = new QDictIterator<IrcServer>(*server);
	tis=itServer->toFirst();
     }
     if (!(tis=itServer->current()))
        return;
     if (tis->toString()==curServer->toString()){
        ++(*itServer);
	if (!(tis = itServer->current()))
	   return;
     }
     connect(tis, SIGNAL(signCusTimeout(IrcCore*)),
	     this,SLOT  (slotConnect   (IrcCore*)));
     emit signConnect(tis);
     tis->setCusInterval(delta);
     tis->start();
     ++(*itServer);
  }
}

void IrcClient::slotDisconnected()
{
#ifdef EDEBUG
  cout << "IrcClient::slotDisconnected:"<<endl;
#endif

  disconnect(&socket);
  socket.Close();

  // TimerList stopen
  QDictIterator<IrcCore> itIc(timerList);
  IrcCore* ic;
  for (ic=itIc.current();(ic=itIc.current())!=0L;++itIc)
      ic->stop();

  IrcServer* curIs=curServer;
  QDictIterator<IrcServer> it(*server);
  IrcServer* is;
  for (is=it.current();(is=it.current())!=0L;++it){
     if (is->isActive()){
        emit signDisconnect(is);
	curIs=is;
     }
     is->stop();
     disconnect(is,  SIGNAL(signCusTimeout(IrcCore*)),
		this,SLOT  (slotConnect   (IrcCore*)));
  }
  itServer->toFirst();

  if (sn){
     delete sn;
     sn = 0L;
  }
  stop();
  emit signDisconnected(curIs);
  state = 0;
}

int IrcClient::setMode(const char* txt)
{
  QString st=txt;
  if (st[0]=='+'){
     st=st.remove(0,1);
     mode.addMode(st);
  }
  else if (st[0]=='-'){
     st=st.remove(0,1);
     mode.delMode(st);
  }
  emit signMode(mode.mode());
  return 1;
}

void IrcClient::slotTimeout()
{
  IrcCore::slotTimeout();
  if (--startActionTimer<1 && startAction.current()){
     startActionTimer=ircapp->readNumEntry("StartActionDelay", 1);
     if (startActionTimer<1)
        startActionTimer=1;

     QString a=startAction.current();
     if (a){
        slotInputParse(a);
	startAction.next();
     }
  }  

  // Check Ignore List
  ignList->checkUser();

  // Check Ban List
  QDictIterator<IrcChannel> it(*channel);
  IrcChannel* ic;
  for (;(ic=it.current())!=0L;++it)
      ic->timeChecker();

#ifdef TCL
  QString entry="CMD_TIMER";
  QString value=ircapp->readEntry(entry, "Yes");
  if (value=="Yes")
     tclCmd->checkTimerTable();
#endif
}

void IrcClient::slotLagging(const char* s)
{
  emit signLagging(s);
}

void IrcClient::slotMsgParse(int s)
{
#ifdef EDEBUG
  cout << "IrcClient::slotMsgParse()"<<endl;
#endif
  if (s<1)
     return;

  if (sn)
     sn->setEnabled(false);
  // Check Proxy
  if (state & SOCKS_CONNECTED && !(state&SOCKET_CONNECTED)){
     int status=socket.getDst();
     if (status<1){
        return;
     }
     state |= SOCKET_CONNECTED;
     socket.sendNick(curNick);
     IrcServer* is=curServer;
     QString str(4096);
     str.sprintf("%s %s %s :%s", curUser.data(), 
		 socket.getLocalInetAddress().getHostName().data(),
		 is->Host().data(),
		 curIrcname.data());
     socket.sendUser(str);
     emit signConnected(is);
     if (sn)
        sn->setEnabled(true);
     return;
  }

  QString d(4096);
  if (socket.readLine(d)<1){
     return;
  } 
  if (d.isNull()){
    if (sn)
       sn->setEnabled(true);
     return;
  }

  msgParser->parseLine(d);
  if (sn)
     sn->setEnabled(true);
#ifdef EDEBUG
  cout << "IrcClient::slotMsgParse()...Ok"<<endl;
#endif
  return;
}

void IrcClient::slotInputParse(const char* Txt)
{
#ifdef EDEBUG
  cout << "IrcClient::slotInputParse:"<<Txt<<endl;
#endif
  QString inp = alias->eval(Txt);
  if (inp.isEmpty())
     return;
  slotCommand(name(), inp);
}

void IrcClient::slotCommand(const char* Name, const char* Txt)
{
#ifdef EDEBUG
  cout << "IrcClient::slotCommand:"<<Name<<":"<<Txt<<endl;
#endif

  QString t = cmdSubstitution(Txt);
  if (t.isEmpty())
     return;
  if (t[0]!=cmdChar[0] && stricmp(Name, name()))
     t = cmdChar+"PRIVMSG "+QString(Name)+" "+t;
  if (t[0]==cmdChar[0]){
     t.remove(0, 1);
     if (cmdParser->parseLine(Name, t))
        return; 
     if (!(state&SOCKET_CONNECTED) ){
        QString s="Server not connected...";
	slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
	return;
     }
     socket.parseLine(t);
     return;
  }

  if (!stricmp(Name, name()))
    return;

  if (!(state&SOCKET_CONNECTED) ){
     QString s="Server not connected...";
     slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
     return;
  }
  socket.sendPrivmsg(QString(Name)+" "+t);
}

void IrcClient::slotWriteOnActive(int Type, const char* Msg, bool Filter)
{
  signWriteOnActive(Type, Msg, Filter);
}

void IrcClient::slotCtcpReply(IrcCore* ic)
{
  QString s=ctcpReplyList.first();
  if (s){
     socket.sendCtcpReply(s);
     ctcpReplyList.remove();
  }
  if (!ctcpReplyList.current())
     ic->stop();
}


// Channel 
int IrcClient::addChannel(const char* Channel, const char* Key, int flag)
{
#ifdef EDEBUG
  cout << "IrcClient::addChannel("<<Channel<<")"<<endl;
#endif

  IrcChannel* c;
  if (channel->find(Channel))
     return 1;

  channel->insert(Channel,c=new IrcChannel(Channel, this, Key)); 
  connect(this,
	  SIGNAL(signCurNick    (const char*)),
	  c,
	  SLOT  (slotCurrentNick(const char*)));
  emit signCurNick(curNick);
  connect(c,
	  SIGNAL(signCommand(const char*, const char*)),
	  this,
	  SLOT  (slotCommand(const char*, const char*)));
	  
  emit signAddChannel(Channel, Key, flag);

#ifdef EDEBUG
  cout << "IrcClient::addChannel("<<Channel<<")...Ok"<<endl;
#endif
   return 1;
}

int IrcClient::delChannel(const char* Channel, bool emitted)
{
  IrcChannel* ic;
  if ((ic=channel->find(Channel))==0L)
     return 0;
  if (emitted)
     emit signDelChannel(ic);
  channel->remove(Channel); 
  QString entry="InvDlgCur";
  int cur = ircapp->readNumEntry("InvDlgCur", 0);
  if (cur >0)
     cur--;
  ircapp->writeEntry("InvDlgCur", cur);
  return 1;
}

int IrcClient::onStarting(const char* txt)
{
  emit signStarting();

  StringToken t(txt);
  QString nick=t.nextToken();
  // nick aktualisieren
  setCurNick(nick);

#ifdef EDEBUG
  cout << "IrcClient::Rejoin"<<endl;
#endif
  // channel rejoin
  QDictIterator<IrcChannel> itc(*channel);
  IrcChannel* ic;
  QString name;
  for (;(ic=itc.current())!=0L;){
     name=itc.currentKey();
     QString ck=ic->getMode().key();
     if (ck.isNull())
        ck="";
     delChannel(name);
     socket.sendJoin(name+" "+ck);
  }

#ifdef EDEBUG
  cout << "IrcClient::Rejoin...Ok"<<endl;
#endif

  emit signWriteMsg(TYPE_MSG|TYPE_IMG, t.toEnd());

  startActionTimer= ircapp->readNumEntry("StartActionDelay", 1);
  startAction.first();
  onList.clear();
  doIson();

  mode.clear();

  ircapp->localHost = socket.getLocalInetAddress().getHostName();
  // starting timer
  start();

  return 1;
}

void IrcClient::initAll()
{
#ifdef EDEBUG
  cout << "IrcClient::initAll()"<<endl;
#endif
  if (!curNick.isEmpty())
     setCurNick  (curNick);
  if (curServer!=0L)
     setCurServer(curServer->toString());
  emit signDisconnected(0L);
  optPrefDlg->initAll();
}

void IrcClient::slotIsOn(IrcCore*)
{
  doIson();
  IrcCore* timer=timerList["IsOn"];
  timer->stop();
}

void IrcClient::doIson()
{
  if (socket.getSocket()<0){
     onList.clear();
     return;
  }
  QString ios="";
  QString tmp;
  QString line;
  for (line=isonList.first();line;line=isonList.next()){
      StringToken t(line);
      while (t.hasMoreTokens()){
	 QString n=t.nextToken();
	 if (stricmp(n, currentNick()))
	    ios += n+" ";
      }
  }
  socket.sendIson(ios);
}


// PrivMsg stuff

int IrcClient::addPrivMsg(const char* user, int flag)
{
#ifdef EDEBUG
  cout << "IrcClient::addPrivMsg:"<<user<<endl;
#endif
  int max = ircapp->readNumEntry("PrivMsgClientMax", 5);
  int cur = ircapp->readNumEntry("PrivMsgClientCur", 0);
  if (cur >= max)
     return 0;

  StringToken t(user);
  QString nick = t.nextToken(" !");
  IrcPrivMsg* ipm;
  if (privMsg->find(nick))
     return 1;
  privMsg->insert(nick, ipm=new IrcPrivMsg(nick, this)); 

  connect(this,
	  SIGNAL(signCurNick    (const char*)),
	  ipm,
	  SLOT  (slotCurrentNick(const char*)));
  emit signCurNick(curNick);
  connect(ipm,
	  SIGNAL(signCommand(const char*, const char*)),
	  this,
	  SLOT  (slotCommand(const char*, const char*)));
	  
  emit signAddPrivMsg(nick, flag);
  return 1;
}

int IrcClient::delPrivMsg(const char* user, bool emitted)
{
  IrcPrivMsg* ic;
  if ((ic=privMsg->find(user))==0L)
     return 0;
  if (emitted)
     emit signDelPrivMsg(ic);
  privMsg->remove(user);
  QString entry="PrivMsgDlgCur";
  int cur = ircapp->readNumEntry(entry, 0);
  if (cur >0)
     cur--;
  ircapp->writeEntry(entry, cur);
  return 1;
}

int IrcClient::addDCCChat(const char* from, const char* arg, int flag)
{
#ifdef EDEBUG
  cout << "IrcClient::addDCCChat:"<<from<<":"<<arg<<endl;
#endif
  int max = ircapp->readNumEntry("DCCChatClientMax", 5);
  int cur = ircapp->readNumEntry("DCCChatClientCur", 0);
  if (cur >= max)
     return 0;

  StringToken ft(from);
  QString user = ft.nextToken(" ");
  DCCChat* dc;
  if ((dc=dccChat->find(user))!=NULL)
     delDCCChat(user);
  if (!arg)
     dc = new DCCChat(user, this);
  else{
     StringToken at(arg);
     QString ip   = at.nextToken();
     QString port = at.nextToken();
     dc = new DCCChat(user, ip, port, this);
  }
  dccChat->insert(user, dc); 

  connect(this,
	  SIGNAL(signCurNick    (const char*)),
	  dc,
	  SLOT  (slotCurrentNick(const char*)));
  emit signCurNick(curNick);
  connect(dc,
	  SIGNAL(signCommand(const char*, const char*)),
	  this,
	  SLOT  (slotCommand(const char*, const char*)));
	  
  emit signAddDCCChat(user, flag);
  return 1;
}

int IrcClient::delDCCChat(const char* user, bool emitted)
{
  DCCChat* dc;
  if ((dc=dccChat->find(user))==0L )
     return 0;
  if (emitted)
     emit signDelDCCChat(dc);
  dccChat->remove(user);
  QString entry="DCCChatCur";
  int cur = ircapp->readNumEntry(entry, 0);
  if (cur >0)
     cur--;
  ircapp->writeEntry(entry, cur);
  return 1;
}

int IrcClient::addDCCFile(const char* from, const char* arg, int flag)
{
#ifdef EDEBUG
  cout << "IrcClient::addDCCFile:"<<from<<":"<<arg<<endl;
#endif
  int max = ircapp->readNumEntry("DCCFileClientMax", 5);
  int cur = ircapp->readNumEntry("DCCFileClientCur", 0);
  if (cur >= max)
     return 0;

  StringToken ft(from);
  StringToken at(arg);
  int argc = at.countTokens();
  QString user = ft.nextToken(" ");
  DCCFile* df;
  QString file=at.nextToken();
  if (file.isEmpty())
     return 0;
  QString ident = file+":"+user;
  if (dccFile->find(ident))
     return 1;

  if (argc==1)
     df = new DCCFile(user, file, this);
  else{
    QString ip   = at.nextToken();
    QString port = at.nextToken();
    QString size = at.nextToken();
    if (ip.isEmpty() || port.isEmpty() || size.isEmpty())
       return 0;
    df = new DCCFile(user, file, ip, port, size, this);
  }
  dccFile->insert(ident, df); 

  connect(this,
	  SIGNAL(signCurNick    (const char*)),
	  df,
	  SLOT  (slotCurrentNick(const char*)));
  emit signCurNick(curNick);
  connect(df,
	  SIGNAL(signCommand(const char*, const char*)),
	  this,
	  SLOT  (slotCommand(const char*, const char*)));

  emit signAddDCCFile(ident, flag);
  return 1;
}

int IrcClient::delDCCFile(const char* user, bool emitted)
{
  DCCFile* df;
  if ((df=dccFile->find(user))==0L )
     return 0;
  if (emitted)
     emit signDelDCCFile(df);
  dccFile->remove(user);
  QString entry="DCCFileCur";
  int cur = ircapp->readNumEntry(entry, 0);
  if (cur >0)
     cur--;
  ircapp->writeEntry(entry, cur);
  return 1;
}

IrcSocket& IrcClient::getSocket()
{
  return this->socket;
}

void IrcClient::Sleep(ulong second)
{
#ifdef EDEBUG
  cout << "IrcClient::Sleep("<<second<<")"<<endl;
#endif
  IrcSleeper is;
  is.start(second);
#ifdef EDEBUG
  cout << "IrcClient::Sleep...Ok"<<endl;
#endif
}

IrcUser* IrcClient::getIrcUser(const char* nick, int sw)
{
  IrcChannel* ic;
  IrcUser*    iu;
  QDictIterator<IrcChannel> c_it (*channel);
  for (;(ic=c_it.current())!=0L;++c_it){
      iu = ic->cuList->find(nick);
      if (iu && sw==0){
	 if (!iu->host().isEmpty())
	    return iu;
      }
      else if (iu && sw==1){
	 if (!iu->server().isEmpty())
	    return iu;
      }
  }
  IrcPrivMsg* ipm=privMsg->find(nick);
  if (ipm){
     iu=ipm->user;
     if (iu && sw==0){
	 if (!iu->host().isEmpty())
	    return iu;
      }
      else if (iu && sw==1){
	 if (!iu->server().isEmpty())
	    return iu;
      }
  }
  if ((iu=whoisCache->find(nick))!=0L)
     return iu;
  else {
     getSocket().sendWhois(nick);
     Sleep(1);
     if ((iu=whoisCache->find(nick))!=0L)
        return iu;
  }
  return 0L;
}


QString IrcClient::addOutputPage(const char* name, int flag, bool detach, const char* pix)
{
  emit signAddOutputPage(name, flag, detach, pix);
  return QString(name);
}

void IrcClient::delOutputPage(const char* name, bool emitted)
{
  if (emitted)
     emit signDelOutputPage(name);
}

void IrcClient::slotWritePage(const char* name, int Type, const char* Msg, bool Parsen)
{
  emit signWritePage(name, Type, Msg, Parsen);
}

void IrcClient::slotSocketText(const char* txt)
{
  QString entry, value;
  entry = "ShowRawOutput";
  value = ircapp->readEntry(entry, "No");
  if (!stricmp(value, "yes"))
     slotWritePage("kEirc Raw", TYPE_INFO|TYPE_IMG, 
			   QString("[OUT] ")+txt, false);
}

QString IrcClient::makeBan(const char* nick, int flag)
{
  IrcUser* iu=0L;
  int i;
  for (i=0;i<3 && iu==0L;i++)
     iu=getIrcUser(nick);
  if (iu==0L){
     QString s=QString("Cannot find user ")+nick+QString(" , banmask can not be generated");
     slotWriteMsg(TYPE_INFO|TYPE_IMG, s);
     return QString(nick);
  }

  QString val;
  if (flag<0)
     val=ircapp->readEntry("BanType", "BanType0");
  else{
     QString s; s.setNum(flag);
     val="BanType"+s;
  }

  QString  ban;

  bool isIP;
  QStrList host; host.setAutoDelete(true);
  host2list(iu->host(), host, isIP);

  if (!stricmp(val, "BanType0"))
     ban="*!*"+iu->user()+"@"+iu->host();
  else if (!stricmp(val, "BanType1"))
     ban="*!*@"+iu->host();
  else if (!stricmp(val, "BanType2")){
     if (!isIP)
        ban="*!*"+iu->user()+"@*."+QString(host.at(1))+"."+QString(host.at(0));
     else
        ban="*!*"+iu->user()+"@"+QString(host.at(0))+"."+QString(host.at(1))+".*";
  }
  else if (!stricmp(val, "BanType3")){
     if (!isIP)
        ban="*!*@*."+QString(host.at(1))+"."+QString(host.at(0));
     else
        ban="*!*@"+QString(host.at(0))+"."+QString(host.at(1))+".*";
  }
  else if (!stricmp(val, "BanType4")){
     if (!isIP)
        ban="*!*@*."+QString(host.at(0));
     else
        ban="*!*@"+QString(host.at(0))+".*";
  }
  else
     ban=nick;

  return ban;
}

#include "ircClient.moc"



