#include "ircServer.h"

IrcServer::IrcServer(const char* host, int port, const char* passwd, const char* info):
  IrcCore()
{
  if (!host)
     this->host = "localhost";
  else
     this->host = host;
  this->port.setNum(port);
  setName(this->host+":"+this->port);
  this->info   = info;
  this->passwd = passwd;
}

IrcServer::~IrcServer()
{
}

QString IrcServer::Host()
{
  return host;
}

QString IrcServer::Info()
{
  return info;
}

QString IrcServer::Passwd()
{
  return passwd;
}

QString IrcServer::Port()
{
  return port;
}

void IrcServer::setPasswd(const char* passwd)
{
  this->passwd = passwd;
}

void IrcServer::setInfo(const char* info)
{
  this->info = info;
}

void IrcServer::setPort(int port)
{
  this->port.setNum(port);
}

QString IrcServer::toString()
{
  return (host+":"+port+":"+info);
}
