#include <stdlib.h>
#include <iostream.h>
#include <qlined.h>
#include <qfiledlg.h> 
#include <qfileinf.h> 
#include <qdir.h>
#include <qtooltip.h> 
#include "fileReader.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include "kmsgbox.h"
#include "ircDefine.h"
#include "onDCCFilePage.h"
#include "onDCCFilePage.moc"
#include "ircApp.h"

void OnDCCFilePage::Init()
{
  btnGroup.setAutoDelete(false);
  radioBtn.setAutoDelete(false);
  groupBox.setAutoDelete(false);
  intLine.setAutoDelete (false);
  checkBox.setAutoDelete(false);

  checkText.setAutoDelete(true);
  configText.setAutoDelete(true);
  actionText.setAutoDelete(true);
}

OnDCCFilePage::OnDCCFilePage(IrcClient* client, QWidget *parent, const char *name ) : 
  QWidget( parent, name )
{
  Init();
  this->client=client;
  
  topLayout = new QVBoxLayout(this, 10);
  grid      = new QGridLayout(2, 2, 10);
  topLayout->addLayout(grid);

  createActionRadioBtn();
  createConfigBox();
  createOnClosed();
  createPushButton();

  topLayout->activate();
  readConfig();
  show();
}

OnDCCFilePage::~OnDCCFilePage()
{
#ifdef EDEBUG
  cout << "Destruktor OnDCCFilePage" << endl;
#endif
}


void OnDCCFilePage::createActionRadioBtn()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("Action", bg=new QButtonGroup("Action", this));
  grid->addWidget(bg, 0, 0 );

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QRadioButton* rb;
  actionText.append(entry=qstrdup("AutoAccept"));
  radioBtn.insert(entry, rb = new QRadioButton("Auto Accept", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Ignore"));
  radioBtn.insert(entry, rb = new QRadioButton("Ignore it", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);

  actionText.append(entry=qstrdup("Dialog"));
  radioBtn.insert(entry, rb = new QRadioButton("Dialog", bg));
  rb->setFixedHeight(rb->sizeHint().height());
  vbox->addWidget(rb);
  //vbox->addSpacing(bg->fontMetrics().height());
  vbox->addStretch(10);
  vbox->activate();
}

void OnDCCFilePage::createConfigBox()
{
  QString entry;
  QGroupBox* gb;

  groupBox.insert("Config", gb=new QGroupBox("Config", this));
  grid->addWidget(gb, 0, 1);

  QVBoxLayout* vbox;
  QHBoxLayout* hbox;
  
  vbox = new QVBoxLayout(gb, 10);
  vbox->addSpacing(gb->fontMetrics().height());

  QLabel* label;
  KIntegerLine* il;

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Max DCC File Client", gb);
  hbox->addWidget(label,5);
  configText.append(entry="DCCFileClientMax");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(25);
  hbox->addWidget(il,2);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Max Dialog", gb);
  hbox->addWidget(label,5);
  configText.append(entry="DCCFileDlgMax");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(25);
  hbox->addWidget(il,2);

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("Dialog Timeout[s]", gb);
  hbox->addWidget(label,5);
  configText.append(entry="DCCFileDlgTimeout");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(25);
  hbox->addWidget(il,2); 

  hbox = new QHBoxLayout;
  vbox->addLayout(hbox);
  label = new QLabel("DCCSend Timeout[s]", gb);
  hbox->addWidget(label,5);
  configText.append(entry="DCCSendTimeout");
  intLine.insert(entry, il = new KIntegerLine(gb, "line", KEditTypeDec));
  il->setFixedHeight(25);
  hbox->addWidget(il,2); 

  vbox->activate();
}

void OnDCCFilePage::createOnClosed()
{
  QString entry;
  QButtonGroup* bg;

  btnGroup.insert("OnFinished", bg=new QButtonGroup("On Finished", this));
  grid->addWidget(bg, 1, 1 );

  QVBoxLayout* vbox;
  
  vbox = new QVBoxLayout(bg, 10);
  vbox->addSpacing(bg->fontMetrics().height());

  QCheckBox* cb;
  checkText.append(entry=qstrdup("OnFinishedBeep"));
  checkBox.insert(entry, cb = new QCheckBox("Beep", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  vbox->addWidget(cb);

  checkText.append(entry=qstrdup("OnFinishedCloseWindow"));
  checkBox.insert(entry, cb = new QCheckBox("Close window", bg));
  cb->setFixedHeight(cb->sizeHint().height());
  vbox->addWidget(cb);
  vbox->addStretch(10);

  vbox->activate();
}


void OnDCCFilePage::createPushButton()
{
  QVBoxLayout* vbox;
  QHBoxLayout* hbox;
  QLabel*      label;
  QPushButton* btn;

  vbox = new QVBoxLayout(10);
  grid->addLayout(vbox, 1, 0);

  vbox->addSpacing(10);
  hbox = new QHBoxLayout(5);
  vbox->addLayout(hbox);

  label = new QLabel("Bytes per Block :" , this);
  hbox->addWidget(label,4);

  blockCombo = new QComboBox(this);
  hbox->addWidget(blockCombo,3);
  blockCombo->setFixedHeight(25);

  hbox = new QHBoxLayout(10);
  vbox->addLayout(hbox);

  label = new QLabel("DCC File dir:" , this);
  hbox->addWidget(label,4);

  dirBox = new FileDirBox(this);
  hbox->addWidget(dirBox,3);
  dirBox->setFixedHeight(25);

  btn = new QPushButton(" Apply ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotApply()));
  vbox->addWidget(btn, 0, AlignLeft);
  vbox->addStretch(10);
  btn->setFixedSize(100, btn->sizeHint().height());
}

void OnDCCFilePage::readConfig()
{
#ifdef EDEBUG
  cout << "OnDCCFilePage::readConfig"<<endl;
#endif
  QString entry;
  QString value;

  QDictIterator<QRadioButton> it(radioBtn);
  QRadioButton* rbtn;
  for (;(rbtn=it.current())!=0L;++it)
     rbtn->setChecked(false);

  entry = "OnDCCFile";
  value = ircapp->readEntry(entry, "AutoAccept");
  radioBtn[value]->setChecked(true);
  ircapp->writeEntry(entry, value);

  // max ircclient
  entry = "DCCFileClientMax";
  value = ircapp->readEntry(entry, "5");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);

  // max window
  entry = "DCCFileDlgMax";
  value = ircapp->readEntry(entry, "5");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);

  // timeout
  entry = "DCCFileDlgTimeout";
  value = ircapp->readEntry(entry, "30");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);

  entry = "DCCSendTimeout";
  value = ircapp->readEntry(entry, "120");
  intLine[entry]->setText(value);
  ircapp->writeEntry(entry, value);

  for (entry=checkText.first();entry;entry=checkText.next()){
      value = ircapp->readEntry(entry, "No");
      if (value=="Yes")
	 checkBox[entry]->setChecked(1);
      ircapp->writeEntry(entry, value);
  }

  QString block=ircapp->readEntry("DCCSendBlock", "1024");
  blockCombo->clear();
  for (int i=1;i<5;i++){
      QString s;
      s.setNum(i*1024);
      int idx=-1;
      if (!stricmp(s, block))
	 idx=0;
      blockCombo->insertItem(s, idx);
  }

  QString dir=ircapp->readEntry("DCCFileDir", ircapp->home);
  dirBox->setPath(dir);
}

void OnDCCFilePage::slotApply()
{
#ifdef EDEBUG
  cout << "OnDCCFilePage::slotApply:"<<endl;
#endif
  QString entry;
  QString value;
  QRadioButton* rb;

  entry = "OnDCCFile";
  for (value=actionText.first();value;value=actionText.next()){
      rb=radioBtn[value];
      if (!rb)
	 continue;
      if (rb->isChecked())
	 ircapp->writeEntry(entry, value);
  }

  entry = "DCCFileClientMax";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  entry = "DCCFileDlgMax";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  // timeout
  entry = "DCCFileDlgTimeout";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  entry = "DCCSendTimeout";
  value = intLine[entry]->text();
  ircapp->writeEntry(entry, value);

  QCheckBox* cb;
  for (entry=checkText.first();entry;entry=checkText.next()){
      cb=checkBox[entry];
      if (!cb)
	 continue;
      if (cb->isChecked())
	 value="Yes";
      else
	 value="No";
      ircapp->writeEntry(entry, value);
  }

  QString block=blockCombo->currentText();
  ircapp->writeEntry("DCCSendBlock", block);

  QString dir=dirBox->currentText();
  ircapp->writeEntry("DCCFileDir", dir);
}

void OnDCCFilePage::slotSelect()
{
  QString entry="DCCFileDir";
  QString value = ircapp->readEntry(entry, ircapp->home);
  QFileDialog dlg(value, 0, 0, 0, 1);
  if (dlg.exec()){
     QString dir=dlg.dirPath();
     if (!dir.isNull()){        
        pathEdit->setText(dir);
     }
  }
}









