#ifndef __SOCKS_H__
#define __SOCKS_H__

#include <qstring.h>
#include "ircServer.h"
#include "ClientSocket.h"

#define SOCKS_VERSION	    4
#define SOCKS_REPLY_VERSION 0

#define SOCKS_CONNECT	    1
#define SOCKS_BIND	    2
#define SOCKS_RESULT	   90
#define SOCKS_FAIL	   91
#define SOCKS_NO_IDENTD	   92 
#define SOCKS_BAD_ID       93

  
#if defined(__alpha)
typedef unsigned int u_int32;
#else
typedef unsigned long u_int32;
#endif


typedef struct {
    u_int32           host; // in network byte order
    unsigned short    port; // in network byte oreder
    unsigned char     version;
    unsigned char     cmd;
} SOCKS_STRUCT;

class IrcClient;

class Socks : public ClientSocket
{
  Q_OBJECT
  friend class IrcClient;
protected:
  SOCKS_STRUCT mDst;
  QString      mLogin;
  QString      mPasswd;
  InetAddress  dstInAddr;
private:
  void init();
protected:
  int sendName();
  int sendDst();
public:
  Socks();
  // It's host of socks and port, socks is running on
  Socks(const char* host, int port);
  ~Socks();
  void setSockServer(const char* host, int port);
  void setUserName(const char* login, const char* passwd);
  void setParameter(const char* arg);
  int  ROpen(const char* host, int port);
  int  ROpen(IrcServer* is);
  int  getDst();
  InetAddress& getDstInetAddress();
};

#endif
