#ifndef __WEBSERVERPAGE_H__
#define __WEBSERVERPAGE_H__

#include <qevent.h>
#include <qframe.h>
#include <qlistbox.h>
#include <kpanner.h>
#include "ircHtml.h"
#include "ircLine.h"
#include "ircClient.h"
#include "ircPopup.h"
#include "outputPage.h"
#include "webServer.h"

class IrcClient;

class WebServerPage : public OutputPage
{
  Q_OBJECT
protected:
  WebServer* webServer;
  QListBox*  lbMsg;
protected:
  void resizeEvent (QResizeEvent*);
  void createPopup ();
  void createToolbar();
public slots:
  void slotPopup(const char*, const QPoint&);
  void slotPopupAction(const char*);
  void slotConnected   (IrcServer*);
  void slotDisconnected(IrcServer*);

public:
  WebServerPage(IrcClient* Client, QWidget* parent, const char* Name=NULL);
  ~WebServerPage();
};

#endif 


