##############################################################################
#                                                                            #
# kftpupdater - Mirror a local directory to an ftp server or vice versa      #
# Copyright (C) 2000 Martin P. Holland  <m.holland@noether.freeserve.co.uk>  #
#                                                                            #
# This program is free software; you can redistribute it and/or modify       #
# it under the terms of the GNU General Public License as published by       #
# the Free Software Foundation; either version 2 of the License, or          #
# (at your option) any later version.                                        #
#                                                                            #
# This program is distributed in the hope that it will be useful,            #
# but WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
# GNU General Public License for more details.                               #
#                                                                            #
# You should have received a copy of the GNU General Public License          #
# along with this program; if not, write to the Free Software                #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  #
#                                                                            #
##############################################################################

from qt import *
from kdecore import i18n
class nameDialog(QDialog):
#class that allows you to type in a name for a project
    def __init__(self,parent,name):
            QDialog.__init__(self,parent,name,1)

            self.setCaption("Project:")

            ok=QPushButton(i18n("&OK"),self,'')
            button_size=ok.sizeHint()
            ok.setMinimumSize( button_size);
            QObject.connect(ok,SIGNAL("clicked()"),self.okPress)

            cancel=QPushButton(i18n("&Cancel"),self,'')
            button_size=cancel.sizeHint()
            cancel.setMinimumSize( button_size);
            QObject.connect(cancel,SIGNAL("clicked()"),self.reject)

            project_label= QLabel( i18n("Project name:") , self)
            project_label.setMinimumSize( project_label.sizeHint() );

            self.project = QLineEdit( self,'')
            self.project.setMaxLength(40)
            self.project.setMinimumSize( self.project.sizeHint())
            self.project.setFocus()  #focus on the project box

            QObject.connect(self.project,SIGNAL("returnPressed()"),self.okPress)
            widget = QVBoxLayout( self, 10 )

            project_layout = QHBoxLayout()
            ok_layout = QHBoxLayout()
 
            widget.addLayout( project_layout )
            widget.addStretch(1)
            widget.addLayout( ok_layout )

            project_layout.addWidget( project_label )
            project_layout.addStretch(1)
            project_layout.addWidget( self.project, 1 )

            ok_layout.addStretch(1)
            ok_layout.addWidget(ok)
            ok_layout.addStretch(1)
            ok_layout.addWidget(cancel)
            ok_layout.addStretch(1)

            self.show()
    def okPress(self):
        self.Name=self.project.text()
        self.accept()

    def return_name(self):
        return self.Name

