##############################################################################
#                                                                            #
# kftpupdater - Mirror a local directory to an ftp server or vice versa      #
# Copyright (C) 2000 Martin P. Holland  <m.holland@noether.freeserve.co.uk>  #
#                                                                            #
# This program is free software; you can redistribute it and/or modify       #
# it under the terms of the GNU General Public License as published by       #
# the Free Software Foundation; either version 2 of the License, or          #
# (at your option) any later version.                                        #
#                                                                            #
# This program is distributed in the hope that it will be useful,            #
# but WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
# GNU General Public License for more details.                               #
#                                                                            #
# You should have received a copy of the GNU General Public License          #
# along with this program; if not, write to the Free Software                #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  #
#                                                                            #
##############################################################################

import os
from stat import *
from ftp import *
from abstracttransfer import AbstractTransfer
from transferhelpers import *

class RemoteToLocalTransfer(AbstractTransfer):
    """
    Methods to transfer files etc from a remote directory
    to a local directory
    """
    def __init__(self,rdir,ldir,ftp,dbfile):
        AbstractTransfer.__init__(self,rdir,ldir,ftp,dbfile)
    def smdtm(self,f):
        try:
            mod=self.ftp.mdtm(f)
        except all_errors,detail:
            self.error=("Can't get modification time of "+f,detail)
            return -1
        return mod
    def put(self,f):
        try:
            self.ftp.setProgress(self.do_progress,self.finish_progress)
            self.init_progress(f)
            self.ftp.binget3(self.path_sTot(f),f)
        except all_errors,detail:
            self.error=("Can't get remote file "+f,detail)
            return 0
        return 1

    def size(self,f):
        return self.ftp.size(f)

    def sfilesdirs(self,d):
        try:
            files,dirs=self.ftp.filesdirs(d)
        except all_errors,detail:
            self.error=("Can't get list of remote files and directories in "+d,detail)
            return None,None
        return files,dirs
    def tfilesdirs(self,d):
        return local_filesdirs(d)
    def tdelete(self,f):
        try:
            os.remove(f)
        except os.error,detail:
            self.error=("Can't remove file "+f,detail[1])
            return 0
        else:
#            if f in self.db.keys(): del self.db[f]
            return 1
    def tmkd(self,d):
        try:
            os.mkdir(d)
        except os.error,detail:
            self.error=("Can't create directory "+d,detail[1])
            return 0
        return 1
    def temptydir(self,d):
        #FIXME
        os.system('rm -rf '+d)
#        for k in self.db.keys():
#            if k[:len(d)]==d:
#                del self.db[k]
        return 1
