/* $Id: configdlg.cpp,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: configdlg.cpp,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.4  1999/02/07 17:29:17  matt
   reorganized + new widgets

   Revision 1.3  1998/12/19 19:38:57  matt
   Added buttongroup mode
   finally works

   Revision 1.2  1998/11/09 22:33:01  matt
   Config dialog for transfer

   Revision 1.1  1998/11/05 23:06:47  matt
   *** empty log message ***


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>
#include <kapp.h>

#include "kget.h"
#include "configdlg.h"


ConfigDlg::ConfigDlg(KMainWidget *_km, KItem *_item)
  : QDialog(0, "", true), km( _km )
{

  item = _item;

  QBoxLayout *topLayout = new QVBoxLayout( this, 10, 5 );
	
  topLayout->addSpacing( 10 );

  QGridLayout *grid = new QGridLayout( 2, 2, 10 );
  topLayout->addLayout( grid );

  grid->setRowStretch(0,1);
  grid->setRowStretch(1,1);
    
  grid->setColStretch(0,1);
  grid->setColStretch(1,100);

  lb_from = new QLabel(i18n("From :"), this);
  lb_from->setMinimumSize( lb_from->sizeHint() );
  grid->addWidget( lb_from, 0, 0 );

  lb_source = new QLabel( item->src.data(), this );
  lb_source->setAlignment( AlignVCenter );
  lb_source->setMinimumHeight( lb_source->sizeHint().height() + 5 );
  lb_source->setBackgroundColor( QColor( white ));
  lb_source->setFrameStyle( QFrame::Box | QFrame::Sunken );
  grid->addWidget( lb_source, 0, 1 );

  lb_to = new QLabel(i18n("To :"), this);
  lb_to->setMinimumSize( lb_to->sizeHint() );
  grid->addWidget( lb_to, 1, 0 );

  lb_dest = new QLabel( item->dest.data(), this );
  lb_dest->setAlignment( AlignVCenter );
  lb_dest->setMinimumHeight( lb_dest->sizeHint().height() + 5 );
  lb_dest->setBackgroundColor( QColor( white ));
  lb_dest->setFrameStyle( QFrame::Box | QFrame::Sunken );
  grid->addWidget( lb_dest, 1, 1 );

  topLayout->addSpacing( 10 );

  // Mode groupbox & buttons
  modeButtons = new QButtonGroup( "Mode", this );
  topLayout->addWidget( modeButtons, 10 );
  connect( modeButtons, SIGNAL(clicked(int)), SLOT(changeMode()) );

  QBoxLayout *hbLayout = new QHBoxLayout(modeButtons, 10 );

  hbLayout->addStretch( 5 );
  rbQueued = new QRadioButton(i18n("Queued"), modeButtons );
  rbQueued->adjustSize();
  rbQueued->setFixedSize( rbQueued->sizeHint() );
  modeButtons->insert( rbQueued, KItem::MD_QUEUED );
  hbLayout->addWidget( rbQueued, 5 );
  hbLayout->addStretch( 5 );

  rbScheduled = new QRadioButton(i18n("Scheduled"), modeButtons );
  rbScheduled->adjustSize();
  rbScheduled->setFixedSize( rbScheduled->sizeHint() );
  modeButtons->insert( rbScheduled, KItem::MD_SCHEDULED );
  hbLayout->addWidget( rbScheduled, 5 );
  hbLayout->addStretch( 5 );

  rbDelayed = new QRadioButton(i18n("Delayed"), modeButtons );
  rbDelayed->adjustSize();
  rbDelayed->setFixedSize( rbDelayed->sizeHint() );
  modeButtons->insert( rbDelayed, KItem::MD_DELAYED );
  hbLayout->addWidget( rbDelayed, 5 );
  hbLayout->addStretch( 15 );

  modeButtons->setButton( item->mode );

  topLayout->addSpacing( 10 );

  // Timer groupbox & spins
  groupTimer = new QGroupBox(i18n("Timer"), this, "groupTimer");
  topLayout->addWidget( groupTimer, 10 );

  QBoxLayout* vbLayout = new QVBoxLayout(groupTimer, 10, 5 );
  vbLayout->addSpacing( 3 );

  if( item->mode == KItem::MD_SCHEDULED)
    spins = new BWDateTime(item->startTime, groupTimer, "spins");
  else
    spins = new BWDateTime(QDateTime::currentDateTime(), groupTimer, "spins");

  spins->setMinimumHeight( 95 );
  vbLayout->addWidget( spins, 5 );
  vbLayout->addSpacing( 3 );

  changeMode();

  topLayout->addSpacing( 5 );

  // ok & cancel buttons
  QBoxLayout *pushLayout = new QHBoxLayout( 5 );
  topLayout->addLayout( pushLayout );

  ok = new QPushButton(i18n("OK"), this);
  ok->adjustSize();
  ok->setFixedSize( ok->sizeHint() );
  ok->setDefault(TRUE);
  connect(ok, SIGNAL(clicked()), SLOT(accept()));

  pushLayout->addStretch( 6 );
  pushLayout->addWidget( ok, 5 );
  
  cancel = new QPushButton(i18n("Cancel"), this);
  cancel->adjustSize();
  cancel->setFixedSize( cancel->sizeHint() );
  connect(cancel, SIGNAL(clicked()), SLOT(reject()));
  pushLayout->addWidget( cancel, 5);

  topLayout->addSpacing( 5 );
  topLayout->activate();
  // my name is
  setCaption(i18n("Transfer Configuration"));

}


ConfigDlg::~ConfigDlg()
{
  // now delete everything we allocated before
  delete lb_from;
  delete lb_source;
  delete lb_to;
  delete lb_dest;

  delete rbQueued;
  delete rbScheduled;
  delete rbDelayed;

  delete spins;
  delete groupTimer;

  delete ok;
  delete cancel;

  // time to say goodbye ...
}


void ConfigDlg::done( int r ) 
{
  if ( r == Rejected ) {
    hide();

    km->confdlg = 0L;
    return;
  }

  hide();

  if ( rbQueued->isChecked() )
    item->mode = KItem::MD_QUEUED;
  else if ( rbScheduled->isChecked() ){
    item->mode = KItem::MD_SCHEDULED;
    item->startTime = spins->getDateTime();
  }
  else
    item->mode = KItem::MD_DELAYED;

  km->confdlg = 0L;
}


void ConfigDlg::changeMode()
{
  if ( rbScheduled->isChecked() )
    spins->setEnabled( true );
  else
    spins->setEnabled( false );
}
