/* $Id: dlgLimits.h,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: dlgLimits.h,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.1  1999/02/07 17:11:28  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _DLGLIMITS_H
#define _DLGLIMITS_H

#include <qgroupbox.h> 
#include <qwidget.h>
#include <qlabel.h>
#include <qcheckbox.h>

#include <kintegerline.h>

class DlgLimits : public QWidget
{
  Q_OBJECT

public:

  DlgLimits(QWidget *parent=0, const char *name=0, WFlags f=0);
  ~DlgLimits();

  void setData(QStrList *strList);
  QStrList getData() const;
     
private:

  QGroupBox *gb_limits;
    
  // opened connections
  QLabel    *lb_maxnum;
  KIntegerLine *le_maxnum;

  // minimum bandwidth
  QLabel    *lb_minband;
  KIntegerLine *le_minband;
  QLabel    *lb_bytes;

  // maximum bandwidth
  QLabel    *lb_maxband;
  KIntegerLine *le_maxband;
  QLabel    *lb_bytes2;

};

#endif // _DLGLIMITS_H
