/* $Id: docking.h,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: docking.h,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.4  1999/02/07 17:13:59  matt
   modified docking policy

   Revision 1.3  1998/10/21 17:32:38  matt
   *** empty log message ***

   Revision 1.1.1.1  1998/05/06 19:13:32  matt
   Imported sources

   Revision 1.1  1998/03/02 14:32:29  matt
   *** empty log message ***


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   */


#ifndef _DOCKING_H_
#define _DOCKING_H_

#include <stdio.h>

#include <drag.h>

#include <qpopmenu.h>
#include <qmovie.h>
#include <qlabel.h>

class QMovie;

class DockWidget : public QWidget {

  Q_OBJECT

public:
  DockWidget(const char *name=0);
  ~DockWidget();

  void setAnim( bool );
  void dock();

  bool isDocked() { return docked; }

private slots:
  void toggle_window_state();
  void toggle_docking();
  void mousePressEvent(QMouseEvent *e);

  void movieUpdated( const QRect& );
  void movieStatus( int );

  void slotDropEvent( KDNDDropZone * );
  void quit();

public slots:
  void undock();

protected:
  void paintEvent(QPaintEvent *e);

private:
  bool docked;
  bool animating;

  QPopupMenu *popup_m;

  QMovie movie;
};

#endif
