extern "C" 
{
  #include "k2config.parse.h"

  void k2config_mainParse( const char *_code );  
}

#include "k2config.h"

#include <iostream.h>

K2Config *g_pK2Configs = 0L;

K2Config* k2config_parse( const char *_str )
{
  if ( g_pK2Configs )
    delete g_pK2Configs;

  k2config_mainParse( _str );

  K2Config *g = g_pK2Configs;
  g_pK2Configs = 0L;

  
  return g;
}

void setK2ConfigTree( void *_ptr1 )
{
  g_pK2Configs = static_cast<K2Config*>(_ptr1);
}

void* newK2Config( const char *_type, const char *_name, void *_items, void *_translation )
{
  return new K2Config( _name, _type, static_cast<K2ConfigItem*>(_items), static_cast<K2ConfigTranslation*>(_translation) );
}

void* addK2ConfigBase( void *_base1, void *_base2 )
{
  static_cast<K2ConfigBase*>(_base1)->setNext( static_cast<K2ConfigBase*>(_base2) );
  static_cast<K2ConfigBase*>(_base2)->setPrev( static_cast<K2ConfigBase*>(_base1) );
  return _base1;
}

void* newStringK2ConfigItem( const char *_name, const char* _value, char* _lang )
{
  return new K2ConfigItem( _name, _value, K2ConfigItem::TSTRING, static_cast<const char*>(_lang) );
}

void* newBoolK2ConfigItem( const char *_name, char _value, char* _lang )
{
  return new K2ConfigItem( _name, static_cast<bool>(_value), _lang );
}

void* newLongK2ConfigItem( const char *_name, int _value, char* _lang )
{
  return new K2ConfigItem( _name, _value, _lang );
}

void* newFloatK2ConfigItem( const char *_name, float _value, char* _lang )
{
  return new K2ConfigItem( _name, _value, _lang );
}

void* newFileK2ConfigItem( const char *_name, const char* _value, char* _lang )
{
  return new K2ConfigItem( _name, _value, K2ConfigItem::TFILE, _lang );
}

void* newStringListK2ConfigItem( const char *_name, void* _value, char* _lang )
{
  return new K2ConfigItem( _name, static_cast<list<string>*>(_value), static_cast<const char*>(_lang) );
}

void* newK2ConfigTranslation( const char *_lang, const char *_text, void *_next )
{
  return new K2ConfigTranslation( _lang, _text, static_cast<K2ConfigTranslation*>(_next) );
}

void* newK2ConfigStringList( const char *_text )
{
  list<string>* lst = new list<string>;
  lst->push_front( _text );

  return lst;
}

void* addK2ConfigStringList( const char *_text, void *_ptr )
{
  list<string>* lst = static_cast<list<string>*>(_ptr);
  lst->push_front( _text );
  
  return lst;
}
