// $Id: icqmessage.cpp,v 1.7 1998/12/08 16:16:50 denis Exp $
// $Log: icqmessage.cpp,v $
// Revision 1.7  1998/12/08 16:16:50  denis
// Cleaned up a little before releasing
//

#include "icqmessage.h"
#include "stdio.h"

icqMessage::icqMessage(unsigned long uin, TimeStr time, const char *body, icqMsgType type)
{
  msgType = type ;
  msgUin = uin;
  msgTime = time;
  msgBody = body;
  msgNew = TRUE;
}

icqMessage::icqMessage(unsigned long uin, TimeStr time, const char *url, const char *desc, icqMsgType type)
{
  msgType = type ;
  msgUin = uin;
  msgTime = time;
  msgBody = desc;
  msgURL = url;
  msgNew = TRUE;

  /* Ensure that there is no '\n' in URL */
  int c = 0 ;
  while((c = msgURL.find('\n',0)) != -1) 
    msgURL.remove(c,1) ;
}

icqMessage::icqMessage(icqMessage *msg)
{
  msgType = msg->type() ;
  msgUin = msg->uin();
  msgTime = msg->time();
  msgBody = msg->body();
  msgURL = msg->url();
  msgNew = msg->isNew();
}

unsigned long icqMessage::uin() const
{
  return msgUin;
}

const char *icqMessage::body() const
{
  return msgBody;
}

const char *icqMessage::url() const
{
  return msgURL;
}

TimeStr icqMessage::time() const
{
  return msgTime;
}

int icqMessage::isNew() const
{
  return msgNew;
}

void icqMessage::expire()
{
  msgNew = 0;
}

icqMsgType icqMessage::type()
{
  return msgType ;
}

void icqMessage::setType(icqMsgType type)
{
  msgType = type ;
}

int icqMessage::save(QString path)
{
  char *types[] = { "Unknown", "Message Sent", "Message Received",
                    "URL Sent", "URL Received", "Authorization Requested",
                    "Authorization Granted", "Authorization Refused" } ; 

  char *msg_types[32] ;

  msg_types[MSG_UNDEF] = types[0] ;
  msg_types[MSG_SENT] = types[1] ;
  msg_types[MSG_RECV] = types[2] ;
  msg_types[MSG_URL_SENT] = types[3] ;
  msg_types[MSG_URL_RECV] = types[4] ;
  msg_types[MSG_AUTH_RECV] = types[5] ;
  msg_types[MSG_AUTH_GRANT] = types[6] ;
  msg_types[MSG_AUTH_REFUSE] = types[7] ;

  QString strUin ;
  strUin.setNum(msgUin) ;
  QString fname = path + "/" + strUin + ".history" ;

  QFile file(fname) ;
  if(!file.exists())
    file.open(IO_Raw | IO_WriteOnly);
  else
    file.open(IO_Raw | IO_Append | IO_WriteOnly);

  QString datetime ;
  datetime.sprintf("[%s %02i/%02i/%04i %02i:%02i]\n",msg_types[msgType],
                   msgTime.day, msgTime.month, msgTime.year,
                   msgTime.hour, msgTime.minute);

  QString separator = "\n";
  file.writeBlock((const char*)datetime, datetime.length());
  if(msgType==MSG_URL_RECV || msgType==MSG_URL_SENT)
  {
    file.writeBlock((const char*)msgURL, msgURL.length());
    file.writeBlock((const char*)separator, separator.length());
  }
  file.writeBlock((const char*)msgBody, msgBody.length());
  if(msgBody.right(1) != "\n")
    file.writeBlock((const char*)separator, separator.length());
  file.close();
  return TRUE ;
}
