#ifndef _ICQMESSAGE_
#define _ICQMESSAGE_
 
#include <qstring.h>
#include <qfile.h>

enum icqMsgType { MSG_UNDEF, MSG_SENT, MSG_RECV, MSG_URL_SENT, MSG_URL_RECV,
   MSG_AUTH_RECV, MSG_AUTH_GRANT, MSG_AUTH_REFUSE } ;

typedef struct TmStr
{
  unsigned char hour;
  unsigned char minute;
  unsigned char day;
  unsigned char month;
  unsigned short year;
  TmStr()
  {
    hour = 0;
    minute = 0;
    day = 0;
    month = 0;
    year = 0;
  }
  TmStr(unsigned char phour, unsigned char pmin, unsigned char pday, unsigned char pmonth, unsigned short pyear)
  {
    hour = phour;
    minute = pmin;
    day = pday;
    month = pmonth;
    year = pyear;
  }
} TimeStr;

class icqMessage
{
public:
  icqMessage(unsigned long, TimeStr, const char*, icqMsgType);
  icqMessage(unsigned long, TimeStr, const char*, const char*, icqMsgType);
  icqMessage(icqMessage*);
  const char *body() const;
  unsigned long uin() const;
  const char *url() const;
  TimeStr time() const;
  int isNew() const;
  void expire();
  icqMsgType type() ;
  void setType(icqMsgType) ;
  int save(QString) ;
protected:
  icqMsgType msgType ;
  int msgNew;
  unsigned long msgUin;
  TimeStr msgTime;
  QString msgBody;
  QString msgURL;
};
#endif /* _ICQMESSAGE_ */
