// $Id: msgwindow.cpp,v 1.11 1998/12/08 16:24:58 denis Exp $
// $Log: msgwindow.cpp,v $
// Revision 1.11  1998/12/08 16:24:58  denis
// Cleaned up a little before releasing
//
// Revision 1.10  1998/11/23 10:07:51  denis
// WrapEdit workaround
//

#include <kapp.h>
#include <kiconloader.h>
#include <qmsgbox.h>
#include <qmovie.h>
#include <qregexp.h>
#include <qkeycode.h>
#include "msgwindow.h"
#include "mainwindow.h"

#include "msgwindow.moc"

MsgWindow::MsgWindow(const char *n, unsigned long u, const char *em, const char *msg) : QDialog()
{
  QString text;
  QPixmap infopix;
  KIconLoader *il = kapp->getIconLoader();
  setCaption("Send Message");
  tobox = new QGroupBox("To",this);
  sendbutton = new QPushButton("Send",this);
  sendbutton->setAccel(Key_Return+CTRL) ;
  connect(sendbutton, SIGNAL(clicked()),SLOT(sendMessage()));
  cancelbutton = new QPushButton("Cancel",this);
  connect(cancelbutton, SIGNAL(clicked()),SLOT(cancelMessage()));
  uinline = new QLineEdit(this);
  uinline->setFocusPolicy(QWidget::NoFocus);
  uinlabel = new QLabel(uinline,"ICQ#:",this);
  handleline = new QLineEdit(this);
  handleline->setFocusPolicy(QWidget::NoFocus);
  handlelabel = new QLabel(handleline,"Handle:",this);
  emailline = new QLineEdit(this);
  emailline->setFocusPolicy(QWidget::NoFocus);
  emaillabel = new QLabel(emailline,"EMail:",this);
  infobutton = new QPushButton(this);
  infopix = il->loadIcon("info.xpm");
  infobutton->setPixmap(infopix);
  infobutton->resize(infopix.width()+6, infopix.height()+6);
  connect(infobutton, SIGNAL(clicked()), SLOT(infoRequest()));
  editbox = new WrapEdit(this);
  editbox->setWraping(TRUE);
  editbox->setLimit(450);
  editlabel = new QLabel(editbox,"Enter Message:",this);
  updateanim = new QLabel(this);
  QString filename = kapp->kde_datadir()+"/"+kapp->appName()+"/pics/search.gif";
  updateanim->setMovie(QMovie((const char*)filename));
  updateanim->movie()->pause();
  setName(n);
  setUIN(u);
  setEMail(em);
  if(msg)
  {
    text = msg;
    if(((MainWindow*)(kapp->topWidget()))->isQuote())
    {
      text.replace(QRegExp("\n"), "\n> ");
      text = "> "+text;
      editbox->setText(text);
    }
    setMessage(text);
  }
  editbox->setFocus();
  resize(500,250);
  setMinimumSize(400,250);
  sendSeq = -1;
}

MsgWindow::~MsgWindow()
{
  if(sendbutton)
    delete sendbutton;
  if(cancelbutton)
    delete cancelbutton;
  if(tobox)
    delete tobox;
  if(uinlabel)
    delete uinlabel;
  if(handlelabel)
    delete handlelabel;
  if(emaillabel)
    delete emaillabel;
  if(uinline)
    delete uinline;
  if(handleline)
    delete handleline;
  if(emailline)
    delete emailline;
  if(infobutton)
    delete infobutton;
  if(editbox)
    delete editbox;
  if(editlabel)
    delete editlabel;
  if(updateanim)
    delete updateanim;
}

void MsgWindow::resizeEvent(QResizeEvent *re)
{
  QDialog::resizeEvent(re);
  QSize uinlblsize,handlelblsize,emaillblsize,toboxsize,editlblsize,btn1size,btn2size;
  toboxsize.setWidth(width()-6);
  uinlblsize = uinlabel->sizeHint();
  handlelblsize = handlelabel->sizeHint();
  emaillblsize = emaillabel->sizeHint();
  int w = (toboxsize.width()-uinlblsize.width()-handlelblsize.width()-emaillblsize.width()-75)/4;
  uinline->resize(w,uinline->sizeHint().height());
  handleline->resize(w,uinline->sizeHint().height());
  emailline->resize(w*2-7,uinline->sizeHint().height());
  uinlabel->resize(uinlblsize.width(),uinline->height());
  handlelabel->resize(handlelblsize.width(),handleline->height());
  emaillabel->resize(emaillblsize.width(),emailline->height());
  uinlabel->move(12,15);
  uinline->move(3+uinlabel->x()+uinlabel->width(),15);
  handlelabel->move(12+uinline->x()+uinline->width(),15);
  handleline->move(3+handlelabel->x()+handlelabel->width(),15);
  emaillabel->move(12+handleline->x()+handleline->width(),15);
  emailline->move(3+emaillabel->x()+emaillabel->width(),15);
  tobox->setGeometry(3,3,toboxsize.width(),uinline->height()+19);
  infobutton->move(10+emailline->x()+emailline->width(),15+(uinline->height()-infobutton->height())/2);
  btn1size = sendbutton->sizeHint();
  btn2size = cancelbutton->sizeHint();
  int h = QMAX(btn1size.height(),btn2size.height());
  w = QMAX(QMAX(btn1size.width(),btn2size.width()),75);
  sendbutton->setGeometry(width()/2-w-6,height()-h-12,w,h);
  cancelbutton->setGeometry(width()/2+6,height()-h-12,w,h);
  editlblsize = editlabel->sizeHint();
  editlabel->setGeometry(6,8+tobox->height(),editlblsize.width(),editlblsize.height());
  editbox->setGeometry(3,editlabel->y()+editlabel->height()+4,width()-6,height()-editlabel->y()-editlabel->height()-h-28);
  updateanim->setGeometry(width()-40,height()-40,32,32);
  updateanim->movie()->restart();
}

void MsgWindow::setUIN(unsigned long u)
{
  uin = u;
  QString text;
  text.setNum(uin);
  uinline->setText(text);
}

void MsgWindow::setName(const char *name)
{
  handleline->setText(name);
}

void MsgWindow::setEMail(const char *email)
{
  emailline->setText(email);
}

void MsgWindow::setMessage(const char *msg)
{
  message = msg;
}

void MsgWindow::sendMessage()
{
  QString tmp;
  if(((MainWindow*)(kapp->topWidget()))->isLogged())
  {
    tmp = editbox->text();
    if(((MainWindow*)(kapp->topWidget()))->isConvertCRLF())
      tmp.replace(QRegExp("\n"),"\r\n");
    sendSeq = icq_SendMessage(uin,(const char*)tmp);
    updateanim->movie()->unpause();
    sendbutton->setEnabled(FALSE);
  }
  else
    QMessageBox::warning(this, "Error", "You are not connected to the icq network!");
}

void MsgWindow::cancelMessage()
{
  if(sendSeq==-1)
  {
    hide();
    ((MainWindow*)(kapp->topWidget()))->delSendWin(this);
  }
  else
    stopCommand();
}

void MsgWindow::closeEvent(QCloseEvent *ce)
{
  QDialog::closeEvent(ce);
  ((MainWindow*)(kapp->topWidget()))->delSendWin(this);
}

void MsgWindow::infoRequest()
{
  ContactItem tmpitem, *item = ((MainWindow*)(kapp->topWidget()))->listWidget()->getInfoByUIN(uin);
  if(item)
    if(((MainWindow*)(kapp->topWidget()))->listWidget()->isUINNotInList(uin))
      ((MainWindow*)(kapp->topWidget()))->infoShow(*item, FALSE);
    else
      ((MainWindow*)(kapp->topWidget()))->infoWindow(uin);
  else
  {
    tmpitem.uin = uin;
    ((MainWindow*)(kapp->topWidget()))->infoShow(tmpitem, FALSE);
  }
}

long MsgWindow::seq()
{
  return sendSeq;
}

void MsgWindow::stopCommand()
{
  updateanim->movie()->pause();
  sendbutton->setEnabled(TRUE);
  sendSeq = -1;
}

void MsgWindow::saveHistory()
{
  time_t curtm = time(0L);
  struct tm *t = localtime(&curtm);
  TimeStr time(t->tm_hour,t->tm_min,t->tm_mday,t->tm_mon+1,t->tm_year+1900) ;

  icqMessage msg(uin,time,editbox->text(),MSG_SENT) ;
  QString historypath = ((MainWindow*)(kapp->topWidget()))->contactsDir() ;
  msg.save(historypath) ;
  ((MainWindow*)(kapp->topWidget()))->updateHistoryWindows(msg.uin()) ;
}
