// $Id: prefother.cpp,v 1.3 1998/12/08 16:26:52 denis Exp $
// $Log: prefother.cpp,v $
// Revision 1.3  1998/12/08 16:26:52  denis
// Reconnect on disconnect preference option added
// Cleaned up a little before releasing
//

#include "prefother.h"

#include "prefother.moc"

OtherWidget::OtherWidget(QWidget *parent) : QWidget(parent)
{
  mainlabel = new QLabel("Enter Other Settings:",this);
  otherbox = new QGroupBox("Other", this);
  recodebox = new QCheckBox("Cyrillic koi8-r - cp1251 recoding", this);
  closebox = new QCheckBox("Close Receive window when replying", this);
  crlfbox = new QCheckBox("Convert <LF> to <CR><LF>", this);
  quotebox = new QCheckBox("Quote original message when replying", this);
  reconbox = new QCheckBox("Reconnect on disconnect", this);
}

OtherWidget::~OtherWidget()
{
  if(mainlabel)
    delete mainlabel;
  if(recodebox)
    delete recodebox;
  if(closebox)
    delete closebox;
  if(crlfbox)
    delete crlfbox;
  if(quotebox)
    delete quotebox;
  if(reconbox)
    delete reconbox;
  if(otherbox)
    delete otherbox;
}

void OtherWidget::resizeEvent(QResizeEvent *re)
{
  QSize mainlblsize, recodeboxsize, closeboxsize, crlfboxsize, quoteboxsize, reconboxsize;
  QWidget::resizeEvent(re);
  mainlblsize = mainlabel->sizeHint();
  mainlabel->setGeometry(10,10,mainlblsize.width(),mainlblsize.height());
  otherbox->setGeometry(7,30,width()-13,height()-37);
  recodeboxsize = recodebox->sizeHint();
  closeboxsize = closebox->sizeHint();
  crlfboxsize = crlfbox->sizeHint();
  quoteboxsize = quotebox->sizeHint();
  reconboxsize = reconbox->sizeHint();
  int h = QMAX(QMAX(QMAX(recodeboxsize.height(),closeboxsize.height()),
                    QMAX(crlfboxsize.height(),quoteboxsize.height())),reconboxsize.height());
  int w = QMAX(QMAX(QMAX(recodeboxsize.width(),closeboxsize.width()),
                    QMAX(crlfboxsize.width(),quoteboxsize.width())),reconboxsize.width());
  recodebox->resize(w, h);
  closebox->resize(w, h);
  crlfbox->resize(w, h);
  quotebox->resize(w, h);
  reconbox->resize(w, h);
  int mh = (otherbox->height()-20)/5;
  recodebox->move(15,otherbox->y()+mh/2-h/2+15);
  closebox->move(15,otherbox->y()+mh+mh/2-h/2+15);
  crlfbox->move(15,otherbox->y()+mh*2+mh/2-h/2+15);
  quotebox->move(15,otherbox->y()+mh*3+mh/2-h/2+15);
  reconbox->move(15,otherbox->y()+mh*4+mh/2-h/2+15);
}

void OtherWidget::setInfo(int rus, int closereply, int crlf, int quote, int recon)
{
  recodebox->setChecked(rus);
  closebox->setChecked(closereply);
  crlfbox->setChecked(crlf);
  quotebox->setChecked(quote);
  reconbox->setChecked(recon);
}

int OtherWidget::rus()
{
  return recodebox->isChecked();
}

int OtherWidget::closereply()
{
  return closebox->isChecked();
}

int OtherWidget::crlf()
{
  return crlfbox->isChecked();
}

int OtherWidget::quote()
{
  return quotebox->isChecked();
}

int OtherWidget::reconnect()
{
  return reconbox->isChecked();
}
