// $Id: urlsndwin.cpp,v 1.6 1998/12/08 16:33:51 denis Exp $
// $Log: urlsndwin.cpp,v $
// Revision 1.6  1998/12/08 16:33:51  denis
// Cleaned up a little before releasing
//

#include <kapp.h>
#include <kiconloader.h>
#include <qmsgbox.h>
#include <qmovie.h>
#include <qregexp.h>
#include <qkeycode.h>
#include "urlsndwin.h"
#include "mainwindow.h"
#include "icqmessage.h"

#include "urlsndwin.moc"

URLSndWindow::URLSndWindow(const char *n, unsigned long u, const char *em) : QDialog()
{
  QString text;
  QPixmap infopix;
  KIconLoader *il = kapp->getIconLoader();
  setCaption("Send URL");
  tobox = new QGroupBox("To",this);
  sendbutton = new QPushButton("Send",this);
  sendbutton->setAccel(Key_Return+CTRL) ;
  connect(sendbutton, SIGNAL(clicked()),SLOT(sendURL()));
  cancelbutton = new QPushButton("Cancel",this);
  connect(cancelbutton, SIGNAL(clicked()),SLOT(cancelURL()));
  uinline = new QLineEdit(this);
  uinline->setFocusPolicy(QWidget::NoFocus);
  uinlabel = new QLabel(uinline,"ICQ#:",this);
  handleline = new QLineEdit(this);
  handleline->setFocusPolicy(QWidget::NoFocus);
  handlelabel = new QLabel(handleline,"Handle:",this);
  emailline = new QLineEdit(this);
  emailline->setFocusPolicy(QWidget::NoFocus);
  emaillabel = new QLabel(emailline,"EMail:",this);
  infobutton = new QPushButton(this);
  infopix = il->loadIcon("info.xpm");
  infobutton->setPixmap(infopix);
  infobutton->resize(infopix.width()+6, infopix.height()+6);
  connect(infobutton, SIGNAL(clicked()), SLOT(infoRequest()));
  urlbox = new QLineEdit(this);
  urllabel = new QLabel(urlbox,"Select/Enter URL:", this);
  editbox = new QMultiLineEdit(this);
  editlabel = new QLabel(editbox,"Enter URL Description:",this);
  updateanim = new QLabel(this);
  QString filename = kapp->kde_datadir()+"/"+kapp->appName()+"/pics/search.gif";
  updateanim->setMovie(QMovie((const char*)filename));
  updateanim->movie()->pause();
  setName(n);
  setUIN(u);
  setEMail(em);
  urlbox->setFocus();
  resize(350,250);
  setMinimumSize(350,250);
  sendSeq = -1;
}

URLSndWindow::~URLSndWindow()
{
  if(sendbutton)
    delete sendbutton;
  if(cancelbutton)
    delete cancelbutton;
  if(tobox)
    delete tobox;
  if(uinlabel)
    delete uinlabel;
  if(handlelabel)
    delete handlelabel;
  if(emaillabel)
    delete emaillabel;
  if(uinline)
    delete uinline;
  if(handleline)
    delete handleline;
  if(emailline)
    delete emailline;
  if(infobutton)
    delete infobutton;
  if(editbox)
    delete editbox;
  if(editlabel)
    delete editlabel;
  if(urlbox)
    delete urlbox;
  if(urllabel)
    delete urllabel;
  if(updateanim)
    delete updateanim;
}

void URLSndWindow::resizeEvent(QResizeEvent *re)
{
  QDialog::resizeEvent(re);
  QSize uinlblsize,handlelblsize,emaillblsize,toboxsize,editlblsize,btn1size,btn2size,urllblsize,urlboxsize;
  toboxsize.setWidth(width()-6);
  uinlblsize = uinlabel->sizeHint();
  handlelblsize = handlelabel->sizeHint();
  emaillblsize = emaillabel->sizeHint();
  int wl = QMAX(uinlblsize.width(),emaillblsize.width());
  int w = (toboxsize.width()-uinlblsize.width()-handlelblsize.width()-36)/2;
  uinline->resize(w,uinline->sizeHint().height());
  handleline->resize(w,uinline->sizeHint().height());
  emailline->resize(toboxsize.width()-infobutton->width()-62,uinline->sizeHint().height());
  uinlabel->resize(wl,uinline->height());
  handlelabel->resize(handlelblsize.width(),handleline->height());
  emaillabel->resize(wl,emailline->height());
  uinlabel->move(12,15);
  uinline->move(3+uinlabel->x()+uinlabel->width(),15);
  handlelabel->move(12+uinline->x()+uinline->width(),15);
  handleline->move(3+handlelabel->x()+handlelabel->width(),15);
  emaillabel->move(12,20+uinline->height());
  emailline->move(3+emaillabel->x()+emaillabel->width(),20+uinline->height());
  tobox->setGeometry(3,3,toboxsize.width(),uinline->height()+emailline->height()+23);
  infobutton->move(7+emailline->x()+emailline->width(),emailline->y()+(emailline->height()-infobutton->height())/2);
  btn1size = sendbutton->sizeHint();
  btn2size = cancelbutton->sizeHint();
  int h = QMAX(btn1size.height(),btn2size.height());
  w = QMAX(QMAX(btn1size.width(),btn2size.width()),75);
  sendbutton->setGeometry(width()/2-w-6,height()-h-12,w,h);
  cancelbutton->setGeometry(width()/2+6,height()-h-12,w,h);
  urllblsize = urllabel->sizeHint();
  urlboxsize = urlbox->sizeHint();
  urllabel->setGeometry(6,8+tobox->height(),urllblsize.width(),urllblsize.height());
  urlbox->setGeometry(3,urllabel->y()+urllabel->height()+4,width()-6,urlboxsize.height());
  editlblsize = editlabel->sizeHint();
  editlabel->setGeometry(6,5+urlbox->y()+urlbox->height(),editlblsize.width(),editlblsize.height());
  editbox->setGeometry(3,editlabel->y()+editlabel->height()+4,width()-6,height()-editlabel->y()-
                       editlabel->height()-h-28);
  updateanim->setGeometry(width()-40,height()-40,32,32);
  updateanim->movie()->restart();
}

void URLSndWindow::setUIN(unsigned long u)
{
  uin = u;
  QString text;
  text.setNum(uin);
  uinline->setText(text);
}

void URLSndWindow::setName(const char *name)
{
  handleline->setText(name);
}

void URLSndWindow::setEMail(const char *email)
{
  emailline->setText(email);
}

void URLSndWindow::sendURL()
{
  QString tmp;
  if(((MainWindow*)(kapp->topWidget()))->isLogged())
  {
    tmp = editbox->text();
    if(((MainWindow*)(kapp->topWidget()))->isConvertCRLF())
      tmp.replace(QRegExp("\n"),"\r\n");
    sendSeq = icq_SendURL(uin,(const char*)urlbox->text(),(const char*)tmp);
    updateanim->movie()->unpause();
    sendbutton->setEnabled(FALSE);
  }
  else
    QMessageBox::warning(this, "Error", "You are not connected to the icq network!");
}

void URLSndWindow::cancelURL()
{
  if(sendSeq==-1)
  {
    hide();
    ((MainWindow*)(kapp->topWidget()))->delURLSendWin(this);
  }
  else
    stopCommand();
}

void URLSndWindow::closeEvent(QCloseEvent *ce)
{
  QDialog::closeEvent(ce);
  ((MainWindow*)(kapp->topWidget()))->delURLSendWin(this);
}

void URLSndWindow::infoRequest()
{
  ContactItem tmpitem, *item = ((MainWindow*)(kapp->topWidget()))->listWidget()->getInfoByUIN(uin);
  if(item)
    if(((MainWindow*)(kapp->topWidget()))->listWidget()->isUINNotInList(uin))
      ((MainWindow*)(kapp->topWidget()))->infoShow(*item, FALSE);
    else
      ((MainWindow*)(kapp->topWidget()))->infoWindow(uin);
  else
  {
    tmpitem.uin = uin;
    ((MainWindow*)(kapp->topWidget()))->infoShow(tmpitem, FALSE);
  }
}

long URLSndWindow::seq()
{
  return sendSeq;
}

void URLSndWindow::stopCommand()
{
  updateanim->movie()->pause();
  sendbutton->setEnabled(TRUE);
  sendSeq = -1;
}

void URLSndWindow::saveHistory()
{
  time_t curtm = time(0L);
  struct tm *t = localtime(&curtm);
  TimeStr time(t->tm_hour,t->tm_min,t->tm_mday,t->tm_mon+1,t->tm_year+1900) ;

  icqMessage msg(uin,time,editbox->text(),MSG_URL_SENT) ;
  QString historypath = ((MainWindow*)(kapp->topWidget()))->contactsDir() ;
  msg.save(historypath) ;
  ((MainWindow*)(kapp->topWidget()))->updateHistoryWindows(msg.uin()) ;
}
