// $Id: useritem.cpp,v 1.13 1998/12/08 16:34:58 denis Exp $
// $Log: useritem.cpp,v $
// Revision 1.13  1998/12/08 16:34:58  denis
// getFirstUnreadMsgType method added
// Cleaned up a little before releasing
//
// Revision 1.12  1998/11/25 12:04:18  denis
// Trying to catch QGDict::look: Attempt to insert null item
//

#include <kapp.h>
#include <kiconloader.h>
#include "useritem.h"
#include "mainwindow.h"

UserItem::UserItem(ContactItem item) : WBlinkListBoxItem()
{
  KIconLoader *loader = kapp->getIconLoader();
  info = item;
  itype = tpUser;
  pm_last = loader->loadIcon("gray.xpm");
  pm_stat = loader->loadIcon("null.xpm");

  pmap_null = loader->loadIcon("null.xpm");
  pmap_msg = loader->loadIcon("message.xpm");
  pmap_url = loader->loadIcon("url.xpm");

  setPaintMode(VANISH) ;
  setPixmap(1,pmap_null) ;
  setPixmap(0,pmap_msg) ;
  
  messageList = new QList<icqMessage> ;
  listOwner = 1 ;
}

UserItem::UserItem(itType t) : WBlinkListBoxItem()
{
  itype = t;
  KIconLoader *loader = kapp->getIconLoader();
  messageList = 0L ;
  listOwner = 0 ;
  switch(t)
  {
    case tpOnSeparator:
      info.nick = "Online";
      break;
    case tpOffSeparator:
      info.nick = "Offline";
      break;
    case tpNILSeparator:
      info.nick = "Not In List";
      break;
    case tpAuthSeparator:
      info.nick = "Authorize";
      break;
    case tpSystem:
      info.nick = "System";
      pm_last = loader->loadIcon("gray.xpm");
      pm_stat = loader->loadIcon("null.xpm");
      break;
    case tpUser:
      info.nick = "Unknown";
      pm_last = loader->loadIcon("gray.xpm");
      pm_stat = loader->loadIcon("null.xpm");
      break;
  }
}

UserItem::UserItem(UserItem *item) : WBlinkListBoxItem()
{
  char buf[256];
  KIconLoader *loader = kapp->getIconLoader();
  info = item->getInfo();
  itype = item->type();
  messageList = item->getListPtr();

  pmap_null = loader->loadIcon("null.xpm");
  pmap_msg = loader->loadIcon("message.xpm");
  pmap_url = loader->loadIcon("url.xpm");

  setPaintMode(VANISH) ;
  setPixmap(1,pmap_null) ;
  setPixmap(0,pmap_msg) ;

  listOwner = 0 ;

  if(itype!=tpOffSeparator && itype!=tpOnSeparator && itype!=tpNILSeparator)
  {
    if(info.msglast == LAST_NONE)
      pm_last = loader->loadIcon("gray.xpm");
    if(info.msglast == LAST_MSG)
      pm_last = loader->loadIcon("msglast.xpm");
    if(info.msglast == LAST_URL)
      pm_last = loader->loadIcon("urllast.xpm");

    switch(info.status & 0x01FF) // 0xFFFF
    {
      case STATUS_ONLINE:
      case 0x01FF: // 0xFFFF
        pm_stat = loader->loadIcon("null.xpm");
        break;
      case STATUS_AWAY:
        pm_stat = loader->loadIcon("uaway.xpm");
        break;
      case STATUS_NA:
        pm_stat = loader->loadIcon("una.xpm");
        break;
      case STATUS_DND:
        pm_stat = loader->loadIcon("udnd.xpm");
        break;
      case STATUS_OCCUPIED:
        pm_stat = loader->loadIcon("uoccupied.xpm");
        break;
      case STATUS_FREE_CHAT:
        pm_stat = loader->loadIcon("ufreechat.xpm");
        break;
      case STATUS_INVISIBLE:
      case STATUS_INVISIBLE_2:
        pm_stat = loader->loadIcon("uprivacy.xpm");
        break;
      default:
        sprintf(buf, "User %s has unhandled status value %lu. Please report it to the authors.\n",(const char*)info.nick,info.status);
        ((MainWindow*)(kapp->topWidget()))->logEvent(time(0L), ICQ_LOG_ERROR, buf);
        break;
    }
  }
}

UserItem::~UserItem()
{
  if(listOwner)
  {
    if(messageList)
      messageList->clear();
    delete messageList ;
  }
}

const QPixmap *UserItem::pixmap_last()
{
  return &pm_last;
}

const QPixmap *UserItem::pixmap_stat()
{
  return &pm_stat;
}

void UserItem::paint(QPainter *p)
{

  QFontMetrics fm = p->fontMetrics();
  if(itype==tpOffSeparator || itype==tpOnSeparator || itype==tpNILSeparator)
  {
    int w = ((MainWindow*)(kapp->topWidget()))->listWidget()->width()-5;
    p->setPen(QColor(white));
    p->drawLine(0,fm.lineSpacing()/2,w/2-fm.width(info.nick)/2-6,fm.lineSpacing()/2);
    p->drawLine(w/2+fm.width(info.nick)/2+5,fm.lineSpacing()/2,w,fm.lineSpacing()/2);
    p->setPen(QColor(black));
    p->drawLine(0,fm.lineSpacing()/2-1,w/2-fm.width(info.nick)/2-6,fm.lineSpacing()/2-1);
    p->drawLine(w/2+fm.width(info.nick)/2+5,fm.lineSpacing()/2-1,w,fm.lineSpacing()/2-1);
    p->drawText(0,0,w,fm.lineSpacing(),AlignCenter,info.nick);
  }
  else
  {
    if(isBlinkingFlag)
    {
      const QPixmap *pm_active = activePixmap();
      setPixmapXY(3, (QMAX(pm_active->height()+6, fm.lineSpacing())-pm_active->height())/2) ;
      WBlinkListBoxItem::paint(p) ;
    }
    else
    {
      p->drawPixmap(3, (QMAX(pm_last.height()+6, fm.lineSpacing())-pm_last.height())/2, pm_last);
      p->drawPixmap(3, (QMAX(pm_stat.height()+6, fm.lineSpacing())-pm_stat.height())/2, pm_stat);
    }

    int yPos;
    if (pm_last.height() < fm.height())
      yPos = fm.ascent() + fm.leading()/2;
    else
      yPos = (pm_last.height()+6)/2 - fm.height()/2 + fm.ascent();
    p->drawText(pm_last.width() + 7, yPos, Name());
  }
}

int UserItem::height(const QListBox *lb ) const
{
  return QMAX(pm_last.height()+6, lb->fontMetrics().lineSpacing());
}

int UserItem::width(const QListBox *lb ) const
{
  return pm_last.width() + lb->fontMetrics().width(info.nick) + 6;
}

itType UserItem::type()
{
  return itype;
}

unsigned long UserItem::UIN()
{
  return info.uin;
}

const char *UserItem::Name()
{
  if(info.alias.isEmpty())
    if(!info.nick.isEmpty() && info.nick!="N/A")
      return info.nick;
    else if(!info.firstName.isEmpty() && info.firstName!="N/A")
      return info.firstName;
    else if(!info.lastName.isEmpty() && info.lastName!="N/A")
      return info.lastName;
    else if(!info.email.isEmpty() && info.email!="N/A")
      return info.email;
    else
    {
      QString txt;
      txt.setNum(info.uin);
      return txt;
    }
  return info.alias;
}

const char *UserItem::alias()
{
  return info.alias;
}

const char *UserItem::nick()
{
  return info.nick;
}

const char *UserItem::email()
{
  return info.email;
}

const char *UserItem::first()
{
  return info.firstName;
}

const char *UserItem::last()
{
  return info.lastName;
}

ContactItem UserItem::getInfo()
{
  return info;
}

ContactItem *UserItem::getInfoPtr()
{
  return &info;
}

void UserItem::setStatus(unsigned long status)
{
  info.status = status;
}

unsigned long UserItem::getStatus()
{
  return info.status;
}

void UserItem::setMsgLast(lastEvent l)
{
  info.msglast = l ;
}

void UserItem::addMsg(icqMessage *msg)
{
  messageList->append(msg);
  if(msg->type() == MSG_RECV)
    setMsgLast(LAST_MSG) ;
  if(msg->type() == MSG_URL_RECV)
    setMsgLast(LAST_URL) ;

  QString historypath = ((MainWindow*)(kapp->topWidget()))->contactsDir() ;
  msg->save(historypath) ;
  ((MainWindow*)(kapp->topWidget()))->updateHistoryWindows(msg->uin()) ;
}
/*
icqMessage *UserItem::getFirstUnreadMsg()
{
  icqMessage *msg;
  for(msg = messageList->first(); msg != 0L; msg = messageList->next())
    if(msg->isNew())
    {
      msg->expire();
      updatePixmap() ;
      return msg;
    }
  return 0L;
}

// Why is it Last and not First? ;)
icqMsgType UserItem::getLastUnreadMsgType()
{
  icqMessage *msg;
  for(msg = messageList->last(); msg != 0L; msg = messageList->prev())
    if(msg->isNew())
    {
      return msg->type();
    }
  return MSG_UNDEF ;
}
*/
icqMsgType UserItem::getFirstUnreadMsgType()
{
  icqMessage *msg;
  for(msg = messageList->first(); msg != 0L; msg = messageList->next())
    if(msg->isNew())
    {
      return msg->type();
    }
  return MSG_UNDEF ;
}

int UserItem::getNumUnreadMsgs()
{
  icqMessage *msg;
  int msgCount = 0;
  for(msg = messageList->first(); msg != 0L; msg = messageList->next())
    if(msg->isNew())
      msgCount++;
  return msgCount;
}

icqMessage *UserItem::getMsg(int n)
{
  return messageList->at(n);
}

int UserItem::getNumMsgs()
{
  return messageList->count();
}

void UserItem::updateInfo(const char *nick, const char* first, const char *last, const char *email, char auth)
{
  info.nick = nick;
  info.firstName = first;
  info.lastName = last;
  info.email = email;
  info.auth = auth;
  if(info.alias.isEmpty())
    if(!info.nick.isEmpty() && info.nick!="N/A")
      info.alias = info.nick;
    else if(!info.firstName.isEmpty() && info.firstName!="N/A")
      info.alias = info.firstName;
    else if(!info.lastName.isEmpty() && info.lastName!="N/A")
      info.alias = info.lastName;
    else if(!info.email.isEmpty() && info.email!="N/A")
      info.alias = info.email;
    else
      info.alias.setNum(info.uin);
}

QList<icqMessage> *UserItem::getListPtr()
{
  return messageList;
}

void UserItem::updatePixmap()
{
  icqMsgType t = getFirstUnreadMsgType(); // Last
  if(t == MSG_RECV)
    setPixmap(0,pmap_msg) ;
  if(t == MSG_URL_RECV)
    setPixmap(0,pmap_url) ;
}
