#ifndef _USERITEM_
#define _USERITEM_

#include <qlistbox.h>
#include <qpainter.h>
#include <qlist.h>
#include <icq.h>
#include "icqmessage.h"
#include "blinklistbox.h"

enum itType {tpOffSeparator, tpOnSeparator, tpNILSeparator, tpAuthSeparator, tpSystem, tpUser};
enum lastEvent { LAST_NONE, LAST_MSG, LAST_URL } ;

typedef struct ContItem
{
  unsigned long uin;
  QString nick;
  QString alias;
  QString firstName;
  QString lastName;
  QString email;
  unsigned long lastIp; /* Current/Last IP address */
  unsigned long realIp; /* Real IP address */
  unsigned long port;
  QString city;
  QString state;
  QString zip; /* Where can we get zip code? ;) */
  unsigned short country;
  char countryStat;
  QString homePage;
  unsigned char age;
  QString phone;
  unsigned char gender;
  QString about;
  QString notes;
  unsigned long status;
  unsigned char auth;
  QString historyDir;
  lastEvent msglast;
  int onlineAlert;
  int visibleUser;
  ContItem()
	{
    uin = 0;
    nick = "N/A";
    alias = "";
    firstName = "N/A";
    lastName = "N/A";
    email = "N/A";
		lastIp = 0;
		city = "N/A";
		state = "N/A";
		zip = "N/A";
		country = 0;
		countryStat = 0;
		homePage = "N/A";
		age = 0;
		phone = "N/A";
		gender = 0;
		about = "N/A";
		notes = "";
		status = (unsigned long)STATUS_OFFLINE;
		auth = 0;
		msglast = LAST_NONE ;
    onlineAlert = 0;
    visibleUser = 0;
	}
} ContactItem;

class UserItem : public WBlinkListBoxItem
{
public:
  UserItem(ContactItem item);
  UserItem(itType);
  UserItem(UserItem *);
  ~UserItem();
  virtual void paint(QPainter*);
  itType type();
  unsigned long UIN();
  const char *Name();
  const char *alias();
  const char *nick();
	const char *email();
	const char *first();
	const char *last();
  ContactItem getInfo();
	ContactItem *getInfoPtr();
  void setStatus(unsigned long);
  void setMsgLast(lastEvent);
  unsigned long getStatus();
  void addMsg(icqMessage*);
//  icqMessage *getFirstUnreadMsg();
//  icqMsgType getLastUnreadMsgType() ;
  icqMsgType getFirstUnreadMsgType() ;
  int getNumUnreadMsgs();
  icqMessage *getMsg(int);
  int getNumMsgs();
  void updateInfo(const char *,const char *,const char *,const char *,char);
  void updatePixmap() ;
  QList<icqMessage> *getListPtr();
protected:
  QPixmap pm_last, pm_stat;
  QPixmap pmap_null, pmap_msg, pmap_url ;
  ContactItem info;
  itType itype;
  QList<icqMessage> *messageList;
  int listOwner ;
  virtual int height(const QListBox *) const;
  virtual int width(const QListBox *) const;
  virtual const QPixmap *pixmap_last();
  virtual const QPixmap *pixmap_stat();
private:
};
#endif
