#include "kldap.h"

AttributeDialog::AttributeDialog(QWidget* parent, Kldapw* kldapw, int modifyType, char* dn, char* attributeName) : QDialog(parent, "Attribute Dialog", TRUE)
{
  this->kldapw = kldapw;
  this->modifyType = modifyType; // z.B. LDAP_MOD_ADD
  this->dn = dn; // z.B. oliver.mountpoint.ch
  this->attributeName = attributeName; // Name des zu modifizierenden Attributes

  setCaption("Add Attribute");

  QGridLayout* layout = new QGridLayout(this, 2, 3, 5);

  QLabel* lblValue = new QLabel("Attribute Name", this);

  txtValue = new QLineEdit(this);
  QPushButton* btnOK = new QPushButton("&OK", this);
  QPushButton* btnCancel = new QPushButton("&Cancel", this);

  layout->addWidget(lblValue, 0, 0);
  layout->addMultiCellWidget(txtValue, 0, 0, 1, 2);
  layout->addWidget(btnOK, 1, 1);
  layout->addWidget(btnCancel, 1, 2);

  txtValue->setFocus();

  QObject::connect(btnOK, SIGNAL(clicked()), SLOT(modify()));
  QObject::connect(btnCancel, SIGNAL(clicked()), SLOT(reject()));
  QObject::connect(txtValue, SIGNAL(returnPressed()), SLOT(modify()));

  resize(300, 75);
}

void AttributeDialog::modify()
{
  char* mod_type = "";
  char* value = "";
  int error;

  value  = ""; // value = NULL geht nicht!
  mod_type = (char*)txtValue->text();

  error = kldapw->modify(dn, modifyType, mod_type, value);

  if(error == 0)
  {
    accept();
  }
}
